@extends('master.authMaster')

@section('content')
    <div class="ledgers-page-sec bg-gray-100 col-span-12 lg:col-span-12 ledgers-details-page-sec">
        <div class="ledgers-page-wraper flex w-full bg-white shadow-md rounded-2xl overflow-hidden">
            <div class="w-full p-4">
                <div class="content-box">
                    <!-- Date Filter -->
                    <div class="flex justify-between items-center mb-4">

                        <div>
                            <h3 class="text-base font-medium text-black">
                                {{ ucfirst($expenseHeadName) }}
                            </h3>
                        </div>

                        <div class="flex gap-4 items-end">
                            <div>
                                <label for="from_date" class="text-sm">From Date</label>
                                <input type="date" id="from_date" class="border rounded p-2">
                            </div>
                            <div>
                                <label for="to_date" class="text-sm">To Date</label>
                                <input type="date" id="to_date" class="border rounded p-2">
                            </div>
                            <div class="flex items-end gap-2">
                                <button type="button" id="filterBtn"
                                    class="bg-blue-600 text-white px-4 py-2 rounded shadow">Filter</button>
                                <button type="button" id="clearBtn"
                                    class="bg-gray-500 text-white px-4 py-2 rounded shadow">Clear</button>
                            </div>
                        </div>

                    </div>


                    <div class="sngl-box">
                        <!-- Cash Payments -->
                        <div class="sngl-cart">
                            <h4 class="text-base font-medium mb-2 text-black mb-4">Cash Payments</h4>
                            <table class="w-full text-left border-collapse shadow-sm rounded-lg overflow-hidden mb-3">
                                <thead>
                                    <tr class="bg-gray-100 text-gray-700">
                                        <th class="p-3">Date</th>
                                        <th class="p-3">Expense Head Group</th>
                                        <th class="p-3">Narration</th>
                                        <th class="p-3 text-right">Amount</th>
                                    </tr>
                                </thead>
                                <tbody id="cashTable" class="divide-y"></tbody>
                                <tfoot>
                                    <tr class="bg-gray-100 text-black">
                                        <td></td>
                                        <td class="p-3 text-right font-semibold">Total</td>
                                        <td id="cashTotal" class="p-3 text-right font-bold">0.00</td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                        <!-- Bank Payments -->
                        <div class="sngl-cart">
                            <h4 class="text-base font-medium mb-2 text-black mb-4">Bank Payments</h4>
                            <table class="w-full text-left border-collapse shadow-sm rounded-lg overflow-hidden mb-3">
                                <thead>
                                    <tr class="bg-gray-100 text-gray-700">
                                        <th class="p-3">Date</th>
                                        <th class="p-3">Expense Head Group</th>
                                        <th class="p-3">Narration</th>
                                        <th class="p-3 text-right">Amount</th>
                                    </tr>
                                </thead>
                                <tbody id="bankTable" class="divide-y"></tbody>
                                <tfoot>
                                    <tr class="bg-gray-100 text-black">
                                        <td></td>
                                        <td></td>
                                        <td class="p-3 text-right font-semibold">Total</td>
                                        <td id="bankTotal" class="p-3 text-right font-bold">0.00</td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                        <!-- Grand Total -->
                        <div class="mt-4">
                            <table class="w-full text-left border-collapse shadow-sm rounded-lg overflow-hidden">
                                <tfoot>
                                    <tr class="bg-gray-200 text-black">
                                        <td class="p-3 text-right font-semibold">Grand Total</td>
                                        <td id="grandTotal" class="p-3 text-right font-bold">0.00</td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>

                </div>
                <div class="mt-6">
                    <button onclick="history.back()"
                        class="px-4 py-2 rounded-lg bg-gray-500 hover:bg-gray-600 text-white shadow text-sm transition">
                        ← Back
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const allExpenses = @json($expenses);
            const expenseHeadGroupName = @json($expenseHeadGroupName);

            function parseDateOnly(dateStr) {
                const parts = dateStr.split("-");
                return new Date(parts[0], parts[1] - 1, parts[2]);
            }

            function renderTables(fromDate = null, toDate = null) {
                const cashBody = document.getElementById("cashTable");
                const bankBody = document.getElementById("bankTable");
                const cashTotalCell = document.getElementById("cashTotal");
                const bankTotalCell = document.getElementById("bankTotal");
                const grandTotalCell = document.getElementById("grandTotal");

                cashBody.innerHTML = "";
                bankBody.innerHTML = "";

                let cashTotal = 0,
                    bankTotal = 0;

                allExpenses.forEach(expense => {
                    const dbDateStr = expense.transaction_date.substring(0, 10);
                    const date = parseDateOnly(dbDateStr);

                    const from = fromDate ? parseDateOnly(fromDate) : null;
                    const to = toDate ? parseDateOnly(toDate) : null;

                    if (from && date < from) return;
                    if (to && date > to) return;

                    const row = `
                            <tr>
                                <td class="p-3">${date.toLocaleDateString('en-GB')}</td>
                                <td class="p-3">${expenseHeadGroupName ? expenseHeadGroupName : '-'}</td>
                                <td class="p-3">${expense.transaction_narration ? expense.transaction_narration : '-'}</td>
                                <td class="p-3 text-right">${parseFloat(expense.transaction_amount).toFixed(2)}</td>
                            </tr>
                        `;

                    if (expense.payment_type_id == 1) {
                        cashBody.insertAdjacentHTML("beforeend", row);
                        cashTotal += parseFloat(expense.transaction_amount);
                    } else {
                        bankBody.insertAdjacentHTML("beforeend", row);
                        bankTotal += parseFloat(expense.transaction_amount);
                    }
                });

                cashTotalCell.textContent = cashTotal.toFixed(2);
                bankTotalCell.textContent = bankTotal.toFixed(2);
                if (grandTotalCell) {
                    grandTotalCell.textContent = (cashTotal + bankTotal).toFixed(2);
                }
            }

            renderTables();

            document.getElementById("filterBtn").addEventListener("click", function() {
                const fromDate = document.getElementById("from_date").value;
                const toDate = document.getElementById("to_date").value;

                if (fromDate && toDate && fromDate > toDate) {
                    alert("⚠️ From Date cannot be later than To Date");
                    return;
                }

                renderTables(fromDate, toDate);
            });

            document.getElementById("clearBtn").addEventListener("click", function() {
                document.getElementById("from_date").value = "";
                document.getElementById("to_date").value = "";
                renderTables();
            });
        });
    </script>
@endsection
