@extends('master.authMaster')

@section('content')
    <div class="intro-y col-span-12 lg:col-span-12">
        <!-- BEGIN: Bordered Table -->
        <div class="intro-y box mt-5">
            <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200">
                <h2 class="font-medium text-base mr-auto">
                    Roles
                </h2>

            </div>
            <div class="p-5" id="bordered-table">
                <div class="preview">
                    <div class="overflow-x-auto">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th class="border border-b-2 dark:border-dark-5 whitespace-no-wrap">Sl</th>
                                    <th class="border border-b-2 dark:border-dark-5 whitespace-no-wrap">Name</th>
                                    <th class="border border-b-2 dark:border-dark-5 whitespace-no-wrap">Status</th>
                                    <th class="border border-b-2 dark:border-dark-5 whitespace-no-wrap">Action</th>

                                </tr>
                            </thead>
                            <tbody>

                                @foreach ($roles as $key => $role)
                                    <tr>
                                        <td class="border">{{ $key + 1 }}</td>
                                        <td class="border">{{ $role->name }}</td>
                                        <td class="border">

                                            @if ($role->id != 1 && $role->status == 'active')
                                                <span
                                                    class="status-toggle button w-24 rounded-full mr-1 mb-2 bg-theme-9 text-white w-25 h-6"
                                                    style="cursor:pointer;">
                                                    {{ $role->status }}
                                                </span>
                                            @elseif($role->id != 1 && $role->status == 'inactive')
                                                <span
                                                    class="status-toggle button w-24 rounded-full mr-1 mb-2 bg-theme-6 text-white w-25 h-6"
                                                    style="cursor:pointer;">
                                                    {{ $role->status }}
                                                </span>
                                            @endif
                                        </td>
                                        <td class="border">edit</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
              
            </div>
        </div>
        <!-- END: Bordered Table -->
    </div>
@endsection
