@extends('master.authMaster')


@section('content')
    {{-- Form --}}

    <div class="intro-y col-span-12 lg:col-span-12">

        <!-- BEGIN: Select Options -->
        <div class="intro-y box mt-5">
            <!-- BEGIN: Horizontal Form -->
            <div class="intro-y box mt-5">
                <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                    <h2 class="font-medium text-base mr-auto">
                        Income Transaction
                    </h2>

                </div>
                <div class="p-5" id="horizontal-form">

                    <form id="incomeForm" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="preview">
                            {{-- <div class="grid grid-cols-12 gap-6 mt-5"> --}}
                            <div class="intro-y col-span-12 lg:col-span-12">
                                <!-- BEGIN: Input -->
                                <div class="intro-y box">

                                    <div class="p-5" id="input">
                                        <div class="preview">
                                            @php
                                                use Carbon\Carbon;
                                                $financialYear = \App\Models\AccountingYear::current();
                                                $orgId = \App\Models\Organisation::current()->organisation_id;

                                                [$startDate, $endDate] = explode(
                                                    ' to ',
                                                    $financialYear->accounting_year_financial,
                                                );

                                                $startDate = Carbon::createFromFormat('d-m-Y', trim($startDate));
                                                $endDate = Carbon::createFromFormat('d-m-Y', trim($endDate));

                                                $today = Carbon::today();

                                                if ($today->between($startDate, $endDate)) {
                                                    $maxDate = $today->toDateString();
                                                } else {
                                                    $maxDate = $endDate->toDateString();
                                                }

                                                $minDate = $startDate->toDateString();
                                            @endphp
                                            <div class="w-full -ml-4 -mr-4 flex flex-wrap">

                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Organisation <span style="color: red">*</span></label>
                                                        <select id="organisation_id" name="organisation_id"
                                                            class="input w-full border mt-2 custm-drpdwn" disabled>
                                                            <option value="">-- Select Organisation --</option>
                                                            @foreach ($organisations as $organisation)
                                                                <option value="{{ $organisation->organisation_id }}"
                                                                    {{ old('organisation_id', $orgId) == $organisation->organisation_id ? 'selected' : '' }}>
                                                                    {{ $organisation->organisation_name }}
                                                                </option>
                                                            @endforeach
                                                        </select>

                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-organisation"></div>
                                                    </div>
                                                </div>

                                                <input type="hidden" value="{{ $orgId }}" id="organisation_id"
                                                    name="organisation_id">
                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3" id="accountTypeWrapper">
                                                        <label>Division<span style="color: red">*</span></label>
                                                        <select id="account_type_id" name="account_type_id"
                                                            class="input w-full border mt-2 custm-drpdwn">
                                                            <option value="">-- Select Division --</option>
                                                        </select>
                                                        <small id="accountTypeMsg" class="text-red-500"
                                                            style="display:none;">
                                                            Please select organisation first
                                                        </small>
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-account-type"></div>

                                                    </div>
                                                </div>
                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label class="items-center justify-between"> Income Head<span
                                                                style="color: red">*</span>

                                                        </label>
                                                        <select id="income_head_id" name="income_head_id"
                                                            class="input w-full border mt-2 custm-drpdwn">
                                                            <option value="">-- Select Income Head --</option>
                                                            @foreach ($incomeHeads as $incomeHead)
                                                                <option value="{{ $incomeHead->income_head_id }} # {{ $incomeHead->income_head_group_id }}"
                                                                    {{ old('income_head_id') == $incomeHead->income_head_id ? 'selected' : '' }}>
                                                                    {{ $incomeHead->income_head_name }}
                                                                </option>
                                                            @endforeach
                                                        </select>

                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-income-head">
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Add Income Head Modal -->
                                                <div id="incomeHeadModal"
                                                    class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden z-50">
                                                    <div class="bg-white p-6 rounded-lg shadow-lg w-1/2">
                                                        <h2 class="text-lg font-bold mb-4">Add New Income Head</h2>

                                                        <div class="grid grid-cols-2 gap-4">
                                                            <div>
                                                                <label>Organisation <span
                                                                        class="text-red-500">*</span></label>
                                                                <select id="organisation_id_new2"
                                                                    class="w-full border p-2 rounded" disabled>
                                                                    <option value="">-- Select Organisation --
                                                                    </option>
                                                                    @foreach ($organisations as $org)
                                                                        <option value="{{ $org->organisation_id }}">
                                                                            {{ $org->organisation_name }}</option>
                                                                    @endforeach
                                                                </select>
                                                                <div class="text-red-500 text-sm error-message"
                                                                    id="error-organisation-id"></div>
                                                            </div>
                                                            <div>
                                                                <label>Division</label>
                                                                <select id="account_type_id_new" name="account_type_id_new"
                                                                    class="w-full border p-2 rounded custm-drpdwn">
                                                                    <option value="">-- Select Division --
                                                                    </option>
                                                                    @foreach ($accountTypes as $type)
                                                                        <option value="{{ $type->account_type_id }}">
                                                                            {{ $type->account_type_Name }}
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                                <div class="text-red-500 text-sm mt-1 error-message"
                                                                    id="error-account-type"></div>
                                                            </div>

                                                            <div>
                                                                <label>Income Head Group </label>
                                                                <select id="income_head_group_id"
                                                                    name="income_head_group_id"
                                                                    class="w-full border p-2 rounded custm-drpdwn">
                                                                    <option value="">-- Select Income Head Group --
                                                                    </option>
                                                                    @foreach ($incomeHeadGroups as $group)
                                                                        <option value="{{ $group->income_head_group_ID }}">
                                                                            {{ $group->income_head_group_Name }}
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                                <div class="text-red-500 text-sm mt-1 error-message"
                                                                    id="error-income-head-group"></div>
                                                            </div>

                                                            <div>
                                                                <label>Income Head Name <span
                                                                        style="color: red">*</span></label>
                                                                <input type="text" id="income_head_name"
                                                                    class="w-full border p-2 rounded">
                                                                <div class="text-red-500 text-sm mt-1 error-message"
                                                                    id="error-income-head-name"></div>
                                                            </div>
                                                        </div>

                                                        <div class="flex justify-end space-x-2 mt-6">
                                                            <button type="button" id="closeIncomeHeadModal"
                                                                class="px-4 py-2 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>
                                                            <button type="button" id="saveIncomeHead"
                                                                class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Save</button>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Success Modal -->
                                                <div id="incomeHeadSuccessModal"
                                                    class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                                    <div class="bg-white p-6 rounded-lg shadow-lg w-96 text-center">
                                                        <h2 class="text-lg font-bold mb-4">Success!</h2>
                                                        <p>Income head added successfully.</p>
                                                        <button type="button" id="incomeHeadCloseSuccessModal"
                                                            class="mt-4 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Close</button>
                                                    </div>
                                                </div>



                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Money Receipt No. </label>
                                                        <input type="text" class="input w-full border mt-2"
                                                            name="money_receipt_no" value="{{ old('money_receipt_no') }}"
                                                            placeholder="Enter Money Receipt Number">
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-money-receipt-number"></div>
                                                    </div>
                                                </div>
                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Transaction Amount (₹) <span
                                                                style="color: red">*</span></label>
                                                        <input type="text" class="input w-full border mt-2"
                                                            name="transaction_amount"
                                                            value="{{ old('transaction_amount') }}"
                                                            placeholder="Enter Transaction Amount">
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-transaction-amount"></div>
                                                    </div>
                                                </div>
                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Payment Method <span style="color: red">*</span> </label>
                                                        <select id="payment_type_id" name="payment_type_id"
                                                            class="input w-full border mt-2 custm-drpdwn">
                                                            <option value="">-- Select Payment Method --</option>

                                                            @foreach ($paymentTypes->where('parent_id', null) as $parent)
                                                                @php
                                                                    $children = $paymentTypes->where(
                                                                        'parent_id',
                                                                        $parent->id,
                                                                    );
                                                                @endphp

                                                                @if ($children->isEmpty())
                                                                    <option value="{{ $parent->id }}"
                                                                        {{ old('payment_type_id') == $parent->id ? 'selected' : '' }}>
                                                                        {{ $parent->name }}
                                                                    </option>
                                                                @else
                                                                    <optgroup label="{{ $parent->name }}">
                                                                        @foreach ($children as $child)
                                                                            <option value="{{ $child->id }}"
                                                                                {{ old('payment_type_id') == $child->id ? 'selected' : '' }}>
                                                                                {{ $child->name }}
                                                                            </option>
                                                                        @endforeach
                                                                    </optgroup>
                                                                @endif
                                                            @endforeach
                                                        </select>

                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-payment-type"></div>
                                                    </div>
                                                </div>
                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Date of Transaction <span
                                                                style="color: red">*</span></label>
                                                        <input type="date" class="input w-full border mt-2"
                                                            name="transaction_date" min="{{ $minDate }}"
                                                            max="{{ $maxDate }}"
                                                            value="{{ old('transaction_date', now()->toDateString()) }}"
                                                            onfocus="this.showPicker()" />
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-date">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Transaction Reference No.</label>
                                                        <input id="transaction_reference" type="text"
                                                            class="input w-full border mt-2" name="transaction_reference"
                                                            value="{{ old('transaction_reference') }}"
                                                            placeholder="Enter Transaction Reference" maxlength="20">
                                                        <div class="text-gray-500 text-xs mt-1">
                                                            Only letters and numbers allowed, 5–20 characters.
                                                        </div>
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-transaction-reference"></div>
                                                    </div>
                                                </div>

                                                <!-- Modal -->
                                                <div id="purposeModal"
                                                    class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                                    <div class="bg-white p-6 rounded-lg shadow-lg w-96">
                                                        <h2 class="text-lg font-bold mb-4">Add New Purpose</h2>
                                                        <input type="text" id="newPurpose"
                                                            class="input w-full border p-2 mb-4"
                                                            placeholder="Enter new purpose">

                                                        <div class="flex justify-end space-x-2">
                                                            <button type="button" id="closeModalPurpose"
                                                                class="px-4 py-2 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>
                                                            <button type="button" id="savePurpose"
                                                                class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Save</button>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Success Modal -->
                                                <div id="purposeSuccessModal"
                                                    class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                                    <div class="bg-white p-6 rounded-lg shadow-lg w-96 text-center">
                                                        <h2 class="text-lg font-bold mb-4">Success!</h2>
                                                        <p>Purpose added successfully.</p>
                                                        <button type="button" id="closeSuccessModal"
                                                            class="mt-4 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">
                                                            Close
                                                        </button>
                                                    </div>
                                                </div>
                                                <!-- Error Modal -->
                                                <div id="purposeErrorModal"
                                                    class="hidden fixed inset-0 flex items-center justify-center z-50 bg-black bg-opacity-50">
                                                    <div class="bg-white rounded-lg shadow-lg p-6 w-96">
                                                        <h2 class="text-lg font-semibold text-red-600 mb-2">Error</h2>
                                                        <p id="purposeErrorMessage" class="text-gray-700"></p>
                                                        <div class="flex justify-end mt-4">
                                                            <button type="button" id="closeErrorModal"
                                                                class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">
                                                                Close
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Transaction Narration </label>
                                                        <textarea class="input w-full border mt-2" name="transaction_narration" placeholder="Enter Transaction Narration">{{ old('transaction_narration') }}</textarea>
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-transaction-narration"></div>
                                                    </div>
                                                </div>

                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Upload Images / PDFs</label>
                                                        <input type="file" class="w-full border mt-2 p-2 rounded"
                                                            name="income_files[]" id="income_files"
                                                            accept="image/*,application/pdf" multiple>
                                                        <ul id="file-list" class="mt-2 text-sm text-gray-600 space-y-1">
                                                        </ul>
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-income-files"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- </div> --}}


                                <hr>
                                <hr>



                            </div>
                            <div class="sm:pl-5 mt-5">

                                <a href="{{ route('income.index') }}"><span
                                        class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600 mr-2">
                                        ← Back
                                    </span></a>
                                <button type="submit" class="button w-24 bg-theme-1 text-white">Save</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
            <!-- END: Horizontal Form -->
        </div>
        <!-- END: Select Options -->
    </div>
    {{-- <div class="intro-y col-span-12 lg:col-span-6">
    </div> --}}
    <script>
        //organisation and accountype checking start.
        let accountTypes = @json($accountTypes);
        let orgSelect = document.getElementById('organisation_id');
        let accSelect = document.getElementById('account_type_id');
        let msg = document.getElementById('accountTypeMsg');




        let oldOrg = "{{ old('organisation_id', $orgId) }}";
        let oldAcc = "{{ old('account_type_id') }}";

        function populateAccountTypes(oldOrg) {
            accSelect.innerHTML = '<option value="">-- Select Division --</option>';

            if (oldOrg) {
                let filtered = accountTypes.filter(at => at.organisation_id == oldOrg);

                if (filtered.length > 0) {
                    document.getElementById("accountTypeWrapper").style.display = "block";
                    filtered.forEach(at => {
                        let option = document.createElement('option');
                        option.value = at.account_type_id;
                        option.textContent = at.account_type_Name;

                        if (oldAcc == at.account_type_id) {
                            option.selected = true;
                        }
                        accSelect.appendChild(option);
                    });

                    accSelect.disabled = false;
                    msg.style.display = "none";
                } else {
                    accSelect.disabled = true;
                    msg.textContent = "No Division found for this organisation.";
                    msg.style.display = "block";
                    document.getElementById("accountTypeWrapper").style.display = "none";
                }
            } else {
                accSelect.disabled = true;
                msg.textContent = "Please select organisation first.";
                msg.style.display = "block";
            }
        }

        orgSelect.addEventListener('change', function() {
            populateAccountTypes(this.value);
        });

        accSelect.addEventListener('focus', function() {
            if (!orgSelect.value) {
                msg.textContent = "Please select organisation first.";
                msg.style.display = "block";
                setTimeout(() => msg.style.display = "none", 2000);
            }
        });

        if (oldOrg) {
            populateAccountTypes(oldOrg);
        }
        //organisation and accountype checking end.


        $(document).ready(function() {

            // console.log(purposes);
            $("input[name='type']").on("click", function(e) {
                const orgId = $("#organisation_id").val();
                const accountTypeId = $("#account_type_id").val();
                const $errorDiv = $("#error-organisation");
                const $errorDiv2 = $("#error-account-type");

                $errorDiv.text("");

                if (!orgId) {
                    e.preventDefault();
                    $errorDiv.text("Please select Organisation first.");
                    return;
                }

                if (orgId != 2 && !accountTypeId) {
                    e.preventDefault();
                    $errorDiv2.text("Please select Division first.");
                    return;
                }
            });

            $("#organisation_id").on("change", function() {
                $("#error-organisation").text("");
            });
            $("#account_type_id").on("change", function() {
                $("#error-account-type").text("");
            });

            $("#incomeForm").on("submit", function(e) {
                e.preventDefault();


                let formData = new FormData($('#incomeForm')[0]);

                $(".error-message").text("");
                $("input, select, textarea").removeClass("border-red-500");

                let isValid = true;
                let firstInvalidField = null;

                if ($.trim($("#organisation_id").val()) === "") {
                    $("#error-organisation").text("Organisation is required");
                    $("#organisation").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#organisation_id");
                    isValid = false;
                }

                let orgId = $("#organisation_id").val();
                let filtered = accountTypes.filter(at => at.organisation_id == orgId);

                if (filtered.length > 0) {
                    if ($.trim($("#account_type_id").val()) === "") {
                        $("#error-account-type").text("Division is required");
                        $("#account_type_id").addClass("border-red-500");
                        if (!firstInvalidField) firstInvalidField = $("#account_type_id");
                        isValid = false;
                    }
                }
                if ($.trim($("#income_head_id").val()) === "") {
                    $("#error-income-head").text("Income Head is required");
                    $("#income_head_id").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#income_head_id");
                    isValid = false;
                }

                if ($.trim($("#payment_type_id").val()) === "") {
                    $("#error-payment-type").text("Payment Type is required");
                    $("#payment_type_id").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#payment_type_id");
                    isValid = false;
                } else {
                    $("#error-payment-type").text("");
                    $("#payment_type_id").removeClass("border-red-500");
                }



                if ($.trim($("input[name='transaction_amount']").val()) === "") {
                    $("#error-transaction-amount").text("Transaction Amount is required");
                    $("input[name='transaction_amount']").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#transaction_amount");

                    isValid = false;
                }

                if ($.trim($("input[name='transaction_date']").val()) === "") {
                    $("#error-date").text("Transaction Date is required");
                    $("input[name='transaction_date']").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#transaction_date");

                    isValid = false;
                }

                let donorTypeSelected = $("input[name='donor_type']:checked").val();
                let donorId = $("#donorId").val();

                if (donorTypeSelected && donorId.trim() === "") {
                    $("#error-donor").text("Please select a donor.");
                    $("#donorSearch").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#donor_type");

                    isValid = false;
                } else {
                    $("#error-donor").text("");
                    $("#donorSearch").removeClass("border-red-500");
                }

                let assetSelected = $("#assetRadio").is(":checked");
                let liabilitySelected = $("#liabilityRadio").is(":checked");
                let assetId = $("#assetId").val();
                let liabilityId = $("#liabilityId").val();

                if (assetSelected && assetId.trim() === "") {
                    $("#error-asset").text("Please select an asset.");
                    $("#assetSearch").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#assetRadio");

                    isValid = false;
                } else {
                    $("#error-asset").text("");
                    $("#assetSearch").removeClass("border-red-500");
                }

                if (liabilitySelected && liabilityId.trim() === "") {
                    $("#error-liability").text("Please select a liability.");
                    $("#liabilitySearch").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#liabilityRadio");

                    isValid = false;
                } else {
                    $("#error-liability").text("");
                    $("#liabilitySearch").removeClass("border-red-500");
                }


                if (!isValid) {
                    if (firstInvalidField) {
                        $('html, body').animate({
                            scrollTop: firstInvalidField.offset().top - 100
                        }, 500);
                        // firstInvalidField.focus();
                    }
                    return;
                }

                $.ajax({
                    url: "{{ route('income.store') }}",
                    type: "POST",
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                       if (response.success) {
                        Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: response.message,
                        timer: 2000,
                        showConfirmButton: false
                    }).then(() => {
                        window.location.href = "{{ route('income.index') }}";
                    });
                        } else {
                            alert("Something went wrong.");
                            // Re-enable button if server returns failure
                            $submitBtn.prop("disabled", false);
                        }
                    },
                    error: function(xhr) {
                        if (xhr.status === 422) {
                            let errors = xhr.responseJSON.errors;
                            let messages = [];
                            for (let key in errors) {
                                messages.push(errors[key][0]);
                            }
                            alert(messages.join("\n"));
                        } else {
                            alert("Something went wrong. Please try again.");
                        }
                    }
                });
            });

            $("#organisation_id").on("change", function() {
                if ($(this).val().trim() !== "") {
                    $("#error-organisation").text("");
                    $(this).removeClass("border-red-500");
                }
            });
            $("#income_head_id").on("change", function() {
                if ($(this).val().trim() !== "") {
                    $("#error-income-head").text("");
                    $(this).removeClass("border-red-500");
                }
            });
            $("#transaction_purpose").on("change", function() {
                if ($(this).val().trim() !== "") {
                    $("#error-transaction-purpose").text("");
                    $(this).removeClass("border-red-500");
                }
            });
            $("#payment_type_id").on("change", function() {
                if ($(this).val().trim() !== "") {
                    $("#error-payment-type").text("");
                    $(this).removeClass("border-red-500");
                }
            });
            $("#account_type_id").on("change", function() {
                if ($(this).val().trim() !== "") {
                    $("#error-account-type").text("");
                    $(this).removeClass("border-red-500");
                }
            });
            $("input[name='transaction_type']").on("change", function() {
                $("#error-transaction-type").text("");
            });
            $("input[name='transaction_reference']").on("input", function() {
                if ($(this).val().trim() !== "") {
                    $("#error-transaction-reference").text("");
                    $(this).removeClass("border-red-500");
                }
            });
            $("input[name='transaction_amount']").on("input", function() {
                if ($(this).val().trim() !== "") {
                    $("#error-transaction-amount").text("");
                    $(this).removeClass("border-red-500");
                }
            });
            $("input[name='transaction_date']").on("change", function() {
                if ($(this).val().trim() !== "") {
                    $("#error-date").text("");
                    $(this).removeClass("border-red-500");
                }
            });
            $("textarea[name='transaction_narration']").on("input", function() {
                if ($(this).val().trim() !== "") {
                    $("#error-transaction-narration").text("");
                    $(this).removeClass("border-red-500");
                }
            });




        });

        $("#transaction_reference").on("input", function() {
            let value = $(this).val();
            value = value.replace(/[^A-Za-z0-9]/g, "");
            if (value.length > 20) {
                value = value.substring(0, 20);
            }
            $(this).val(value);
            let errorDiv = $("#error-transaction-reference");
            if (value.length < 5) {
                errorDiv.text("Transaction reference must be at least 5 characters.");
            } else {
                errorDiv.text("");
            }
        });




        //for assets and liabilities checkbox logic:
        document.addEventListener("DOMContentLoaded", () => {
            const assetRadio = document.getElementById("assetRadio");
            const liabilityRadio = document.getElementById("liabilityRadio");
            const clearBtn = document.getElementById("clearSelection");

            const assetSection = document.getElementById("assetSection");
            const liabilitySection = document.getElementById("liabilitySection");
            const donorSection = document.getElementById("donorSection");

            const assetSearch = document.getElementById("assetSearch");
            const assetOptions = document.getElementById("assetOptions");
            const assetId = document.getElementById("assetId");

            const liabilitySearch = document.getElementById("liabilitySearch");
            const liabilityOptions = document.getElementById("liabilityOptions");
            const liabilityId = document.getElementById("liabilityId");

            const donorSearch = document.getElementById("donorSearch");
            const donorOptions = document.getElementById("donorOptions");
            const donorId = document.getElementById("donorId");


            let selectedDonorType = null;

            assetSearch.addEventListener("input", function() {
                this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
            });

            liabilitySearch.addEventListener("input", function() {
                this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
            });
            donorSearch.addEventListener("input", function() {
                this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
            });

            assetRadio.addEventListener("change", () => {
                assetSection.classList.remove("hidden");
                liabilitySection.classList.add("hidden");
                // donorSection.classList.remove("hidden");
            });

            liabilityRadio.addEventListener("change", () => {
                liabilitySection.classList.remove("hidden");
                assetSection.classList.add("hidden");
                // donorSection.classList.remove("hidden");
            });

            clearBtn.addEventListener("click", () => {
                assetRadio.checked = false;
                liabilityRadio.checked = false;
                assetSection.classList.add("hidden");
                liabilitySection.classList.add("hidden");
                // donorSection.classList.add("hidden");
                assetSearch.value = "";
                liabilitySearch.value = "";
                donorSearch.value = "";
                assetId.value = "";
                liabilityId.value = "";
                donorId.value = "";
                assetSearch.disabled = false;
                liabilitySearch.disabled = false;

                document.getElementById("openAssetModalBtn").classList.add("hidden");
                document.getElementById("openLiabilityModalBtn").classList.add("hidden");

                assetList.classList.add("hidden");
                liabilityList.classList.add("hidden");
                // donorSearch.disabled = false;
            });

            function setupSearch(input, optionsBox, hiddenField, items, idKey, nameKey, btnId) {
                const addBtn = document.getElementById(btnId);

                input.addEventListener("input", () => {


                    const search = input.value.toLowerCase();
                    optionsBox.innerHTML = "";

                    if (search.length > 0) {

                        const filtered = items.filter(i => i[nameKey].toLowerCase().includes(search));

                        if (filtered.length > 0) {
                            optionsBox.classList.remove("hidden");
                            addBtn.classList.add("hidden");

                            filtered.forEach(opt => {
                                const li = document.createElement("li");
                                li.textContent = opt[nameKey];
                                li.className = "px-3 py-2 hover:bg-gray-100 cursor-pointer";
                                li.dataset.id = opt[idKey];

                                li.addEventListener("click", () => {
                                    input.value = opt[nameKey];
                                    hiddenField.value = opt[idKey];
                                    input.disabled = true;
                                    optionsBox.classList.add("hidden");
                                    addBtn.classList.add("hidden");
                                });

                                optionsBox.appendChild(li);
                            });
                        } else {
                            optionsBox.classList.add("hidden");
                            addBtn.classList.remove("hidden");
                        }
                    } else {
                        optionsBox.classList.add("hidden");
                        addBtn.classList.add("hidden");
                    }
                });
            }


            setupSearch(assetSearch, assetOptions, assetId, assets, "asset_id", "asset_name", "openAssetModalBtn");
            setupSearch(liabilitySearch, liabilityOptions, liabilityId, liabilities, "liability_id",
                "liability_name", "openLiabilityModalBtn");


            document.querySelectorAll("input[name='donor_type']").forEach(radio => {
                radio.addEventListener("change", function() {
                    selectedDonorType = this.value;
                    donorSearch.disabled = false;
                    donorSearch.value = "";
                    donorOptions.innerHTML = "";
                    donorId.value = "";
                    donorSection.classList.remove("hidden");
                });
            });

            document.getElementById("clearDonorSelection").addEventListener("click", () => {
                document.querySelectorAll("input[name='donor_type']").forEach(radio => {
                    radio.checked = false;
                });
                donorSearch.value = "";
                donorOptions.innerHTML = "";
                donorId.value = "";
                donorSearch.disabled = true;
                selectedDonorType = null;
                donorSection.classList.add("hidden");
            });
            donorSearch.addEventListener("input", () => {
                const search = donorSearch.value.toLowerCase();
                donorOptions.innerHTML = "";

                if (search.length > 0 && selectedDonorType) {
                    const filtered = donors.filter(d =>
                        d.donor_type === selectedDonorType &&
                        d.donor_name.toLowerCase().includes(search)
                    );

                    if (filtered.length > 0) {
                        donorOptions.classList.remove("hidden");
                        filtered.forEach(opt => {
                            const li = document.createElement("li");
                            li.textContent = opt.donor_name;
                            li.className = "px-3 py-2 hover:bg-gray-100 cursor-pointer";
                            li.dataset.id = opt.donor_id;
                            li.addEventListener("click", () => {
                                donorSearch.value = opt.donor_name;
                                donorId.value = opt.donor_id;
                                donorOptions.classList.add("hidden");
                            });
                            donorOptions.appendChild(li);
                        });
                    } else {
                        donorOptions.classList.add("hidden");
                    }
                } else {
                    donorOptions.classList.add("hidden");
                }
            });

        });
        //end for assets and liabilities checkbox logic



        //for file upload logic and append names
        document.getElementById('income_files').addEventListener('change', function(e) {
            const fileList = document.getElementById('file-list');
            const errorDiv = document.getElementById('error-income-files');
            fileList.innerHTML = "";
            errorDiv.textContent = "";

            const maxTotalSize = 3 * 1024 * 1024;
            let totalSize = 0;
            let hasInvalidType = false;

            for (let i = 0; i < this.files.length; i++) {
                const file = this.files[i];
                totalSize += file.size;

                if (!file.type.startsWith("image/") && file.type !== "application/pdf") {
                    hasInvalidType = true;
                }
            }
            if (totalSize > maxTotalSize) {
                // alert("Total file size must not exceed 3 MB.\nYou selected " + (totalSize / (1024 * 1024)).toFixed(
                //     2) + " MB.");
                errorDiv.textContent = "Total file size must not exceed 3 MB.\nYou selected " + (totalSize / (1024 *
                    1024)).toFixed(
                    2) + " MB.";
                this.value = "";
                return;
            }
            if (hasInvalidType) {
                // alert("Invalid file type. Only images or PDFs allowed.");
                errorDiv.textContent = "Invalid file type. Only images or PDFs up to 3 MB are allowed.";
                this.value = "";
                return;
            }

            for (let i = 0; i < this.files.length; i++) {
                const li = document.createElement("li");
                li.textContent = this.files[i].name;
                fileList.appendChild(li);
            }
        });
        // end for file upload logic and append names


        // start donor add logic::



        $('#saveDonor').on('click', function() {

            let formData = {
                _token: "{{ csrf_token() }}",
                organisation_id: $('#donor_organisation_id').val(),
                donor_type: $('#donor_type_new').val(),
                donor_name: $('#donor_name').val(),
                donor_contact_person: $('#donor_contact_person').val(),
                donor_phone_number: $('#donor_phone_number').val(),
                donor_email: $('#donor_email').val(),
                donor_address: $('#donor_address').val(),
                donor_pan_number: $('#donor_pan_number').val(),
                donor_aadhar_number: $('#donor_aadhar_number').val(),


            };
            console.log(formData);

            $.ajax({
                url: "{{ route('donor.store') }}",
                type: "POST",
                data: formData,
                success: function(res) {
                    if (res.success) {
                        $('#donorModal').addClass('hidden');

                        $("input[name='donor_type'][value='" + res.donor.donor_type + "']").prop(
                            'checked', true);

                        $('#donorSearch').prop('disabled', false);

                        $('#donorId').val(res.donor.donor_id);
                        $('#donorSearch').val(res.donor.donor_name);

                        donors.push({
                            donor_id: res.donor.donor_id,
                            donor_type: res.donor.donor_type,
                            donor_name: res.donor.donor_name
                        });

                        let ul = $('#donorOptions');
                        let li = $('<li>')
                            .text(res.donor.donor_name)
                            .attr('data-id', res.donor.donor_id)
                            .addClass("px-3 py-2 cursor-pointer hover:bg-gray-100")
                            .on('click', function() {
                                $('#donorSearch').val(res.donor.donor_name);
                                $('#donorId').val(res.donor.donor_id);
                                ul.addClass('hidden');
                            });
                        ul.append(li);
                        $('#donorSuccessModal').removeClass('hidden');
                    }
                },
                error: function(xhr) {
                    console.error(xhr.responseText);
                    alert("Error: Could not save donor.");
                }
            });
        });
        $(document).on('click', '#donorSuccessModal button', function() {
            $('#donorSuccessModal').addClass('hidden');
        });
        //end donor add logic ends::

        $("input[name='transaction_amount']").on("input", function() {
            let val = this.value;
            val = val.replace(/[^0-9.]/g, "");
            let parts = val.split(".");
            if (parts.length > 2) {
                val = parts[0] + "." + parts.slice(1).join("");
            }
            if (/^0[0-9]/.test(val)) {
                val = val.replace(/^0+/, "");
            }
            if (val.startsWith("0.") || val === "0") {
                val = val.replace(/^0+/, "");
            }

            this.value = val;
        });



        document.getElementById('closeIncomeHeadModal').addEventListener('click', function() {
            document.getElementById('incomeHeadModal').classList.add('hidden');
        });
        document.getElementById('incomeHeadCloseSuccessModal').addEventListener('click', function() {
            document.getElementById('incomeHeadSuccessModal').classList.add('hidden');
        });
        document.getElementById('incomeHeadCloseErrorModal').addEventListener('click', function() {
            document.getElementById('incomeHeadErrorModal').classList.add('hidden');
        });
        document.getElementById('saveIncomeHead').addEventListener('click', function() {
            document.querySelectorAll('.error-message').forEach(el => el.innerText = '');
            let data = {
                _token: "{{ csrf_token() }}",
                organisation_id: document.getElementById('organisation_id_new2').value,
                income_head_name: document.getElementById('income_head_name').value,
                account_type_id: document.getElementById('account_type_id_new').value,
                income_head_group_id: document.getElementById('income_head_group_id').value ?? null,

            };
            fetch("{{ route('incomehead.store') }}", {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': data._token
                    },
                    body: JSON.stringify(data)
                })
                .then(response => response.json())
                .then(result => {
                    document.querySelectorAll('.error-message').forEach(el => el.innerText = '');

                    if (result.success) {
                        document.getElementById('incomeHeadModal').classList.add('hidden');
                        document.getElementById('incomeHeadSuccessModal').classList.remove('hidden');
                        $("#incomeHeadSuccessModal").css("z-index", "9999");
                        let select = document.getElementById('income_head_id');
                        let option = document.createElement('option');
                        option.value = result.new_id;
                        option.text = result.name;
                        option.selected = true;
                        select.add(option);
                    } else if (result.errors) {
                        Object.keys(result.errors).forEach(function(key) {
                            let errorDiv = document.getElementById('error-' + key.replace(/_/g, '-'));
                            if (errorDiv) {
                                errorDiv.innerText = result.errors[key][0];
                            }
                        });
                    } else {
                        document.getElementById('incomeHeadErrorMessage').innerText = result.message ||
                            'Something went wrong!';
                        document.getElementById('incomeHeadErrorModal').classList.remove('hidden');
                    }
                })
                .catch(error => {
                    document.getElementById('incomeHeadErrorMessage').innerText =
                        'Server error! Please try again.';
                    document.getElementById('incomeHeadErrorModal').classList.remove('hidden');
                });
        });
        // end :: Add Income Head logicc

        // start: Add Asset logic
        $("#openAssetModalBtn").on("click", function() {
            $("#organisation_id_new").val($("#organisation_id").val());
            $("#account_type_id_new2").val($("#account_type_id").val());

            if ($("#organisation_id_new").val() == 2) {
                $("#account_type_asset").hide();
            } else {
                $("#account_type_asset").show();
            }
            $("#assetModal").removeClass("hidden");
        });

        $("#closeAssetModal").on("click", function() {
            $("#assetModal").addClass("hidden");
        });

        $("#closeAssetSuccessModal").on("click", function() {
            $("#assetSuccessModal").addClass("hidden");
        });

        $("#closeAssetErrorModal").on("click", function() {
            $("#assetErrorModal").addClass("hidden");
        });

        $("#saveAssetBtn").on("click", function() {
            $(".error-message").text(""); // clear errors

            let payload = {
                _token: $("meta[name='csrf-token']").attr("content"),
                organisation_id: $("#organisation_id_new").val(),
                account_type_id: $("#account_type_id_new2").val(),
                asset_name: $("#asset_name").val().trim(),
                asset_type: $("#asset_type").val().trim(),
                depreciation: $("#depreciation").val(),
                asset_opening_balance: $("#asset_opening_balance").val(),
                asset_purchase_date: $("#asset_purchase_date").val(),
                financial_year_id: $("#financial_year_id").val(),
                asset_purchase_cost: $("#asset_purchase_cost").val(),
                asset_useful_life: $("#asset_useful_life").val(),
            };

            $.ajax({
                url: "{{ route('asset.store') }}",
                type: "POST",
                data: JSON.stringify(payload),
                contentType: "application/json",
                success: function(res) {
                    if (res.success) {
                        $("#assetModal").addClass("hidden");
                        $("#assetSuccessModal").removeClass("hidden");

                        assets.push({
                            asset_id: res.new_id,
                            asset_name: res.name
                        });
                        // // append to asset dropdown if exists
                        // if ($("#asset_id").length) {
                        //     let option = $("<option>")
                        //         .val(res.new_id)
                        //         .text(res.name)
                        //         .prop("selected", true);
                        //     $("#asset_id").append(option);
                        // }
                    }
                },
                error: function(xhr) {
                    let res = xhr.responseJSON;
                    if (res && res.errors) {
                        Object.keys(res.errors).forEach(function(key) {
                            $("#error-" + key.replace(/_/g, "-")).text(res.errors[key][0]);
                        });
                    } else {
                        $("#assetErrorMessage").text("Something went wrong.");
                        $("#assetErrorModal").removeClass("hidden");
                    }
                },
            });
        });
        // end: Add Asset logic


        // start: Add Liability logic
        $("#openLiabilityModalBtn").on("click", function() {
            $("#liability_organisation_id").val($("#organisation_id").val());
            $("#liability_account_type_id").val($("#account_type_id").val());

            if ($("#liability_organisation_id").val() == 2) {
                $("#account_type_liability").hide();
            } else {
                $("#account_type_liability").show();
            }

            $("#liabilityModal").removeClass("hidden");
        });

        $("#closeLiabilityModal").on("click", function() {
            $("#liabilityModal").addClass("hidden");
        });

        $("#closeLiabilitySuccessModal").on("click", function() {
            $("#liabilitySuccessModal").addClass("hidden");
        });

        $("#closeLiabilityErrorModal").on("click", function() {
            $("#liabilityErrorModal").addClass("hidden");
        });

        $("#saveLiabilityBtn").on("click", function() {
            $(".error-message").text(""); // clear errors

            let payload = {
                _token: $("meta[name='csrf-token']").attr("content"),
                organisation_id: $("#liability_organisation_id").val(),
                account_type_id: $("#liability_account_type_id").val(),
                financial_year_id: $("#liability_financial_year_id").val(),
                liability_name: $("#liability_name").val().trim(),
                liability_type: $("#liability_type").val().trim(),
                liability_date: $("#liability_date").val(),
                liability_opening_balance: $("#liability_opening_balance").val(),
                liability_amount: $("#liability_amount").val(),
                liability_due_date: $("#liability_due_date").val(),
                liability_status: $("#liability_status").val(),
            };

            $.ajax({
                url: "{{ route('liability.store') }}",
                type: "POST",
                data: JSON.stringify(payload),
                contentType: "application/json",
                success: function(res) {
                    if (res.success) {
                        $("#liabilityModal").addClass("hidden");
                        $("#liabilitySuccessModal").removeClass("hidden");

                        // push into liabilities array for search logic
                        liabilities.push({
                            liability_id: res.new_id,
                            liability_name: res.name
                        });
                        $("#liabilitySuccessModal").css("z-index", "9999");

                    }
                },
                error: function(xhr) {
                    let res = xhr.responseJSON;
                    if (res && res.errors) {
                        Object.keys(res.errors).forEach(function(key) {
                            $("#error-" + key.replace(/_/g, "-")).text(res.errors[key][0]);
                        });
                    } else {
                        $("#liabilityErrorMessage").text("Something went wrong.");
                        $("#liabilityErrorModal").removeClass("hidden");
                    }
                },
            });
        });
        // end: Add Liability logic

        $("#asset_name").on("input", function() {
            this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
        });
        $("#asset_type").on("input", function() {
            this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
        });

        $("#depreciation").on("input", function() {
            let val = this.value;
            val = val.replace(/[^0-9.]/g, "");
            let parts = val.split(".");
            if (parts.length > 2) {
                val = parts[0] + "." + parts.slice(1).join("");
            }
            if (/^0[0-9]/.test(val)) {
                val = val.replace(/^0+/, "");
            }
            if (val.startsWith("0.") || val === "0") {
                val = val.replace(/^0+/, "");
            }

            this.value = val;
        });
        $("#liability_name").on("input", function() {
            this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
        });

        $("#liability_type").on("input", function() {
            this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
        });
        $("#donor_name").on("input", function() {
            this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
        });

        $("#donor_contact_person").on("input", function() {
            this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
        });

        $("#donor_phone_number").on("input", function() {
            this.value = this.value.replace(/[^0-9]/g, '');
        });

        $("#donor_pan_number").on("input", function() {
            this.value = this.value.replace(/[^A-Z0-9]/g, '').toUpperCase();
        });

        $("#donor_aadhar_number").on("input", function() {
            this.value = this.value.replace(/[^0-9]/g, '');
        });
        $("#income_head_name").on("input", function() {
            this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
        });
    </script>
@endsection
