<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Income Transaction</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            color: #333;
        }

        h2 {
            background-color: #f1f5f9;
            color: #1e3a8a;
            padding: 8px 12px;
            border-radius: 6px;
            text-align: center;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        th,
        td {
            padding: 8px 12px;
            border: 1px solid #ddd;
        }

        th {
            background-color: #3b82f6;
            color: white;
            text-align: left;
            width: 30%;
        }

        td {
            background-color: #f9fafb;
        }

        p {
            font-weight: 20px;
        }
    </style>
</head>

<body>
    <div class="intro-y col-span-12 lg:col-span-12 transection-details-view">
        <div class="intro-y box mt-8 shadow-lg rounded-2xl overflow-hidden">
            <div class="bg-gradient-to-r from-blue-600 to-indigo-600 p-5">
                <h2 class="font-semibold text-lg text-black">
                    Income Transaction Details:
                </h2>
            </div>

            <div class="p-8 bg-white">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-y-6 gap-x-10">
                    @if (isset($income->organisation_id))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Organisation Name:</p>
                            <p class="text-blue-600 font-semibold">
                                @foreach ($organisations as $organisation)
                                    @if ($organisation->organisation_id == $income->organisation_id)
                                        {{ $organisation->organisation_name }}
                                    @endif
                                @endforeach
                            </p>
                        </div>
                        <hr>
                    @endif
                    @if (isset($income->account_type_id))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Division Name:</p>
                            <p class="text-blue-600 font-semibold">
                                @foreach ($accountTypes as $accountType)
                                    @if ($accountType->account_type_id == $income->account_type_id)
                                        {{ $accountType->account_type_Name }}
                                    @endif
                                @endforeach
                            </p>
                        </div>
                        <hr>
                    @endif
                    @if (isset($income->income_head))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Income Head Name:</p>
                            <p class="text-blue-600 font-semibold">
                                @foreach ($incomeHeads as $incomeHead)
                                    @if ($incomeHead->income_head_id == $income->income_head)
                                        {{ $incomeHead->income_head_name }}
                                    @endif
                                @endforeach
                            </p>
                        </div>
                        <hr>
                    @endif
                    @if (isset($income->money_receipt_no))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Money Receipt No. :</p>
                            <p class="text-blue-600 font-semibold">
                                @if (isset($income->money_receipt_no))
                                    {{ $income->money_receipt_no ? $income->money_receipt_no : '' }}
                                @endif
                            </p>
                        </div>
                        <hr>
                    @endif
                    @if (@isset($income->asset_id))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Asset Name:</p>
                            <p class="text-blue-600 font-semibold">
                                @foreach ($assets as $asset)
                                    @if ($asset->asset_id == $income->asset_id)
                                        {{ $asset->asset_name }}
                                    @endif
                                @endforeach
                            </p>
                        </div>
                        <hr>
                    @endif
                    @if (@isset($income->liability_id))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Liability Name:</p>
                            <p class="text-blue-600 font-semibold">
                                @foreach ($liabilities as $liability)
                                    @if ($liability->liability_id == $income->liability_id)
                                        {{ $liability->liability_name }}
                                    @endif
                                @endforeach
                            </p>
                        </div>
                        <hr>
                    @endif
                    @if (@isset($income->donor_id))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Donor Name:</p>
                            <p class="text-blue-600 font-semibold">
                                @foreach ($donors as $donor)
                                    @if ($donor->donor_id == $income->donor_id)
                                        {{ $donor->donor_name }} - {{ $donor->donor_type }}
                                    @endif
                                @endforeach
                            </p>
                        </div>
                        <hr>
                    @endif
                    @if (@isset($income->financial_year_id))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Accounting Year:</p>
                            <p class="text-blue-600 font-semibold">
                                @foreach ($accounting_years as $accounting_year)
                                    @if ($accounting_year->accounting_year_id == $income->financial_year_id)
                                        {{ $accounting_year->accounting_year_financial }}
                                    @endif
                                @endforeach
                            </p>
                        </div>
                        <hr>
                    @endif
                    @if (@isset($income->transaction_date))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Date of Transaction:</p>
                            <p class="text-blue-600 font-semibold">
                                {{ \Carbon\Carbon::parse($income->transaction_date)->format('d-m-Y') }}
                            </p>
                        </div>
                        <hr>
                    @endif
                    @if (@isset($income->transaction_reference))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Transaction Reference No.:</p>
                            <p class="text-blue-600 font-semibold">{{ $income->transaction_reference }}</p>
                        </div>
                        <hr>
                    @endif
                    @if (@isset($income->payment_type_id))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Payment Type:</p>
                            <p class="text-blue-600 font-semibold">{{ $income->paymentType->name ?? '-' }}</p>
                        </div>
                        <hr>
                    @endif

                    {{-- @if (@isset($income->purpose_id))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Purpose:</p>
                            <p class="text-blue-600 font-semibold">{{ $income->purpose->name ?? '-' }}</p>
                        </div>
                    @endif --}}
                    @if (@isset($income->transaction_narration))
                        <div class="md:col-span-2 list-chart">
                            <p class="text-gray-600 font-medium">Transaction Narration:</p>
                            <p class="text-blue-600 font-semibold italic">{{ $income->transaction_narration ?? '—' }}
                            </p>
                        </div>
                        <hr>
                    @endif
                </div>
                @if (@isset($income->transaction_amount))
                    <div class="list-chart">
                        <p class="text-gray-600 font-medium">Transaction Amount:</p>
                        <p class="text-green-600 text-xl font-bold">
                            ₹ {{ number_format($income->transaction_amount, 2) }}
                        </p>
                    </div>
                    <hr>
                @endif
                @if (!empty($income->file_path))
                    <div>
                        <p class="text-gray-600 font-medium">Uploaded Files:</p>
                        <div class="flex gap-4 flex-wrap">
                            @foreach (explode(',', $income->file_path) as $file)
                                @php
                                    $file = trim($file);
                                    $extension = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                                @endphp

                                @if ($extension === 'pdf')
                                    <a href="{{ asset('storage/' . $file) }}" target="_blank"
                                        class="flex flex-col items-center justify-center w-32 h-32 bg-gray-100 border rounded shadow cursor-pointer">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-12 h-12 text-red-600"
                                            fill="currentColor" viewBox="0 0 24 24">
                                            <path
                                                d="M6 2a2 2 0 0 0-2 2v16c0
                                                                                                                                                                        1.1.9 2 2 2h12a2 2 0 0
                                                                                                                                                                        0 2-2V8l-6-6H6zm7 1.5L18.5
                                                                                                                                                                        9H13V3.5zM8 13h8v2H8v-2z" />
                                        </svg>
                                        <span class="text-sm text-gray-700">PDF File</span>
                                    </a>
                                @else
                                    <a href="{{ asset('storage/' . $file) }}" target="_blank">
                                        <img src="{{ asset('storage/' . $file) }}" alt="Uploaded Image"
                                            class="w-32 h-32 object-cover rounded shadow cursor-pointer">
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</body>

</html>
