@extends('master.authMaster')


@section('content')

{{-- Form --}}
<div class="intro-y col-span-12 lg:col-span-12">

    <!-- BEGIN: Select Options -->
    <div class="intro-y box mt-5">
        <!-- BEGIN: Horizontal Form -->
        <div class="intro-y box mt-5">
            <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                <h2 class="font-medium text-base mr-auto">
                    User
                </h2>

            </div>
            <div class="p-5" id="horizontal-form">
                @if ($errors->orgCheck->any())
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-2 rounded mb-3">
                    @foreach ($errors->orgCheck->all() as $error)
                    <p>{{ $error }}</p>
                    @endforeach
                </div>
                @endif
                <form id="create_a_user_form" method="POST" action="{{ route('users.store') }}">
                    @csrf
                    <div class="preview">
                        {{-- <div class="grid grid-cols-12 gap-6 mt-5"> --}}
                        <div class="intro-y col-span-12 lg:col-span-12">
                            <!-- BEGIN: Input -->
                            <div class="intro-y">

                                <div class="p-5" id="input">
                                    <div class="preview">
                                        <div class="mt-3">
                                            <label>Full Name <span style="color: red;">*</span></label>
                                            <input type="text" class="input w-full border mt-2" name="fullname"
                                                id="fullname" value="{{ old('fullname') }}" placeholder="Enter Full Name">
                                            @error('fullname')
                                            <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="mt-3">
                                            <label>Email <span style="color: red;">*</span></label>
                                            <input type="text" class="input w-full border mt-2" id="email_address" name="email"
                                                value="{{ old('email') }}" placeholder="Enter Email">
                                            <div class="text-xs text-gray-600 mt-2">e.g , abc@gmail.com /
                                                abc21@yahoo.com</div>
                                            @error('email')
                                            <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="mt-3">
                                            <label>Role</label>
                                            <select name="role_id" class="input w-full border mt-2">
                                                <option value="">-- Select Role --</option>
                                                @foreach ($roles as $role)
                                                <option value="{{ $role->id }}"
                                                    {{ old('role_id') == $role->id ? 'selected' : '' }}>
                                                    {{ $role->name }}
                                                </option>
                                                @endforeach
                                            </select>
                                            @error('role_id')
                                            <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="mt-3">
                                            <label>Password</label>
                                            <input id="password" type="password" class="input w-full border mt-2"
                                                name="password" placeholder="Password" value="{{ old('password') }}">
                                            @error('password')
                                            <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="mt-3">
                                            <label>Confirm Password</label>
                                            <input type="password" class="input w-full border mt-2" id="confirmPassword"
                                                name="password_confirmation" placeholder="Enter Confirm Password"
                                                value="{{ old('password_confirmation') }}">
                                            @error('password_confirmation')
                                            <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- </div> --}}

                        </div>
                        <div class="sm:pl-5 mt-5">
                            <a href="{{ route('users.index') }}"><span
                                    class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600 mr-8">
                                    ← Back
                                </span></a>
                            <button type="submit" class="button w-24 bg-theme-1 text-white">Save</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- END: Horizontal Form -->
    </div>
    <!-- END: Select Options -->
</div>
{{-- <div class="intro-y col-span-12 lg:col-span-6">



    </div> --}}


<script>
    $(document).ready(function() {
        $('#fullname').on("input", function() {
            $('#create_a_user_form').find('._error_msg').remove();
            this.value = this.value.split('').filter(char => /^[A-Za-z\s.]$/.test(char)).join('');
        });
        $('#email_address').on("input", function() {
            $('#create_a_user_form').find('._error_msg').remove();
        });

        $('#input').find('input, select').on('input change', function() {
            $(this).next('.text-red-500').remove();
        });

        $('#create_a_user_form').on('submit', function(e) {
            e.preventDefault();

            if (checkName() && emailField()) this.submit();
        })

        function checkName() {
            const nameRegex = /^(?:[A-Za-z]+\.)?(?:\s?[A-Za-z]+)+$/;
            let element = $('#fullname');
            let name = $.trim(element.val());
            if (name === '' || !nameRegex.test(name)) {
                element.parent().append(msgHTML('Please enter a valid name — only letters, spaces, and optional titles like "Dr." or "Mr." are allowed.'));
                element.focus();

                return false;
            }
            return true;
        }

        function emailField() {
            const emailRegex = /^[a-zA-Z0-9._%+-]+@([a-zA-Z0-9-]+\.)+[a-zA-Z]{2,}$/;
            const element = $('#email_address'); // you forgot to define this
            const value = $.trim(element.val());
            if (value !== '' && !emailRegex.test(value)) {
                element.parent().append(msgHTML('Please enter a valid email address (e.g., name@example.com).'));
                element.focus();
                return false;
            }
            return true;
        }

        function msgHTML(msg) {

            return $('<span>')
                .addClass('_error_msg')
                .css({
                    color: 'red',
                    margin: '5px 10px',
                    display: 'block'
                })
                .text(msg);
        }
    });
</script>
@endsection