@extends('master.authMaster')

@section('content')
@php $grandTotal = $brought_forward + ($totals['income'] - $totals['expense']); @endphp
<div class="ledgers-page-sec bg-gray-100 col-span-12 lg:col-span-12 account-brot-for-pg">
    <div class="ledgers-page-wraper flex w-full bg-white shadow-md rounded-2xl overflow-hidden">
        <div class="w-full p-4">
            <div class="content-box">

                <!-- Header -->
                <div class="flex justify-between items-center">
                    <h3 class="text-base font-medium text-black">
                        {{ ucfirst($flag) }} Transaction History
                    </h3>
                    <h6 class="flex items-center" style="font-weight: bold;">
                        <span style="margin-right: 10px; font-weight: 300;">Grand Total</span>
                        {{ number_format($grandTotal, 2) }}
                    </h6>
                </div>
                <ul class="listing-top" style="background-color: #3182ce14">
                    <li class="p-3">Total {{ ucfirst($flag) }} Amount Brought Forward</li>
                    <li class="p-3 text-right text-black font-semibold">
                        {{ number_format($brought_forward, 2) }}
                    </li>
                </ul>

                @php
                $sl = 1;
                @endphp

                <div class="sngl-box">
                    <table class="w-full text-left border-collapse shadow-sm rounded-lg overflow-hidden mb-3">

                        <thead>
                            <tr>
                                <td>Sl No.</td>
                                <td>Date</td>
                                <td style="width: 180px;">Donor/Vendor Name</td>
                                <td>Income/Expense Heads</td>
                                <td>Narration</td>
                                <td class="text-right">Amount</td>
                            </tr>
                        </thead>
                        <tbody class="divide-y">

                            @foreach($transactions as $key=> $row)
                            <tr class="hover:bg-gray-50 bg-green-50">
                                <td class="p-3">{{ $sl++ }}</td>

                                <td class="p-3">
                                    {{ $row->transaction_date ?  date('d-m-Y', strtotime($row->transaction_date)) : '-' }}
                                </td>
                                <td class="p-3">
                                    @if($row->transcation_type === 'income')
                                    @if(!empty($row->donor_name))
                                    {{ $row->donor_name }}
                                    @if(!empty($row->donor_type))
                                    - ({{ ucfirst($row->donor_type) }})
                                    @endif
                                    @else
                                    -
                                    @endif

                                    @elseif($row->transcation_type === 'expense')
                                    @if(!empty($row->vendor_name))
                                    {{ $row->vendor_name }}
                                    @if(!empty($row->vendor_type))
                                    - ({{ ucfirst($row->vendor_type) }})
                                    @endif
                                    @else
                                    -
                                    @endif
                                    @else
                                    -
                                    @endif
                                </td>

                                <td class="p-3">
                                    {{ $row->head_name ? $row->head_name : '-' }}
                                </td>

                                <td class="p-3">
                                    <span title="{{ $row->transaction_narration }}">
                                        {{ !empty($row->transaction_narration)
                                        ? (strlen($row->transaction_narration) > 15
                                            ? substr($row->transaction_narration, 0, 15) . '...'
                                            : $row->transaction_narration)
                                        : '-' }} </span>
                                </td>

                                @if($row->transcation_type === 'income')
                                <td class="p-3 text-right text-green-600 font-semibold">
                                    + {{ number_format($row->transaction_amount, 2) }}
                                </td>
                                @elseif($row->transcation_type === 'expense')
                                <td class="p-3 text-right text-red-600 font-semibold">
                                    - {{ number_format($row->transaction_amount, 2) }}
                                </td>
                                @endif
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="5" class="p-3 text-right font-semibold">Total Income</td>
                                <td class="p-3 text-right font-bold text-green-600">
                                    {{ number_format($totals['income'] ?? 0, 2) }}
                                </td>
                            </tr>
                            <tr>
                                <td colspan="5" class="p-3 text-right font-semibold">Total Expense</td>
                                <td class="p-3 text-right font-bold text-red-600">
                                    - {{ number_format($totals['expense'] ?? 0, 2) }}
                                </td>
                                </td>
                            </tr>
                            <tr>

                                <td colspan="5" class="p-3 text-right font-semibold">Grand Total</td>
                                <td
                                    class="p-3 text-right font-bold {{ $grandTotal >= 0 ? 'text-green-700' : 'text-red-700' }}">
                                    {{ number_format($grandTotal, 2) }}
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="mt-6">
                    <button onclick="history.back()"
                        class="px-4 py-2 rounded-lg bg-gray-500 hover:bg-gray-600 text-white shadow text-sm transition">
                        ← Back
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection