@extends('master.authMaster')
@section('content')
<div class="col-span-12 lg:col-span-12">
    <div class="flex justify-between mt-5">
        <h2 class="text-lg font-medium mr-auto">
            Members
        </h2>

        @php
        $menuId = \App\Models\Menu::where('route', 'donor.index')->value('id');
        $permissionService = app(\App\Services\PermissionService::class);
        $canWrite = $permissionService->hasPermission($menuId, 'x');
        @endphp

        @if ($permissionService->hasPermission($menuId, 'w'))
        <div class="w-full sm:w-auto flex mt-4 sm:mt-0 mr-4">
            <a href="{{ route('donor.create') }}">
                <button class="button text-white bg-theme-1 shadow-md">
                    Add Member
                </button>
            </a>
        </div>
        <div class="w-full sm:w-auto flex mt-4 sm:mt-0 mr-4">
            <a href="{{ route('donor.importForm') }}">
                <button class="button text-white bg-theme-1 shadow-md">
                    Add Bulk Member
                </button>
            </a>
        </div>
        <div class="w-full sm:w-auto flex mt-4 sm:mt-0 mr-4">
            <a href="{{ route('donor.member.donation.list') }}">
                <button class="button text-white bg-theme-1 shadow-md">
                    Members Yearly Record
                </button>
            </a>
        </div>

    @endif
</div>
</div>
</div>
<!-- BEGIN: HTML Table Data -->
<div class="intro-y box p-5 mt-5">

    @if (session('success'))
    <div class="rounded-md flex items-center px-5 py-4 mb-2 border border-theme-9 text-theme-9 dark:border-theme-9">
        {{ session('success') }}
    </div>
    @elseif (session('error'))
    <div class="rounded-md flex items-center px-5 py-4 mb-2 border border-theme-6 text-theme-6 dark:border-theme-6">
        {{ session('error') }}
    </div>
    @endif

    <div class="flex flex-col sm:flex-row sm:items-end xl:items-start">
        <form class="xl:flex w-full" id="tabulator-html-filter-form">

            <div class="sm:flex items-end justify-between w-full gap-4">
                <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center gap-2 flex-wrap">
                        <label for="page-size" class="form-label mb-0">Data Per Page</label>
                        <select id="page-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                            {{-- <option value="5">5</option> --}}
                            <option value="10">10</option>
                            <option value="30">30</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                        </select>
                    </div>
                </div>
                <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center flex-wrap">
                        <label for="org-size" class="form-label mb-0">Members as per Organisation:</label>
                        <select id="org-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                            <option value="">All Members</option>
                            @foreach ($organisations as $organisation)
                            <option value="{{ $organisation->organisation_id }}">
                                {{ $organisation->organisation_name }}
                            </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="ms-4 me-4 d-flex align-items-center justify-content-between" style="max-width: 300px;">
                    <div class="d-flex align-items-center flex-wrap">
                        <label for="org-size" class="form-label mb-0">Defaulter Members List</label>
                        <select id="defaulter_mem" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border" name="amount_flag">
                            <option value="">--select--</option>
                            <option value="not_paid">Pending</option>
                            <option value="paid">Paid</option>
                        </select>
                    </div>
                </div>
                <div>
                    <input type="text" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border" id="search-string"
                        placeholder="Search...">
                </div>

            </div>

        </form>
    </div>
    <div class="overflow-x-auto scrollbar-hidden">
        <div class="mt-5 table-report table-report--tabulator" id="donor-table"></div>
    </div>
</div>
<!-- END: HTML Table Data -->

<link href="{{ asset('build/assets/css/tabulator.min.css') }}" rel="stylesheet">
<link href="{{ asset('css/tabulator_materialize.min.css') }}" rel="stylesheet">
<script type="text/javascript" src="{{asset('js/tabulator.min.js') }}"></script>


<script>
    var canWrite = @json($canWrite); //execute
    var canRead = @json($permissionService -> hasPermission($menuId, 'r')); //read
    var canExecute = @json($permissionService -> hasPermission($menuId, 'w')); //write

    $(document).ready(function() {
        // 🔹 Define current financial year range using JS instead of Blade
        const now = new Date();
        const currentYear = now.getFullYear();
        const fyStart = new Date(currentYear, 3, 1); // Apr 1 (month index 3)
        const fyEnd = new Date(currentYear + 1, 2, 31); // Mar 31 next year
        const currentYearRange = `${String(fyStart.getDate()).padStart(2, "0")}-${String(fyStart.getMonth()+1).padStart(2, "0")}-${fyStart.getFullYear()} to ${String(fyEnd.getDate()).padStart(2, "0")}-${String(fyEnd.getMonth()+1).padStart(2, "0")}-${fyEnd.getFullYear()}`;

        console.log("Current FY:", currentYearRange);

        const csrfToken = $('meta[name="csrf-token"]').attr('content');

        // ✅ Initialize Tabulator
        const table = new Tabulator("#donor-table", {
            ajaxURL: "{{ route('donor.details') }}", // Laravel route still used
            ajaxConfig: {
                method: "POST",
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                },
            },
            ajaxParams: function() {
                return {
                    search: $("#search-string").val(),
                    organisation_id: $("#org-size").val(),
                    amount_flag: $("#defaulter_mem").val(),
                };
            },
            layout: "fitColumns",
            theme: "bootstrap5",
            paginationMode: "remote",
            pagination: true,
            paginationSize: 10,
            paginationSizeSelector: [10, 25, 50],
            movableRows: true,
            movableColumns: true,
            ajaxLoaderLoading: `
                <div style='display:inline-block; border:4px solid #333; border-radius:10px; background:#fff; font-weight:bold; font-size:16px; color:#000; padding:10px 20px;'>Loading Data...</div>
            `,
            columns: [
                {
                    title: "SL",
                    field: "sl",
                    hozAlign: "center",
                    formatter: function(cell) {
                        const row = cell.getRow();
                        const page = table.getPage() || 1;
                        const perPage = table.getPageSize() || 10;
                        return (row.getPosition(true) + 1) + ((page - 1) * perPage) - 1;
                    },
                },
                {
                    title: "Donor Name",
                    field: "donor_name",
                    hozAlign: "center",
                },
                {
                    title: "Donor Type",
                    field: "donor_type",
                    hozAlign: "center",
                    formatter: function(cell) {
                        const value = cell.getValue();
                        switch (value) {
                            case "members": return "Member";
                            case "foreign_members": return "Family Member";
                            case "non_members": return "Non-Member";
                            default: return value ?? "-";
                        }
                    },
                },
                {
                    title: "Phone No.",
                    field: "donor_phone_number",
                    hozAlign: "center",
                },
                {
                    title: "Address",
                    field: "donor_address",
                    hozAlign: "center",
                },
                {
                    title: "Ledger Folio No.",
                    field: "donor_folio_no",
                    hozAlign: "center",
                },
                {
                    title: "Add Donation",
                    headerSort: false,
                    hozAlign: "center",
                    formatter: function(cell) {
                        const row = cell.getRow().getData();
                        return `
                            <a href="javascript:void(0);" class="addDonation" data-id="${btoa(row.donor_id)}">
                                <svg xmlns="http://www.w3.org/2000/svg"
                                    width="20" height="20" viewBox="0 0 24 24"
                                    fill="none" stroke="currentColor"
                                    stroke-width="1.5" stroke-linecap="round"
                                    stroke-linejoin="round">
                                    <rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect>
                                    <line x1="12" y1="8" x2="12" y2="16"></line>
                                    <line x1="8" y1="12" x2="16" y2="12"></line>
                                </svg>
                            </a>`;
                    },
                    cellClick: function(e, cell) {
                        const donorId = $(e.target).closest('.addDonation').data('id');
                        if (donorId) {
                            window.location.href = "/member/donation/create/" + donorId;
                        }
                    }
                },
            ],
            ajaxResponse: function(url, params, response) {
                return {
                    data: response.data,
                    last_page: response.last_page,
                    current_page: response.current_page,
                    total: response.total,
                };
            },
        });

        // 🔹 Live update on filters
        $("#org-size, #defaulter_mem").change(function() {
            table.setData();
        });

        $("#search-string").on("input", function() {
            table.setData();
        });

        // 🔹 Page size change (optional)
        $("#page-size").on("change", function() {
            table.setPageSize(Number(this.value));
        });
    });
</script>
@endsection
