@extends('master.authMaster')
@section('content')
<script>
    var isError = false;
</script>
<?php // dd($organisations); ?>
<div class="intro-y col-span-12 lg:col-span-12">
    <div class="intro-y box mt-5" style=" padding: 20px 20px 30px 20px;">
        <div class="intro-y mt-5">

            <h2 class="text-xl font-bold mb-4">Add Members in Bulk </h2>
            <div class="mb-4">
                <a href="{{ route('donor.downloadSampleCSV') }}"
                    class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">
                    Download Sample CSV
                </a>
            </div>
            
            <form action="{{ route('donors.importCSV') }}" method="POST" enctype="multipart/form-data"
                id="bulk_cv_import">
                @csrf
                <div class="preview">
                    <div class="intro-y col-span-12 lg:col-span-12">
                        <div class="intro-y">
                            <div class="p-5" id="input">
                                <div class="preview">
                                    <div class="w-full -ml-4 -mr-4 flex flex-wrap">
                                        <div class="w-6/12 px-4">
                                            <div class="mt-3">
                                                <label>Organisation <span style="color: red">*</span></label>
                                                <select id="organisation_id" name="organisation_id"
                                                    class="input w-full border mt-2 custm-drpdwn _required" required disabled>
                                                    <option value="">-- Select Organisation --</option>
                                                    <option value="{{ $orgId}}"
                                                       selected>
                                                        {{ $organisationsName}}
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="w-6/12 px-4">
                                            <div class="mt-3" id="accountTypeWrapper">
                                                <label>Division</label>
                                                <select id="account_type_id" name="account_type_id"
                                                    class="input w-full border mt-2 custm-drpdwn">
                                                    <option value="">-- Select Division --</option>
                                                    @foreach($accountTypes as $aType)
                                                        <option value="{{ $aType['account_type_id'] }}" {{ old('account_type_id') == $aType['account_type_id'] ?? 'selected' }}>{{ $aType['account_type_Name'] }}</option>
                                                    @endforeach;
                                                </select>
                                            </div>
                                        </div>
                                        <div class="w-6/12 px-4">
                                            <div class="mt-3">
                                                <label>Select Member Type &nbsp; <span
                                                        style="color:red;">*</span></label>
                                                <select name="donor_type" class="w-full border mt-2 p-2 rounded _required"
                                                    required disabled>
                                                    <option value="members" selected>Members</option>
                                                    <option value="foreign_members">Family Members</option>
                                                    <option value="non_members">Non Members</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="w-6/12 px-4">
                                            <div class="mt-3">
                                                <label>Upload Csv File</label>
                                                <input type="file" class="w-full border mt-2 p-2 rounded _required"
                                                    name="csv_file" accept="" multiple required>
                                                <ul id="file-list" class="mt-2 text-sm text-gray-600 space-y-1">
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="sm:pl-5 mt-5">
                        <a href="{{ route('donor.index') }}"><span
                                class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600 mr-2">
                                ← Back
                            </span></a>
                        <button type="submit" id="import_csv_submit"
                            class="button w-24 bg-theme-1 text-white">Save</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@if (session('success'))
<script>
    toastr.success(@json(session('success')), "Success", toastrProperties);
</script>
@elseif (session('error'))
<script>
    toastr.error(@json(session('error')), "Error", toastrProperties);
</script>
@endif
<script src="{{ asset('js/skj-validations@v2.js') }}"></script>
<script src="{{ asset('js/members/addBulkMembers.js') }}"></script>
@endsection
