@extends('master.authMaster')

@section('content')
<div class="intro-y col-span-12 lg:col-span-12">
    <div class="intro-y box mt-5">
        <div class="intro-y box mt-5">
            <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                <h2 class="font-medium text-base mr-auto">
                    Member Donation
                </h2>
            </div>

            <form id="donationForm" method="POST" enctype="multipart/form-data" class="pb-4">
                @csrf
                <div class="member-add-boxarea p-5" id="dynamic-fields">
                    <div id="donation-rows" class="space-y-2 member-add-boxscroll">
                        <div class="donation-mamber-wraper">
                            <!-- Fixed Donor -->
                            <input type="hidden" name="members[]" value="{{ $donor['donor_id'] }}">
                            <input type="text" class="input border flex-1 bg-gray-100"
                                value="{{ ucwords(strtolower($donor['donor_name'])) }}" disabled>

                            <!-- Income Head Dropdown -->
                            <select name="income_heads[]" class="input border flex-1" required>
                                <option value="">-- Select Income Head --</option>
                                @foreach ($heads as $head)
                                <option value="{{ $head['id'] }}">
                                    {{ ucwords(strtolower($head['name'])) }}
                                </option>
                                @endforeach
                            </select>

                            <!-- Amount -->
                            <input type="text" name="amounts[]" class="input border flex-1" placeholder="Amount" required>

                            <select id="payment_type_id" name="payment_type_id[]" class="input border flex-1" required>
                                <option value="">-- Select Payment Type --</option>

                                @foreach ($paymentTypes->where('parent_id', null) as $parent)
                                @php
                                $children = $paymentTypes->where('parent_id', $parent->id);
                                @endphp

                                @if ($children->isEmpty())
                                <option value="{{ $parent->id }}"
                                    {{ old('payment_type_id') == $parent->id ? 'selected' : '' }}>
                                    {{ $parent->name }}
                                </option>
                                @else
                                <optgroup label="{{ $parent->name }}">
                                    @foreach ($children as $child)
                                    <option value="{{ $child->id }}"
                                        {{ old('payment_type_id') == $child->id ? 'selected' : '' }}>
                                        {{ $child->name }}
                                    </option>
                                    @endforeach
                                </optgroup>
                                @endif
                                @endforeach
                            </select>

                            <div class="text-red-500 text-sm mt-1 error-message" id="error-payment-type"></div>

                            <!-- Action Buttons -->
                            <div class="button-box">
                                <button type="button" class="btn-add bg-green-500 text-white px-3 rounded">+</button>
                            </div>
                            <!-- <button type="button" class="btn-remove bg-red-500 text-white px-3 rounded">-</button> -->
                        </div>

                    </div>
                </div>

                <div class="sm:pl-5 mt-5">
                    <a href="{{ route('donor.index') }}">
                        <span class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600 mr-2">
                            ← Back
                        </span>
                    </a>
                    <button type="submit" id="submitDonation" class="button w-24 bg-theme-1 text-white">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- This is dynamic row that will be appended inside the form -->
<div  class="donation-mamber-wraper donation-row" style="visibility: hidden;">
    <input type="hidden" name="members[]" value="{{ $donor['donor_id'] }}">
    <input type="text" class="input border flex-1 bg-gray-100"
        value="{{ ucwords(strtolower($donor->donor_name)) }}" disabled>

    <select name="income_heads[]" class="input border flex-1 income-head-select" required>
        <option value="">-- Select Income Head --</option>
        @foreach ($heads as $head)
        <option value="{{ $head['id'] }}">{{ $head['name'] }}</option>
        @endforeach
    </select>

    <input type="text" name="amounts[]" class="input border flex-1 _amount" placeholder="Amount" required>

    <select name="payment_type_id[]" class="input border flex-1" required>
        <option value="">-- Select Payment Type --</option>
        @foreach ($paymentTypes->where('parent_id', null) as $parent)
        @php $children = $paymentTypes->where('parent_id', $parent->id); @endphp
        @if ($children->isEmpty())
        <option value="{{ $parent->id }}">{{ $parent->name }}</option>
        @else
        <optgroup label="{{ $parent->name }}">
            @foreach ($children as $child)
            <option value="{{ $child->id }}">{{ $child->name }}</option>
            @endforeach
        </optgroup>
        @endif
        @endforeach
    </select>

    <div class="button-box">
        <button type="button" class="btn-add bg-green-500 text-white px-3 rounded">+</button>
        <button type="button" class="btn-remove bg-red-500 text-white px-3 rounded">-</button>
    </div>
</div>

<script>
    const storeTransactionRoute = "{{ route('donor.donation.store') }}";
</script>
<script src="{{ asset('js/members/addMemberDonation.js') }}"></script>
@endsection