@extends('master.authMaster')

@section('content')
<div class="intro-y col-span-12 lg:col-span-12 transection-details-view">
    <div class="intro-y box mt-8 shadow-lg rounded-2xl overflow-hidden">
        <div class="bg-gradient-to-r from-blue-600 to-indigo-600 p-5 pb-0">
            <h2 class="font-semibold text-lg text-black transation-details-heading">
                {{ ucfirst($data->transcation_type)}} Transaction Details:
                <a href="{{ route('transactions.print', ['id' => $data->id]) }}" target="_blank">
                    <button class="button text-white bg-theme-1 shadow-md">
                        Print Details
                    </button>
                </a>
            </h2>
            <!-- <div class="w-full sm:w-auto  mt-4 sm:mt-0 mr-4" style="float: right">
                <a href="{{ route('transactions.print', ['id' => $data->id]) }}" target="_blank">
                    <button class="button text-white bg-theme-1 shadow-md">
                        Print Details
                    </button>
                </a>
            </div> -->
        </div>

        <div class="py-4 px-5 bg-white">
            <div class="transaction-details-list">
                @if (isset($data->organisation_name))
                <div class="list-chart">
                    <p class="text-gray-600 font-medium">Organisation Name:</p>
                    <p class="text-blue-600 font-semibold">
                        {{ $data->organisation_name }}
                    </p>
                </div>
                @endif
                @if (isset($data->account_type_Name))
                <div class="list-chart">
                    <p class="text-gray-600 font-medium">Division Name:</p>
                    <p class="text-blue-600 font-semibold">
                        {{ $data->account_type_Name }}
                    </p>
                </div>
                @endif
                @if (isset($data->head_name))
                <div class="list-chart">
                    <p class="text-gray-600 font-medium">Income Head Name:</p>
                    <p class="text-blue-600 font-semibold">
                        {{ $data->head_name }}
                    </p>
                </div>
                @endif
                @if (isset($data->money_receipt_no))
                <div class="list-chart">
                    <p class="text-gray-600 font-medium">Money Receipt No. :</p>
                    <p class="text-blue-600 font-semibold">
                        {{ $data->money_receipt_no }}
                    </p>
                </div>
                @endif
                @if (!empty($data->asset_name))
                <div class="list-chart">
                    <p class="text-gray-600 font-medium">Asset Name:</p>
                    <p class="text-blue-600 font-semibold">
                        {{ $asset->asset_name }}
                    </p>
                </div>
                @endif
                @if (!empty($data->liability_name))
                <div class="list-chart">
                    <p class="text-gray-600 font-medium">Liability Name:</p>
                    <p class="text-blue-600 font-semibold">
                        {{ $data->liability_name }}
                    </p>
                </div>
                @endif
                @if (!empty($data->donor_name))
                <div class="list-chart">
                    <p class="text-gray-600 font-medium">Donor Name:</p>
                    <p class="text-blue-600 font-semibold">
                        {{ $data->donor_name }}
                        @if(!empty($data->donor_type))
                        @if ($data->donor_type == 'members')
                        - (Member)
                        @elseif($data->donor_type == 'non_members')
                        - (Non Member)
                        @elseif ($data->donor_type == 'foreign_members')
                        - (Family Member)
                        @endif
                        @endif
                    </p>
                </div>
                @endif
                @if (!empty($accounting_year))
                <div class="list-chart">
                    <p class="text-gray-600 font-medium">Accounting Year:</p>
                    <p class="text-blue-600 font-semibold">
                        {{ $accounting_year }}
                    </p>
                </div>
                @endif
                @if (!empty($data->transaction_date))
                <div class="list-chart">
                    <p class="text-gray-600 font-medium">Date of Transaction:</p>
                    <p class="text-blue-600 font-semibold">
                        {{ date('d-m-Y', strtotime($data->transaction_date)) }}
                    </p>
                </div>
                @endif
                @if (!empty($data->transaction_reference))
                <div class="list-chart">
                    <p class="text-gray-600 font-medium">Transaction Reference No.:</p>
                    <p class="text-blue-600 font-semibold">{{ $data->transaction_reference }}</p>
                </div>
                @endif
                @if (!empty($data->payment_type_name))
                <div class="list-chart">
                    <p class="text-gray-600 font-medium">Payment Type:</p>
                    <p class="text-blue-600 font-semibold">{{ $data->payment_type_name ?? '-' }}</p>
                </div>
                @endif
                @if (!empty($data->transaction_narration))
                <div class="md:col-span-2 list-chart">
                    <p class="text-gray-600 font-medium">Transaction Narration:</p>
                    <p class="text-blue-600 font-semibold italic">{{ $data->transaction_narration ?? '—' }}</p>
                </div>
                @endif
            
            @if (!empty($data->transaction_amount))
            <div class="list-chart">
                <p class="text-gray-600 font-medium">Transaction Amount:</p>
                <p class="text-green-600 text-xl font-bold">
                    ₹ {{ number_format($data->transaction_amount, 2) }}
                </p>
            </div>
            @endif
            @if (!empty($data->contra_reference_type))
            <div class="list-chart">
                <p class="text-gray-600 font-medium">Contra Type:</p>
                <p class="text-green-600 text-xl font-bold">
                     {{ $contra_ref[$data->contra_reference_type] }}
                </p>
            </div>
            @endif
            @if (!empty($data->to_bank_name))
            <div class="list-chart">
                <p class="text-gray-600 font-medium">To:</p>
                <p class="text-green-600 text-xl font-bold">
                     {{ $data->to_bank_name }}
                </p>
            </div>
            @endif
            @if (!empty($data->from_bank_name))
            <div class="list-chart">
                <p class="text-gray-600 font-medium">From:</p>
                <p class="text-green-600 text-xl font-bold">
                     {{ $data->from_bank_name }}
                </p>
            </div>
            @endif
            @if (!empty($data->file_path))
            </div>
            <div>
                <p class="text-black font-medium mb-2">Uploaded Files:</p>
                <div class="flex gap-4 flex-wrap">
                    @foreach (explode(',', $data->file_path) as $file)
                    @php
                    $file = trim($file);
                    $extension = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                    @endphp

                    @if ($extension === 'pdf')
                    <a href="{{ asset('storage' . $file) }}" target="_blank"
                        class="flex flex-col items-center justify-center w-32 h-32 bg-gray-100 border rounded shadow cursor-pointer">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-12 h-12 text-red-600"
                            fill="currentColor" viewBox="0 0 24 24">
                            <path
                                d="M6 2a2 2 0 0 0-2 2v16c0 1.1.9 2 2 2h12a2 2 0 0 0 2-2V8l-6-6H6zm7 1.5L18.5 9H13V3.5zM8 13h8v2H8v-2z" />
                        </svg>
                        <span class="text-sm text-gray-700">PDF File</span>
                    </a>
                    @else
                    <a href="{{ asset('storage/' . $file) }}" target="_blank">
                        <img src="{{ asset('storage/' . $file) }}" alt="Uploaded Image"
                            class="w-32 h-32 object-cover rounded shadow cursor-pointer">
                    </a>
                    @endif
                    @endforeach
                </div>
            </div>
            @endif
            @php
                if ($data->transcation_type === 'income') {
                    $backUrl = route('transactions.income');
                } elseif ($data->transcation_type === 'expense') {
                    $backUrl = route('transactions.expense');
                } elseif ($data->transcation_type === 'contra') {
                    $backUrl = route('transactions.contra.index');
                }
            @endphp
            <div class="mt-8 text-right">
                <a href="{{ $backUrl }}"
                    class="inline-flex items-center rounded-lg bg-gray-600 text-white font-medium hover:bg-gray-700 transition duration-200" style="padding: 8px 20px;">
                    ← Back to List
                </a>
            </div>
        </div>
    </div>
</div>
@endsection