@extends('master.authMaster')
@section('content')

@php
    $variable = 'expense';
@endphp
    <div class="ledgers-page-sec col-span-12 lg:col-span-12">
        <div class="ledgers-page-wraper flex w-full bg-white shadow-md rounded-2xl overflow-hidden">

            <!-- Sidebar / Filter Box -->
            <div class="w-full bg-white border-r">
                <div class="container">
                    <h2 class="text-lg font-semibold p-4 border-b">ExpenseLedger</h2>
                    @if ($ledger_summery->isEmpty())
                        <p class="p-4 text-gray-500">No Expense heads data found for this financial year.Please<a
                                href="{{ route('transactions.create')}}" style="color: blue"> Add Data</a> from Expense
                            Screen.</p>
                    @else
                        @foreach ($ledger_summery as $group)
                            @if (isset($group->head_group_id))
                                <div class="incm-ledg-sngl-box">
                                    <h3 class="font-bold mt-4">{{ Ucfirst($group->group_name) }}</h3>
                                    <ul class="income-head list-disc pl-6">
                                        @foreach ($group->heads as $head)
                                            <li class="mb-1">
                                                {{ $head->head_name }} -
                                                ₹ {{ $head->head_total ?? 0 }}
                                                <span>
                                                    <a href="{{ route('ledger.details', ['type' => $variable, 'id' => base64_encode($head->head_id)]) }}"class="text-blue-600 underline">View Details</a>
                                                </span>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                        @endforeach


                    @endif
                </div>

            </div>


        </div>
        <div class="mt-6">
            <button onclick="history.back()"
                class="px-4 py-2 rounded-lg bg-gray-500 hover:bg-gray-600 text-white shadow text-sm transition">
                ← Back
            </button>
        </div>
        <script>
            const tabs = document.querySelectorAll("#tabMenu li");
            const contents = document.querySelectorAll(".tab-content");

            function activateTab(tab) {
                // reset all
                tabs.forEach(el => el.classList.remove("border-blue-600", "bg-blue-50"));
                contents.forEach(c => c.classList.remove("active"));

                // activate clicked tab
                tab.classList.add("border-blue-600", "bg-blue-50");
                document.getElementById(tab.dataset.tab).classList.add("active");
            }

            // --- don't auto-open any tab on load ---
            // if (tabs.length > 0) {
            //   activateTab(tabs[0]);
            // }

            // click handling
            tabs.forEach(tab => {
                tab.addEventListener("click", () => activateTab(tab));
            });
        </script>



    </div>
@endsection
