@extends('master.authMaster')


@section('content')
    <div class="ledgers-page-sec col-span-12 lg:col-span-12">
        <div class="ledgers-page-wraper flex w-full bg-white shadow-md rounded-2xl overflow-hidden">

            <div class="w-full bg-white border-r pb-3">
                <h2 class="text-lg font-semibold p-4 border-b">Vendor Heads</h2>

                {{-- @if ($vendorsWithRecords->isEmpty())
                    <p class="p-4 text-gray-500">No Vendor data found for this financial year.Please<a
                            href="{{ route('transactions.create') }}" style="color: blue"> Add Data</a> from Expense
                        Screen.</p>
                @else
                    @foreach ($vendorsWithRecords as $vendor)
                     @php
                            $vendoeSlug = \Illuminate\Support\Str::slug($vendor->vendor_name);
                        @endphp
                        <ul id="tabMenu" class="income-head">
                            <li data-tab="tab1">
                                <a href="{{ route('ledger.vendor-details', ['vendor' => $vendoeSlug, 'id' => base64_encode($vendor->vendor_id)]) }}">
                                    {{ ucfirst($vendor->vendor_name) }}
                                </a>
                            </li>
                            <li>
                                Total amount paid to Vendor - ₹ {{ $vendor->transaction_amount }}
                                <span><a href="{{ route('ledger.vendor-details', ['vendor' => $vendoeSlug, 'id' => base64_encode($vendor->vendor_id)]) }}"
                                        class="edit-btn"> View Details </a></span>
                            </li>
                        </ul>
                    @endforeach
                @endif --}}

                @if ($vendorsWithRecords->isEmpty())
    <p class="p-4 text-gray-500">
        No Vendor data found for this financial year.
        Please <a href="{{ route('transactions.create') }}" style="color: blue">Add Data</a>
        from Expense Screen.
    </p>
@else
<div style="padding: 0 1rem;" class="income-head">
    <table id="tabMenu" class="w-full" style="border-radius: 10px; overflow: hidden">
        <thead>
            <tr style="background-color: #99a5b6;">
                <th style="text-align: left; width: 65%" class="p-3">Donor's Name</th>
                <th style="text-align: left" class="p-3">Amount Received</th>
                <th style="text-align: center" class="p-3">Action</th>
            </tr>
        </thead>


        <tbody>
            @foreach ($vendorsWithRecords as $vendor)
                @php
                    $vendoeSlug = \Illuminate\Support\Str::slug($vendor->vendor_name);
                @endphp

                <tr>
                    <td class="p-3">
                        <a href="{{ route('ledger.vendor-details', [
                            'vendor' => $vendoeSlug,
                            'id' => base64_encode($vendor->vendor_id)
                        ]) }}">
                            {{ ucfirst($vendor->vendor_name) }}
                        </a>
                    </td>

                    <td class="p-3">
                        ₹ {{ $vendor->transaction_amount }}
                    </td>

                    <td style="text-align: center;" class="p-3">
                        <a href="{{ route('ledger.vendor-details', [
                            'vendor' => $vendoeSlug,
                            'id' => base64_encode($vendor->vendor_id)
                        ]) }}" class="edit-btn">
                            View Details
                        </a>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endif




            </div>

        </div>
        <div class="mt-6">
            <button onclick="history.back()"
                class="px-4 py-2 rounded-lg bg-gray-500 hover:bg-gray-600 text-white shadow text-sm transition">
                ← Back
            </button>
        </div>

        <script>
            const tabs = document.querySelectorAll("#tabMenu li");
            const contents = document.querySelectorAll(".tab-content");

            function activateTab(tab) {
                // reset all
                tabs.forEach(el => el.classList.remove("border-blue-600", "bg-blue-50"));
                contents.forEach(c => c.classList.remove("active"));

                // activate clicked tab
                tab.classList.add("border-blue-600", "bg-blue-50");
                document.getElementById(tab.dataset.tab).classList.add("active");
            }

            // click handling
            tabs.forEach(tab => {
                tab.addEventListener("click", () => activateTab(tab));
            });
        </script>
    </div>
@endsection
