<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HeadController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AssetController;
use App\Http\Controllers\DonorController;
use App\Http\Controllers\ContraController;
use App\Http\Controllers\IncomeController;
use App\Http\Controllers\LedgerController;
use App\Http\Controllers\VendorController;
use App\Http\Controllers\CapitalController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\PurposeController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\HeadGroupController;
use App\Http\Controllers\LiabilityController;
use App\Http\Controllers\IncomeHeadController;
use App\Http\Controllers\ExpenseHeadController;
use App\Http\Controllers\LedgerDonorController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\BalanceSheetController;
use App\Http\Controllers\LedgerIncomeController;
use App\Http\Controllers\LedgerVendorController;
use App\Http\Controllers\LedgerExpenseController;
use App\Http\Controllers\AccountingYearController;
use App\Http\Controllers\ReceiptAndPaymentComtroller;
use App\Http\Controllers\JournalTransactionsController;
use App\Http\Controllers\AssetBroughtForwardController;
use App\Http\Controllers\LiabilityBroughtForwardController;
use App\Http\Controllers\AccountTypeController;

Route::get('/', function () {
    return view('login');
})->name('login');



Route::middleware('auth')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    //Head Groups Routes
    Route::prefix('head-groups')->name('head-groups.')->group(function () {
        Route::get('/', [HeadGroupController::class, 'index'])->name('index');
        Route::get('/create', [HeadGroupController::class, 'create'])->name('create');
        Route::post('/', [HeadGroupController::class, 'store'])->name('store');
        Route::get('/edit/{encodedId}', [HeadGroupController::class, 'edit'])->name('edit');
        Route::post('/update', [HeadGroupController::class, 'update'])->name('update');
        Route::post('/delete', [HeadGroupController::class, 'delete'])->name('delete');
        Route::post('/status', [HeadGroupController::class, 'changeStatus'])->name('status');
        Route::any('/details', [HeadGroupController::class, 'details'])->name('details');
    });

    //Accounting Year Routes : Tabulator used
    Route::get('/accounting-years', [AccountingYearController::class, 'index'])->name('accounting_years.index');
    Route::any('/accounting-years/details', [AccountingYearController::class, 'getAccountingYearDetails'])->name('accounting_years.details');
    Route::get('/accounting-years/create', [AccountingYearController::class, 'create'])->name('accounting_years.create');
    Route::post('/accounting-years', [AccountingYearController::class, 'store'])->name('accounting_years.store');
    Route::get('/accounting-years/{id}/edit', [AccountingYearController::class, 'edit'])->name('accounting_years.edit');
    Route::delete('/accounting-years/{id}', [AccountingYearController::class, 'destroy'])->name('accounting_years.destroy');
    Route::post('/accounting-years/{id}/status', [AccountingYearController::class, 'status'])->name('accounting_years.status');

    //Role Routes
    Route::get('/roles', [RoleController::class, 'index'])->name('roles.index');
    Route::get('/roles/create', [RoleController::class, 'create'])->name('roles.create');
    Route::post('/roles', [RoleController::class, 'store'])->name('roles.store');
    Route::get('/roles/{id}/edit', [RoleController::class, 'edit'])->name('roles.edit');
    Route::delete('/roles/{id}', [RoleController::class, 'destroy'])->name('roles.destroy');

    //User Routes : Tabulator used
    Route::get('/users', [UserController::class, 'index'])->name('users.index');
    Route::any('/users/details', [UserController::class, 'getUserDetails'])->name('users.details');
    Route::get('/users/create', [UserController::class, 'create'])->name('users.create');
    Route::post('/users', [UserController::class, 'store'])->name('users.store');
    Route::get('/users/edit/{id}', [UserController::class, 'edit'])->name('users.edit');
    Route::post('/users/update/{id}', [UserController::class, 'update'])->name('users.update');
    Route::delete('/users/delete', [UserController::class, 'destroy'])->name('users.destroy');
    Route::any('/users/{id}/status', [UserController::class, 'status'])->name('users.status');
    Route::get('/users/permissions/{id}', [UserController::class, 'permissions'])->name('users.permissions.index');
    Route::post('/users/permissions/store/{id}', [UserController::class, 'permissionsStore'])->name('users.permissions.store');


    // Yearly Capital Routes : Tabulator used
    Route::get('/capital', [CapitalController::class, 'index'])->name('capital.index');
    Route::any('/capital/details', [CapitalController::class, 'getcapitalDetails'])->name('capital.details');
    Route::get('/capital/create', [CapitalController::class, 'create'])->name('capital.create');
    Route::post('/capital', [CapitalController::class, 'store'])->name('capital.store');
    Route::get('/capital/each/details/{id}', [CapitalController::class, 'eachDetail'])->name('capital.eachDetail');
    Route::get('/capital/edit/{id}', [CapitalController::class, 'edit'])->name('capital.edit');
    Route::post('/capital/edit/{id}', [CapitalController::class, 'update'])->name('capital.update');
    Route::post('/capital/delete/{id}', [CapitalController::class, 'destroy'])->name('capital.destroy');
    Route::any('/capital/{id}/status', [CapitalController::class, 'status'])->name('capital.status');
    //for total cash in hand and cash at bank
    Route::get('/capital/total', [CapitalController::class, 'netCapital'])->name('capital.net.index');
    Route::any('/capital/amount/detail/history/{flag}', [CapitalController::class, 'getcapitalAmountDetails'])->name('capital.amount.detail.index');

    // Asset Brought Forward Routes : Tabulator used
    Route::get('/asset-brought-forward', [AssetBroughtForwardController::class, 'index'])->name('asset.brought.forward.index');
    Route::any('/asset-brought-forward/details', [AssetBroughtForwardController::class, 'getAssetBroughtForwardDetails'])->name('asset.brought.forward.details');
    Route::get('/asset-brought-forward/create', [AssetBroughtForwardController::class, 'create'])->name('asset.brought.forward.create');
    Route::post('/asset-brought-forward', [AssetBroughtForwardController::class, 'store'])->name('asset.brought.forward.store');
    Route::get('/asset-brought-forward/edit/{id}', [AssetBroughtForwardController::class, 'edit'])->name('asset.brought.forward.edit');
    Route::post('/asset-brought-forward/edit/{id}', [AssetBroughtForwardController::class, 'update'])->name('asset.brought.forward.update');
    Route::post('/asset-brought-forward/delete/{id}', [AssetBroughtForwardController::class, 'destroy'])->name('asset.brought.forward.destroy');

    // Liability Brought Forward Routes : Tabulator used
    Route::get('/liability-brought-forward', [LiabilityBroughtForwardController::class, 'index'])->name('liability.brought.forward.index');
    Route::any('/liability-brought-forward/details', [LiabilityBroughtForwardController::class, 'getLiabilityBroughtForwardDetails'])->name('liability.brought.forward.details');
    Route::get('/liability-brought-forward/create', [LiabilityBroughtForwardController::class, 'create'])->name('liability.brought.forward.create');
    Route::post('/liability-brought-forward', [LiabilityBroughtForwardController::class, 'store'])->name('liability.brought.forward.store');
    Route::get('/liability-brought-forward/edit/{id}', [LiabilityBroughtForwardController::class, 'edit'])->name('liability.brought.forward.edit');
    Route::post('/liability-brought-forward/edit/{id}', [LiabilityBroughtForwardController::class, 'update'])->name('liability.brought.forward.update');
    Route::post('/liability-brought-forward/delete/{id}', [LiabilityBroughtForwardController::class, 'destroy'])->name('liability.brought.forward.destroy');



    //Assets Routes :
    Route::get('/asset', [AssetController::class, 'index'])->name('asset.index');
    Route::any('/asset/details', [AssetController::class, 'getAssetDetails'])->name('asset.details');
    Route::get('/asset/create', [AssetController::class, 'create'])->name('asset.create');
    Route::post('/asset', [AssetController::class, 'store'])->name('asset.store');
    Route::get('/asset/each/details/{id}', [AssetController::class, 'eachDetail'])->name('asset.eachDetail');
    Route::get('/asset/edit/{id}', [AssetController::class, 'edit'])->name('asset.edit');
    Route::post('/asset/edit/{id}', [AssetController::class, 'update'])->name('asset.update');
    Route::post('/asset/delete/{id}', [AssetController::class, 'destroy'])->name('asset.destroy');
    Route::any('/asset/{id}/status', [AssetController::class, 'status'])->name('asset.status');

    // liability routes
    Route::get('/liability', [LiabilityController::class, 'index'])->name('liability.index');
    Route::any('/liability/details', [LiabilityController::class, 'getLiabilityDetails'])->name('liability.details');
    Route::get('/liability/create', [LiabilityController::class, 'create'])->name('liability.create');
    Route::any('/liability/store', [LiabilityController::class, 'store'])->name('liability.store');

    //Donor Routes :(Permission)
    Route::get('/donor', [DonorController::class, 'index'])->name('donor.index')->middleware('check.permission:view-menu,54');
    Route::any('/donor/details', [DonorController::class, 'getDonorDetails'])->name('donor.details');
    Route::get('/donor/create', [DonorController::class, 'create'])->name('donor.create')->middleware('check.permission:modify-menu,54');
    Route::any('/donor/store', [DonorController::class, 'store'])->name('donor.store');
    Route::get('/donor/edit/{id}', [DonorController::class, 'editDonor'])->name('donor.edit')->middleware('check.permission:modify-menu,54');
    Route::post('/donor/update', [DonorController::class, 'updateDonor'])->name('donor.update');
    Route::get('/donor/income-check/{donorId}', [DonorController::class, 'checkDonorIncome'])->name('donor.income.check');
    Route::post('/donor/transaction/store', [DonorController::class, 'submitTransaction'])->name('donor.transaction.store');
    // Route::any('/donor/subscription/store', [DonorController::class, 'subscriptionStore'])->name('donor.subscription.store');
    Route::get('/donor/donation/create', [DonorController::class, 'donationCreate'])->name('donor.donation.create');
    Route::POST('/donor/donation/store', [DonorController::class, 'donationStore'])->name('donor.donation.store');
    Route::get('/member/donation/create/{id}', [DonorController::class, 'memberDonationCreate'])->name('donor.member.donation.create');
    Route::POST('/member/donation/store', [DonorController::class, 'memberDonationStore'])->name('member.donation.store');
    Route::post('/check-donation-exists', [DonorController::class, 'checkDonationExists'])->name('donation.check');
    Route::get('/member/donation/list', [DonorController::class, 'memberDonationList'])->name('donor.member.donation.list');
    // Route::post('/member/donation/set-search-input', [DonorController::class, 'setFilterableName'])->name('donor.member.donation.set-search-input');


    // csv import route for members
    Route::get('/donors/import', [DonorController::class, 'importForm'])->name('donor.importForm');
    Route::post('/donors/import', [DonorController::class, 'importCSV'])->name('donors.importCSV');
    Route::get('/donors/download-sample-csv', [DonorController::class, 'downloadSampleCSV'])->name('donor.downloadSampleCSV');

    //Vendors Routes
    Route::get('/vendors', [VendorController::class, 'index'])->name('vendor.index');
    Route::get('/vendors/create', [VendorController::class, 'create'])->name('vendor.create');
    Route::post('/vendors', [VendorController::class, 'store'])->name('vendor.store');
    Route::get('/vendors/{id}/edit', [VendorController::class, 'edit'])->name('vendor.edit');
    Route::delete('/vendors/{id}', [VendorController::class, 'destroy'])->name('vendor.destroy');
    Route::get('/vendors/search', [VendorController::class, 'search'])->name('vendor.search');

    /* heads */
    Route::prefix('heads')->name('heads.')->group(function () {
        Route::get('/', [HeadController::class, 'index'])->name('index');
        Route::post('/list', [HeadController::class, 'list'])->name('list');
        Route::get('/create', [HeadController::class, 'create'])->name('create');
        Route::post('/', [HeadController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [HeadController::class, 'edit'])->name('edit');
        Route::post('/update', [HeadController::class, 'update'])->name('update');
        Route::post('/update-order', [HeadController::class, 'updateOrder'])->name('updateOrder');
        Route::get('/get-by-org-type', [HeadController::class, 'getByOrgType'])->name('get-by-org-type');
        Route::post('/status', [HeadController::class, 'changeStatus'])->name('status');
        Route::post('/delete', [HeadController::class, 'delete'])->name('delete');

    });

    Route::prefix('transactions')->name('transactions.')->group(function () {
        Route::get('/print/{id}', [JournalTransactionsController::class, 'print'])->name('print');
        Route::get('/detail/{id}', [JournalTransactionsController::class, 'eachDetail'])->name('eachDetail');
        Route::get('/income', [JournalTransactionsController::class, 'income'])->name('income');
        Route::post('/income/delete',[JournalTransactionsController::class, 'incomeDelete'])->name('income.delete');
        Route::post('/expense/delete',[JournalTransactionsController::class, 'expenseDelete'])->name('expense.delete');
        Route::post('/contra/delete',[JournalTransactionsController::class, 'contraDelete'])->name('contra.delete');
        Route::get('/expense', [JournalTransactionsController::class, 'expense'])->name('expense');
        Route::post('/list', [JournalTransactionsController::class, 'list'])->name('list');
        Route::get('/create', [JournalTransactionsController::class, 'create'])->name('create');
        Route::post('/', [JournalTransactionsController::class, 'store'])->name('store');
        Route::get('/head-group-info', [JournalTransactionsController::class, 'getHeadGroupInfo'])->name('head-group-info');
        Route::get('/contra', [ContraController::class, 'create'])->name('contra.create');
        Route::post('/contra', [ContraController::class, 'store'])->name('contra.store');
        Route::get('/contra/list', [ContraController::class, 'index'])->name('contra.index');
        Route::any('/contra/details', [ContraController::class, 'getContraDetails'])->name('contra.details');
        Route::get('/contra/{id}/modal', [ContraController::class, 'getDetailsForModal'])->name('contra.modal');
        Route::get('/contra/{id}', [ContraController::class, 'show'])->name('contra.show');
    });

    Route::get('/account-types/get-by-org', [AccountTypeController::class, 'getByOrg'])->name('account-types.get-by-org');

    Route::prefix('ledger')->name('ledger.')->group(function () {
        Route::get('/incomes', [LedgerController::class, 'income'])->name('incomes');
        Route::get('/expenses', [LedgerController::class, 'expense'])->name('expenses');
        Route::get('/donors', [LedgerController::class, 'donersLedger'])->name('donors');
        Route::get('/vendors', [LedgerController::class, 'vendorsLedger'])->name('vendors');
        Route::any('/donor/{donor}/details/{id}', [LedgerController::class, 'getDonorDetails'])->name('donor-details');
        Route::any('/vendor/{vendor}/details/{id}', [LedgerController::class, 'getVendorDetails'])->name('vendor-details');
        Route::any('/{type}/{id?}', [LedgerController::class, 'getIncomeHeadDetails'])->name('details');
    });
});
require __DIR__ . '/auth.php';
