<?php $__env->startSection('content'); ?>
<div class="intro-y listing-table col-span-12 lg:col-span-12">
    <div class="intro-y box mt-5 ">
        <div class="intro-y box mt-5">
            <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                <h2 class="font-medium text-base mr-auto">
                    Members Yearly Record
                </h2>
                <div style="display: flex; justify-content : between; align-items : center">
                    <p>
                        Membership Total Amount :
                    </p>
                    <p class="font-medium" style="padding-left: 5px;">
                        <strong>₹ <span id="final_total_funded_amount"><?php echo $totalAmount; ?></span></strong>
                    </p>
                </div>
            </div>
            <div style="margin-top: 4px;">
            </div>
            <div class="donation-list-table">
                <table class="member_donation_list">
                    <thead>
                        <tr style="background-color: #1c3faa1a;">
                            <td rowspan="2">Member's Name</td>
                            <td colspan="2"
                                style="padding-left: 0; padding-right: 0; padding-bottom: 0; text-align: center;">
                                <span
                                    style="padding-bottom: 10px; display: inline-block;"><?php echo e(ucwords($heads[0]['name'])); ?></span>
                                <table style="width: 100%;">
                                    <tr>
                                        <?php for ($i = 1; $i < 3; $i++) { ?>
                                            <td style="border-left: 0; border-bottom: 0; width: 50%; font-weight: 400;">
                                                <?php echo e(ucwords($heads[$i]['name'])); ?> (₹)
                                            </td>
                                        <?php } ?>
                                    </tr>
                                </table>
                            </td>
                            <?php $__currentLoopData = $heads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($key > 2): ?>
                            <td rowspan="2"><?php echo e(ucwords($head['name'])); ?> (₹)</td>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <td rowspan="2">Total (₹)</td>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $transactionsData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $totalSubsAmount = $data['transactions'][0]['total']; ?>
                        <tr>
                            <td><?php echo e($data['name']); ?></td>
                            <?php $__currentLoopData = $data['transactions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $headWiseTransactions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($headWiseTransactions['headName'] === 'Contingency Fund' || $headWiseTransactions['headName'] === 'Subscription') continue; ?>
                            <?php if($headWiseTransactions['headName'] === 'Yearly Subscription'): ?>

                            <td>
                                <?php if($totalSubsAmount > 0 && $totalSubsAmount < 500): ?>
                                    <span style="display:block;font-weight: 600;">
                                    <?php echo e(!empty($headWiseTransactions['total_subscription'])
                                                            ? number_format($headWiseTransactions['total_subscription'], 2)
                                                            : ''); ?>

                                    </span>
                                    <button
                                        class="add-subscription-btn bg-blue-500 hover:bg-green-600 text-white text-s px-2 py-1.5 rounded absolute bottom-1 right-1"
                                        data-account-type-id="<?php echo e($data['account_type_id']); ?>"
                                        data-donor-id="<?php echo e($data['donor_id']); ?>"
                                        data-head-id="<?php echo e($headWiseTransactions['headId']); ?>"
                                        data-head-name="<?php echo e($headWiseTransactions['headName']); ?>"
                                        data-head-group-id="<?php echo e($headWiseTransactions['headGroupId']); ?>"
                                        data-member="<?php echo e($data['name']); ?>"
                                        data-remaining-value="<?php echo e(500 - $headWiseTransactions['total'] <= 0 ? 0 : 500 - $headWiseTransactions['total']); ?>">
                                        +
                                    </button>
                                    <?php elseif(500 - $headWiseTransactions['total'] > 0): ?>
                                    <button
                                        class="add-subscription-btn bg-blue-500 hover:bg-green-600 text-white text-s px-2 py-1.5 rounded absolute bottom-1 right-1"
                                        data-account-type-id="<?php echo e($data['account_type_id']); ?>"
                                        data-donor-id="<?php echo e($data['donor_id']); ?>"
                                        data-head-id="<?php echo e($headWiseTransactions['headId']); ?>"
                                        data-head-name="<?php echo e($headWiseTransactions['headName']); ?>"
                                        data-head-group-id="<?php echo e($headWiseTransactions['headGroupId']); ?>"
                                        data-member="<?php echo e($data['name']); ?>">
                                        +
                                    </button>
                                    <?php elseif($headWiseTransactions['total'] >= 500): ?>
                                    <span style="display:block;font-weight: 600;">
                                        <?php echo e(!empty($headWiseTransactions['total_subscription'])
                                                            ? number_format($headWiseTransactions['total_subscription'], 2)
                                                            : ''); ?>

                                    </span>
                                    <?php endif; ?>
                                    <?php if(!empty($headWiseTransactions['transactions']) && count($headWiseTransactions['transactions']) > 1): ?>
                                    <strong
                                        style="display: inline-flex;gap: 5px;align-items: center;">
                                        <a class="btn" href="javascript:void(0)">
                                            <img src="<?php echo e(asset('build/assets/dist/images/problem.png')); ?>"
                                                onclick="openModalTable('<?php echo e($data['name']); ?>','<?php echo e($headWiseTransactions['total']); ?>' ,'<?php echo e(json_encode($headWiseTransactions['transactions'])); ?>')"
                                                alt="Problem" style="max-width:23px;">
                                        </a>
                                    </strong>
                                    <?php endif; ?>


                            </td>
                            <td>
                                <?php if($headWiseTransactions['total'] > 0): ?>
                                <span
                                    style="display:block;font-weight: 600;"><?php echo e(!empty($headWiseTransactions['total_contingent'])
                                                            ? number_format($headWiseTransactions['total_contingent'], 2)
                                                            : ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <?php else: ?>
                            <td>
                                <?php if(!empty($headWiseTransactions['transactions'])): ?>
                                <strong
                                    style="display: inline-flex;gap: 5px;align-items: center;"><?php echo e($headWiseTransactions['total']); ?>

                                    <?php if(count($headWiseTransactions['transactions']) > 1): ?>
                                    <a class="btn" href="javascript:void(0)">
                                        <img src="<?php echo e(asset('build/assets/dist/images/problem.png')); ?>"
                                            onclick="openModalTable('<?php echo e($data['name']); ?>','<?php echo e($headWiseTransactions['total']); ?>' ,'<?php echo e(json_encode($headWiseTransactions['transactions'])); ?>')"
                                            alt="Problem" style="max-width:23px;">
                                    </a>
                                    <?php endif; ?>
                                </strong>
                                <?php endif; ?>
                                <button
                                    class="add-donation-btn bg-blue-500 hover:bg-green-600 text-white text-s px-2 py-1.5 rounded absolute bottom-1 right-1"
                                    data-account-type-id="<?php echo e($data['account_type_id']); ?>"
                                    data-donor-id="<?php echo e($data['donor_id']); ?>"
                                    data-head-id="<?php echo e($headWiseTransactions['headId']); ?>"
                                    data-head-name="<?php echo e($headWiseTransactions['headName']); ?>"
                                    data-head-group-id="<?php echo e($headWiseTransactions['headGroupId']); ?>"
                                    data-member="<?php echo e($data['name']); ?>">
                                    +
                                </button>
                            </td>
                            <?php if(!empty($headWiseTransactions['transactions'])): ?>
                            <input type="hidden" class="total_amount"
                                value="<?php echo e($headWiseTransactions['total']); ?>">
                            <?php $__currentLoopData = $headWiseTransactions['transactions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tran): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" class="amt_date"
                                value="<?php echo e($tran['amount']); ?> (<?php echo e($tran['date']); ?>)">
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <td>
                                <?php echo $data['totalPurchase']; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div id="open-modal" class="modal-window" style="display:none;">
            <div class="modal-window-wraper">
                <a href="javascript:void(0)" title="Close" onclick="closeModalTable()" class="modal-close">x</a>
                <h4 class="modal_name">Name</h4>
                <table>
                    <tr>
                        <th style="text-align: left;">date</th>
                        <th style="text-align: right;">Amount</th>
                        <!-- <th style="text-align: right;">Payment Method</th> -->
                    </tr>
                    <tbody class="modal_body"></tbody>
                </table>
            </div>
        </div>
        <!-- Transaction Modal -->
        <div id="transactionModal"
            style="display:none; position:fixed; inset:0; background: rgba(0,0,0,0.5); z-index:50; justify-content:center; align-items: flex-start;">
            <div class="bg-white rounded-lg shadow-lg p-6 pb-3 relative member-year-table-modal"
                style="max-width: 600px; width: 100%;">
                <button type="button" id="modalTransactionCloseBtn" class="close-btn"
                    style="bottom: unset; top: 15px; right: 15px;">
                    ✕
                </button>
                <h2 id="modalHeading" class="text-lg font-bold mb-4"></h2>
                <div style="margin-bottom:10px;">
                    <label><strong>Member Name</strong></label>
                    <input readonly type="text" name="member_name" id="member_name"
                        style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px; background-color: #1c3faa47; font-weight: 600; color: #121b37;">
                </div>

                <form id="modalTransactionForm">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="account_type_id" id="account_type_id">
                    <input type="hidden" name="donor_id" id="donor_id">
                    <input type="hidden" name="head_id" id="head_id">
                    <input type="hidden" name="head_name" id="head_name">
                    <input type="hidden" name="head_group_id" id="head_group_id">
                    <div class="mb-3">
                        <label class="block text-sm font-medium">Transaction Date <span
                                style="color: red">*</span></label>
                        <input type="date" name="transaction_date" class="input border w-full _required "
                            id="transaction_date" max="<?php echo date('Y-m-d'); ?>">
                    </div>
                    <div style="margin-bottom:10px;">
                        <label>Payment Method <span style="color: red">*</span></label>
                        <select name="payment_type_id" id="payment_type_id"
                            style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px;"
                            class="_required">
                            <option value="">-- Select Payment Type --</option>
                            <?php $__currentLoopData = $paymentTypes->where('parent_id', null); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $children = $paymentTypes->where('parent_id', $parent->id); ?>
                            <?php if($children->isEmpty()): ?>
                            <option value="<?php echo e($parent->id); ?>"><?php echo e($parent->name); ?></option>
                            <?php else: ?>
                            <optgroup label="<?php echo e($parent->name); ?>">
                                <?php $__currentLoopData = $children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($child->id); ?>"><?php echo e($child->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </optgroup>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="block text-sm font-medium _required">Amount <span
                                style="color: red">*</span></label>
                        <input type="number" name="remaining_amount_value" id="remaining_amount_value"
                            class="input border w-full _required _amount" placeholder="Enter amount">
                        <span class="amount-error" style="color: red"></span>
                    </div>
                    <div style="margin-bottom:10px;">
                        <label>Money Receipt No <span style="color: red">*</span></label>
                        <input type="text" name="money_receipt_no" id="money_receipt_no" class="_required"
                            style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px;">
                    </div>
                    <div style="margin-bottom:10px;">
                        <label>Transaction Narration</label>
                        <textarea name="transaction_narration" id="transaction_narration" class=" _noJs _noCSS _noHTML"
                            style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px; margin-bottom : 12px;"></textarea>
                    </div>
                    <div class="flex justify-end space-x-2">
                        <button type="button" id="closeTransactionModal"
                            class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600"
                            style="position: relative; border-radius: 5px !important;">Cancel</button>
                        <button id="submitTransaction" type="button"
                            class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700"
                            style="position: relative; border-radius: 5px !important;">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script src="<?php echo e(asset('js/skj-validations@v2.js')); ?>"></script>
<script>
    const donors = <?php echo json_encode($donors, 15, 512) ?>;
    const storeTransactionRoute = "<?php echo e(route('donor.transaction.store')); ?>";
</script>
<script src="<?php echo e(asset('js/members/yearlyRecords.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/ramakrishna-sevashram/resources/views/donor/subscription/list.blade.php ENDPATH**/ ?>