<?php $__env->startSection('content'); ?>
    <div class="ledgers-page-sec bg-gray-100 col-span-12 lg:col-span-12 account-brot-for-pg">
        <div class="ledgers-page-wraper flex w-full bg-white shadow-md rounded-2xl overflow-hidden">
            <div class="w-full p-4">
                <div class="content-box">

                    <!-- Header -->
                    <div class="flex justify-between items-center">
                        <h3 class="text-base font-medium text-black">
                            <?php echo e(ucfirst($flag)); ?> Transaction History
                        </h3>
                    </div>
                    <ul class="listing-top" style="background-color: #3182ce14">
                        <li class="p-3">Total <?php echo e(ucfirst($flag)); ?> Amount Brought Forward</li>
                        <li class="p-3 text-right text-black font-semibold">
                            <?php echo e(number_format($forwardCapital, 2)); ?>

                        </li>
                    </ul>

                    <?php
                        $sl = 1;
                    ?>

                    <div class="sngl-box">
                        <table class="w-full text-left border-collapse shadow-sm rounded-lg overflow-hidden mb-3">
                            

                            <thead>
                                <tr>
                                    <td>Sl No.</td>
                                    <td>Date</td>
                                    <td>Income/Expense Heads</td>
                                    <td>Narration & Vendor/Donor Name</td>
                                    <td class="text-right">Amount</td>
                                </tr>

                            </thead>
                            <tbody class="divide-y">

                                <?php
                                    use Carbon\Carbon;

                                    // Step 1: Prepare array of IDs with type and date
                                    $transactionPointers = [];

                                    foreach ($incomeDatas as $income) {
                                        $transactionPointers[] = [
                                            'type' => 'income',
                                            'id' => $income->income_id,
                                            'date' => $income->transaction_date ?? $income->created_at,
                                        ];
                                    }

                                    foreach ($expenseDatas as $expense) {
                                        $transactionPointers[] = [
                                            'type' => 'expense',
                                            'id' => $expense->expense_id,
                                            'date' => $expense->transaction_date ?? $expense->created_at,
                                        ];
                                    }

                                    // Step 2: Sort by date descending
                                    usort($transactionPointers, function ($a, $b) {
                                        return Carbon::parse($b['date'])->timestamp <=>
                                            Carbon::parse($a['date'])->timestamp;
                                    });

                                    // Step 3: Initialize totals
                                    $incomeTotal = 0;
                                    $expenseTotal = 0;
                                ?>

                            <tbody class="divide-y">


                                
                                <?php $__currentLoopData = $transactionPointers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ptr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($ptr['type'] === 'income'): ?>
                                        <?php
                                            $data = $incomeDatas->firstWhere('income_id', $ptr['id']);
                                            $incomeTotal += $data->transaction_amount;
                                        ?>
                                        <tr class="hover:bg-gray-50 bg-green-50">
                                            <td class="p-3"><?php echo e($sl++); ?></td>
                                            <td class="p-3">
                                                <?php echo e(Carbon::parse($data->transaction_date ?? $data->created_at)->format('d-m-Y')); ?>

                                            </td>
                                            <td class="p-3"><?php echo e($data->incomeHead->income_head_name ?? '-'); ?></td>
                                            <td class="p-3">
                                                <?php echo e($data->transaction_narration ?? '-'); ?>

                                                <?php if($data->donor): ?>
                                                    (<?php echo e($data->donor->donor_name); ?>)
                                                <?php endif; ?>
                                            </td>
                                            <td class="p-3 text-right text-green-600 font-semibold">
                                                +<?php echo e(number_format($data->transaction_amount, 2)); ?>

                                            </td>
                                        </tr>
                                    <?php else: ?>
                                        <?php
                                            $data = $expenseDatas->firstWhere('expense_id', $ptr['id']);
                                            $expenseTotal += $data->transaction_amount;
                                        ?>
                                        <tr class="hover:bg-gray-50 bg-red-50">
                                            <td class="p-3"><?php echo e($sl++); ?></td>
                                            <td class="p-3">
                                                <?php echo e(Carbon::parse($data->transaction_date ?? $data->created_at)->format('d-m-Y')); ?>

                                            </td>
                                            <td class="p-3"><?php echo e($data->expenseHead->expense_head_name ?? '-'); ?></td>
                                            <td class="p-3">
                                                <?php echo e($data->transaction_narration ?? '-'); ?>

                                                <?php if($data->vendor): ?>
                                                    (<?php echo e($data->vendor->vendor_name); ?>)
                                                <?php elseif($data->staffVendor): ?>
                                                    (<?php echo e($data->staffVendor->vendor_name ?? $data->staffVendor->name); ?>)
                                                <?php endif; ?>
                                            </td>
                                            <td class="p-3 text-right text-red-600 font-semibold">
                                                -<?php echo e(number_format($data->transaction_amount, 2)); ?>

                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>

                            <tfoot>
                                <tr>
                                    <td colspan="4" class="p-3 text-right font-semibold">Total Income</td>
                                    <td class="p-3 text-right font-bold text-green-600">
                                        <?php echo e(number_format($incomeTotal, 2)); ?></td>
                                </tr>
                                <tr>
                                    <td colspan="4" class="p-3 text-right font-semibold">Total Expense</td>
                                    <td class="p-3 text-right font-bold text-red-600"><?php echo e(number_format($expenseTotal, 2)); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <?php $grandTotal = $forwardCapital + ($incomeTotal - $expenseTotal); ?>
                                    <td colspan="4" class="p-3 text-right font-semibold">Grand Total</td>
                                    <td
                                        class="p-3 text-right font-bold <?php echo e($grandTotal >= 0 ? 'text-green-700' : 'text-red-700'); ?>">
                                        <?php echo e(number_format($grandTotal, 2)); ?>

                                    </td>
                                </tr>
                            </tfoot>

                        </table>
                    </div>

                    <div class="mt-6">
                        <button onclick="history.back()"
                            class="px-4 py-2 rounded-lg bg-gray-500 hover:bg-gray-600 text-white shadow text-sm transition">
                            ← Back
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/ramakrishna-sevashram/resources/views/auth/capitals/totalHistory.blade.php ENDPATH**/ ?>