

<?php $__env->startSection('content'); ?>
    <?php
        $contraTypeLabels = [
            'cash_deposite' => 'Cash Deposit',
            'cash_withdraw' => 'Cash Withdrawal',
            'bank_transfer' => 'Bank Transfer'
        ];
        $contraTypeBadges = [
            'cash_deposite' => 'bg-green-100 text-green-800',
            'cash_withdraw' => 'bg-orange-100 text-orange-800',
            'bank_transfer' => 'bg-blue-100 text-blue-800'
        ];
        $contraType = $contraJournal->contra_reference_type ?? '';
    ?>

    <div class="col-span-12 lg:col-span-12">
        <div class="flex justify-between mt-5">
            <h2 class="text-lg font-medium mr-auto">
                Contra Entry Details
            </h2>
            <div class="w-full sm:w-auto flex mt-4 sm:mt-0 gap-2">
                <a href="<?php echo e(route('transactions.contra.index')); ?>">
                    <button class="button text-white bg-gray-600 hover:bg-gray-700 shadow-md">
                        ← Back to List
                    </button>
                </a>
                <a href="<?php echo e(route('transactions.contra.create')); ?>">
                    <button class="button text-white bg-theme-1 shadow-md">
                        <i data-feather="plus" class="w-4 h-4 mr-2"></i> Add New Entry
                    </button>
                </a>
            </div>
        </div>
    </div>

    <!-- Cash & Bank Summary Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mt-5">
        <div class="intro-y box p-5">
            <div class="flex items-center">
                <div class="flex-1">
                    <div class="text-gray-600 text-xs uppercase font-semibold">Opening Cash</div>
                    <div class="text-2xl font-bold text-gray-800 mt-1">
                        ₹<?php echo e(number_format($cashBankData['account_bf_cash_in_hand_opening'] ?? 0, 2)); ?>

                    </div>
                </div>
                <div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center">
                    <i data-feather="dollar-sign" class="w-6 h-6 text-green-600"></i>
                </div>
            </div>
        </div>

        <div class="intro-y box p-5">
            <div class="flex items-center">
                <div class="flex-1">
                    <div class="text-gray-600 text-xs uppercase font-semibold">Opening Bank</div>
                    <div class="text-2xl font-bold text-gray-800 mt-1">
                        ₹<?php echo e(number_format($cashBankData['account_bf_cash_at_bank_opening'] ?? 0, 2)); ?>

                    </div>
                </div>
                <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center">
                    <i data-feather="credit-card" class="w-6 h-6 text-blue-600"></i>
                </div>
            </div>
        </div>

        <div class="intro-y box p-5">
            <div class="flex items-center">
                <div class="flex-1">
                    <div class="text-gray-600 text-xs uppercase font-semibold">Total Cash</div>
                    <div class="text-2xl font-bold text-green-600 mt-1">
                        ₹<?php echo e(number_format($cashBankData['total_cash_in_hand'] ?? 0, 2)); ?>

                    </div>
                    <?php if(isset($cashBankData['contra_cash_adjustment']) && $cashBankData['contra_cash_adjustment'] != 0): ?>
                        <div class="text-xs text-gray-500 mt-1">
                            Contra: <?php echo e($cashBankData['contra_cash_adjustment'] > 0 ? '+' : ''); ?>₹<?php echo e(number_format($cashBankData['contra_cash_adjustment'], 2)); ?>

                        </div>
                    <?php endif; ?>
                </div>
                <div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center">
                    <i data-feather="trending-up" class="w-6 h-6 text-green-600"></i>
                </div>
            </div>
        </div>

        <div class="intro-y box p-5">
            <div class="flex items-center">
                <div class="flex-1">
                    <div class="text-gray-600 text-xs uppercase font-semibold">Total Bank</div>
                    <div class="text-2xl font-bold text-blue-600 mt-1">
                        ₹<?php echo e(number_format($cashBankData['total_cash_at_bank'] ?? 0, 2)); ?>

                    </div>
                    <?php if(isset($cashBankData['contra_bank_adjustment']) && $cashBankData['contra_bank_adjustment'] != 0): ?>
                        <div class="text-xs text-gray-500 mt-1">
                            Contra: <?php echo e($cashBankData['contra_bank_adjustment'] > 0 ? '+' : ''); ?>₹<?php echo e(number_format($cashBankData['contra_bank_adjustment'], 2)); ?>

                        </div>
                    <?php endif; ?>
                </div>
                <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center">
                    <i data-feather="trending-up" class="w-6 h-6 text-blue-600"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Details Card -->
    <div class="intro-y box p-5 mt-5">
        <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
            <h2 class="font-medium text-base mr-auto">
                Contra Entry Information
            </h2>
            <span class="px-3 py-1 rounded text-sm font-semibold <?php echo e($contraTypeBadges[$contraType] ?? 'bg-gray-100 text-gray-800'); ?>">
                <?php echo e($contraTypeLabels[$contraType] ?? ucfirst(str_replace('_', ' ', $contraType))); ?>

            </span>
        </div>

        <div class="p-5">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Left Column -->
                <div class="space-y-4">
                    <div>
                        <label class="form-label font-semibold text-gray-700">Transaction Reference</label>
                        <div class="mt-2 text-gray-900">
                            <?php echo e($contraJournal->transaction_reference ?? 'N/A'); ?>

                        </div>
                    </div>

                    <div>
                        <label class="form-label font-semibold text-gray-700">Organisation</label>
                        <div class="mt-2 text-gray-900">
                            <?php echo e($organisation->organisation_name ?? 'N/A'); ?>

                        </div>
                    </div>

                    <div>
                        <label class="form-label font-semibold text-gray-700">Contra Type</label>
                        <div class="mt-2">
                            <span class="px-3 py-1 rounded text-sm font-semibold <?php echo e($contraTypeBadges[$contraType] ?? 'bg-gray-100 text-gray-800'); ?>">
                                <?php echo e($contraTypeLabels[$contraType] ?? ucfirst(str_replace('_', ' ', $contraType))); ?>

                            </span>
                        </div>
                    </div>

                    <div>
                        <label class="form-label font-semibold text-gray-700">Total Transaction Amount</label>
                        <div class="mt-2 text-2xl font-bold text-green-600">
                            ₹<?php echo e(number_format($contraJournal->transaction_amount ?? 0, 2)); ?>

                        </div>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="space-y-4">
                    <div>
                        <label class="form-label font-semibold text-gray-700">Entry Date</label>
                        <div class="mt-2 text-gray-900">
                            <?php echo e(\Carbon\Carbon::parse($contraJournal->created_at)->format('d M Y, h:i A')); ?>

                        </div>
                    </div>

                    <div>
                        <label class="form-label font-semibold text-gray-700">Cash Deposit Allocated Amount</label>
                        <div class="mt-2 text-gray-900">
                            <?php if($contraJournal->contra_cash_depo_allocated_amount): ?>
                                ₹<?php echo e(number_format($contraJournal->contra_cash_depo_allocated_amount, 2)); ?>

                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </div>
                    </div>

                    <div>
                        <label class="form-label font-semibold text-gray-700">Transaction Narration</label>
                        <div class="mt-2 text-gray-900">
                            <?php echo e($contraJournal->transaction_narration ?? 'N/A'); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Contra Mapping Details -->
    <div class="intro-y box p-5 mt-5">
        <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
            <h2 class="font-medium text-base mr-auto">
                Transaction Details
            </h2>
            <span class="text-gray-600 text-sm">
                <?php echo e($contraMappings->count()); ?> <?php echo e($contraMappings->count() == 1 ? 'Entry' : 'Entries'); ?>

            </span>
        </div>

        <div class="p-5">
            <div class="overflow-x-auto">
                <table class="table table-report">
                    <thead>
                        <tr>
                            <th class="whitespace-nowrap">#</th>
                            <?php if($contraType == 'bank_transfer'): ?>
                                <th class="whitespace-nowrap">From Bank</th>
                            <?php endif; ?>
                            <th class="whitespace-nowrap"><?php echo e($contraType == 'bank_transfer' ? 'To Bank' : 'Bank'); ?></th>
                            <th class="whitespace-nowrap">Bank Amount (₹)</th>
                            <?php if($contraType == 'cash_deposite' || $contraType == 'cash_withdraw'): ?>
                                <th class="whitespace-nowrap">Cash Amount (₹)</th>
                            <?php endif; ?>
                            <th class="whitespace-nowrap">Transaction Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $contraMappings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $mapping): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $bank = $banks->get($mapping->bank_id);
                                $fromBank = $mapping->from_bank_id ? $banks->get($mapping->from_bank_id) : null;
                            ?>
                            <tr>
                                <td class="text-center"><?php echo e($index + 1); ?></td>
                                <?php if($contraType == 'bank_transfer'): ?>
                                    <td>
                                        <?php if($fromBank): ?>
                                            <div class="font-semibold"><?php echo e($fromBank->name); ?></div>
                                            <?php if($fromBank->account_number): ?>
                                                <div class="text-xs text-gray-500">A/C: <?php echo e($fromBank->account_number); ?></div>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <span class="text-gray-400">N/A</span>
                                        <?php endif; ?>
                                    </td>
                                <?php endif; ?>
                                <td>
                                    <?php if($bank): ?>
                                        <div class="font-semibold"><?php echo e($bank->name); ?></div>
                                        <?php if($bank->account_number): ?>
                                            <div class="text-xs text-gray-500">A/C: <?php echo e($bank->account_number); ?></div>
                                        <?php endif; ?>
                                        <?php if($bank->branch): ?>
                                            <div class="text-xs text-gray-500"><?php echo e($bank->branch); ?></div>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <span class="text-gray-400">N/A</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-right font-semibold text-green-600">
                                    ₹<?php echo e(number_format($mapping->bank_amount ?? 0, 2)); ?>

                                </td>
                                <?php if($contraType == 'cash_deposite' || $contraType == 'cash_withdraw'): ?>
                                    <td class="text-right font-semibold text-orange-600">
                                        ₹<?php echo e(number_format($mapping->cash_amount ?? 0, 2)); ?>

                                    </td>
                                <?php endif; ?>
                                <td>
                                    <?php if($mapping->bank_transaction_date): ?>
                                        <?php echo e(\Carbon\Carbon::parse($mapping->bank_transaction_date)->format('d M Y')); ?>

                                    <?php else: ?>
                                        <span class="text-gray-400">N/A</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="<?php echo e($contraType == 'bank_transfer' ? 5 : ($contraType == 'cash_deposite' || $contraType == 'cash_withdraw' ? 5 : 4)); ?>" class="text-center text-gray-500 py-8">
                                    No transaction details found.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                    <tfoot>
                        <tr class="font-bold bg-gray-50">
                            <td colspan="<?php echo e($contraType == 'bank_transfer' ? 2 : 1); ?>" class="text-right">
                                Total:
                            </td>
                            <?php if($contraType == 'bank_transfer'): ?>
                                <td></td>
                            <?php endif; ?>
                            <td class="text-right text-green-600">
                                ₹<?php echo e(number_format($contraMappings->sum('bank_amount'), 2)); ?>

                            </td>
                            <?php if($contraType == 'cash_deposite' || $contraType == 'cash_withdraw'): ?>
                                <td class="text-right text-orange-600">
                                    ₹<?php echo e(number_format($contraMappings->sum('cash_amount'), 2)); ?>

                                </td>
                            <?php endif; ?>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    <!-- Impact Summary -->
    <div class="intro-y box p-5 mt-5">
        <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
            <h2 class="font-medium text-base mr-auto">
                Impact Summary
            </h2>
        </div>

        <div class="p-5">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <?php if($contraType == 'cash_deposite'): ?>
                    <div class="bg-green-50 p-4 rounded-lg border border-green-200">
                        <div class="flex items-center">
                            <i data-feather="arrow-down" class="w-8 h-8 text-green-600 mr-3"></i>
                            <div>
                                <div class="text-sm text-gray-600">Cash Decreased</div>
                                <div class="text-xl font-bold text-green-600">
                                    ₹<?php echo e(number_format($contraMappings->sum('cash_amount'), 2)); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-blue-50 p-4 rounded-lg border border-blue-200">
                        <div class="flex items-center">
                            <i data-feather="arrow-up" class="w-8 h-8 text-blue-600 mr-3"></i>
                            <div>
                                <div class="text-sm text-gray-600">Bank Increased</div>
                                <div class="text-xl font-bold text-blue-600">
                                    ₹<?php echo e(number_format($contraMappings->sum('bank_amount'), 2)); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                <?php elseif($contraType == 'cash_withdraw'): ?>
                    <div class="bg-green-50 p-4 rounded-lg border border-green-200">
                        <div class="flex items-center">
                            <i data-feather="arrow-up" class="w-8 h-8 text-green-600 mr-3"></i>
                            <div>
                                <div class="text-sm text-gray-600">Cash Increased</div>
                                <div class="text-xl font-bold text-green-600">
                                    ₹<?php echo e(number_format($contraMappings->sum('cash_amount'), 2)); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-blue-50 p-4 rounded-lg border border-blue-200">
                        <div class="flex items-center">
                            <i data-feather="arrow-down" class="w-8 h-8 text-blue-600 mr-3"></i>
                            <div>
                                <div class="text-sm text-gray-600">Bank Decreased</div>
                                <div class="text-xl font-bold text-blue-600">
                                    ₹<?php echo e(number_format($contraMappings->sum('bank_amount'), 2)); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                <?php elseif($contraType == 'bank_transfer'): ?>
                    <div class="bg-blue-50 p-4 rounded-lg border border-blue-200">
                        <div class="flex items-center">
                            <i data-feather="arrow-down" class="w-8 h-8 text-red-600 mr-3"></i>
                            <div>
                                <div class="text-sm text-gray-600">Source Bank Decreased</div>
                                <div class="text-xl font-bold text-red-600">
                                    ₹<?php echo e(number_format($contraMappings->sum('bank_amount'), 2)); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-blue-50 p-4 rounded-lg border border-blue-200">
                        <div class="flex items-center">
                            <i data-feather="arrow-up" class="w-8 h-8 text-blue-600 mr-3"></i>
                            <div>
                                <div class="text-sm text-gray-600">Destination Bank Increased</div>
                                <div class="text-xl font-bold text-blue-600">
                                    ₹<?php echo e(number_format($contraMappings->sum('bank_amount'), 2)); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravelproject\ramkrishna-sevashram-new\resources\views/jounaltransactions/contra/show.blade.php ENDPATH**/ ?>