<?php $__env->startSection('content'); ?>





<div class="intro-y col-span-12 lg:col-span-12">

    <!-- BEGIN: Select Options -->
    <div class="intro-y box mt-5" style="padding: 20px 20px 20px 30px;">
        <h2 class="text-xl font-bold mb-6">Edit Head Group</h2>
        <?php
        $orgId = \App\Models\Organisation::current()->organisation_id;
        ?>

        <form id="groupStoreForm" action="<?php echo e(route('head-groups.update')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <div class="mt-3">
                        <input type="hidden" name="id" value="<?php echo e($headGroup->id); ?>">
                        <input type="hidden" name="organisation_id" value="<?php echo e($orgId); ?>">
                        <label>Organisation <span style="color: red">*</span></label>
                        <select id="organisation_id" class="input w-full border mt-2" disabled>
                            <option value="">-- Select Organisation --</option>
                            <?php $__currentLoopData = $organisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organisation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($organisation->organisation_id); ?>"
                                <?php echo e(old('organisation_id', $orgId) == $organisation->organisation_id ? 'selected' : ''); ?>>
                                <?php echo e($organisation->organisation_name); ?>

                            </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div>
                    <div class="mt-3">
                        <label>Head Group Name <span class="text-red-500">*</span></label>
                        <input type="text" id="name" name="name" class="w-full border p-2 rounded mt-2"
                            required value="<?php echo e($headGroup->name); ?>">
                    </div>
                </div>
            </div>

            <div class="sm:pl-5 mt-5">
                <a href="<?php echo e(route('head-groups.index')); ?>"
                    class="px-4 py-2 rounded bg-gray-500 hover:bg-gray-600 text-white shadow text-sm mr-3">Cancel</a>
                <button type="button" id="save-btn" class="button w-24 bg-theme-1 text-white">Save</button>
            </div>
        </form>
        
    </div>
</div>

<script>
    $(document).ready(function() {
        $('#save-btn').on('click', function(e) {
            // Check if form is valid before preventing submission
            let form = $('#groupStoreForm')[0];

            if (form.checkValidity()) {
                // disable the button to prevent multiple clicks
                $(this).prop('disabled', true).text('Submitting...');
                form.submit(); // submit the form
            } else {
                // Let browser show validation messages
                form.reportValidity();
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/ramakrishna-sevashram/resources/views/headGroups/edit.blade.php ENDPATH**/ ?>