<?php $__env->startSection('content'); ?>
<div class="intro-y col-span-12 lg:col-span-12">

    <!-- BEGIN: Select Options -->
    <div class="intro-y box mt-5 income-head-top-sec">
        <h2 class="text-lg font-medium mr-auto">Head Groups</h2>
        <div class="w-full sm:w-auto flex mt-4 sm:mt-0">
            <a href="<?php echo e(route('head-groups.create')); ?>">
                <button class="button text-white bg-theme-1 shadow-md">
                    Add Head Group
                </button>
            </a>
        </div>
    </div>
</div>
</div>
<!-- BEGIN: HTML Table Data -->
<div class="intro-y box p-5 mt-5">

    <div class="flex flex-col sm:flex-row sm:items-end xl:items-start">
        <form class="xl:flex w-full" id="tabulator-html-filter-form">

            <div class="sm:flex items-center justify-between w-full">
                <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center gap-2 flex-wrap">
                        <label for="page-size" class="form-label mb-0">Data Per Page</label>
                        <select id="page-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                            
                            <option value="10">10</option>
                            <option value="30">30</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                        </select>
                    </div>
                </div>
                <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center flex-wrap">
                        <label for="org-size" class="form-label mb-0">Income Heads as per Organisation:</label>
                        <select id="org-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                            <option value="">All Income Heads</option>
                        </select>
                    </div>
                </div>
                &nbsp; &nbsp; &nbsp;
                <div>
                    <input type="text" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border" id="search-string"
                        placeholder="Search...">
                </div>

            </div>
        </form>
    </div>
    <div class="overflow-x-auto scrollbar-hidden">
        <div class="mt-5 table-report table-report--tabulator" id="accounting-year-table"></div>
    </div>
</div>
<!-- END: HTML Table Data -->

<link href="<?php echo e(asset('build/assets/css/tabulator.min.css')); ?>" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/tabulator/6.3.1/css/tabulator_materialize.min.css" rel="stylesheet">
<script type="text/javascript" src="https://unpkg.com/tabulator-tables@6.3.1/dist/js/tabulator.min.js"></script>
<script>
    $(document).ready(function() {

        <?php if(session('success')): ?>
        Swal.fire({
            icon: 'success',
            title: 'Success!',
            text: <?php echo json_encode(session('success'), 15, 512) ?>,
            timer: 2500,
            showConfirmButton: false
        });
        <?php endif; ?>

        <?php if(session('error')): ?>
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: <?php echo json_encode(session('error'), 15, 512) ?>,
            timer: 2500,
            showConfirmButton: false
        });
        <?php endif; ?>

    });
</script>

<?php echo $__env->make('utils.alert', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<script>
    var currentYearRange =
        "<?php echo e(\Carbon\Carbon::createFromDate(date('Y'), 4, 1)->format('d-m-Y') . ' to ' . \Carbon\Carbon::createFromDate(date('Y') + 1, 3, 31)->format('d-m-Y')); ?>";
    var table = new Tabulator("#accounting-year-table", {
        ajaxURL: "<?php echo e(route('head-groups.details')); ?>",
        ajaxParams: function() {
            return {
                _token: document.querySelector('meta[name="csrf-token"]').getAttribute("content"),
                search: document.querySelector("#search-string").value,
                organisation_id: document.querySelector("#org-size").value,

            };
        },

        ajaxConfig: "POST",
        layout: "fitColumns",
        theme: "bootstrap5",
        paginationMode: "remote",
        pagination: true,
        paginationSize: 10,
        paginationSizeSelector: false,
        layout: "fitColumns",
        search: true,
        movableRows: true,
        movableColumns: true,
        // 🔹 Custom loader spinner
        ajaxLoaderLoading: `
                   <div style='display:inline-block; border:4px solid #333; border-radius:10px; background:#fff; font-weight:bold; font-size:16px; color:#000; padding:10px 20px;'>Loading Data</div>
                `,

        // placeholder: "<span style='color: red; font-size: 16px; font-weight: bold;'>No Data Available</span>",

        columnDefaults: {
            headerHozAlign: "left",
            tooltip: true,
        },
        columns: [{
                title: "SL",
                formatter: function(cell, formatterParams, onRendered) {
                    let row = cell.getRow();
                    let data = row.getData();
                    let page = table.getPage();
                    let perPage = table.getPageSize();

                    if (!page) page = 0;
                    if (!perPage) perPage = 10;

                    return ((row.getPosition(true) + 1) + ((page - 1) * perPage) - 1);
                },
                maxWidth: 150
            },
            {
                title: "Income Head Name",
                field: "name",
                headerSort: true,
                minWidth: 200
            },
            {
                title: "Organisation",
                field: "organisation_name",

                headerSort: true,
                minWidth: 200
            },
            {
                title: "Status",
                headerHozAlign: "center",
                formatter: function(cell) {
                    let data = cell.getRow().getData();
                    if (data.status === 'active') {
                        return `<button class="status-btn" data-id="${data.id}"  data-status="${data.status}" style="color: #ffffff;background: green;border-radius: 25px; width: 70px;">${data.status}</button> `;
                    }else{
                        return `<button class="status-btn" data-id="${data.id}" data-status="${data.status}" style="color: #ffffff;background: red;border-radius: 25px; width: 70px;">${data.status}</button> `;

                    }
                },
                hozAlign: "center",
                width: 180,
            },
            {
                title: "Action",
                headerHozAlign: "center",
                formatter: function(cell) {
                    let data = cell.getRow().getData();
                    return `
                    <button class="edit-btn" data-id="${data.id}" style="color: blue;"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="feather feather-check-square w-4 h-4 mr-1"><polyline points="9 11 12 14 22 4"></polyline><path d="M21 12v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11"></path>
</svg></button>
                    <button class="delete-btn" data-id="${data.id}"style="color: red;"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2 w-4 h-4 mr-1">
<polyline points="3 6 5 6 21 6"></polyline>
<path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
<line x1="10" y1="11" x2="10" y2="17"></line>
<line x1="14" y1="11" x2="14" y2="17"></line>
</svg></button>
                `;
                },
                hozAlign: "center",
                width: 180,
            },

        ],
        rowFormatter: function(row) {
            const data = row.getData();
            if (data.is_current === 1) {
                row.getElement().style.backgroundColor = "lightblue";
                row.getElement().style.color = "black";
            }
        },

        ajaxResponse: function(url, params, response) {
            return {
                data: response.data,
                last_page: response.last_page,
                current_page: response.current_page,
                total: response.total
            };
        }
    });

    $(document).on('click', '.edit-btn', function() {
        let id = $(this).data('id');
        let encodedId = btoa(id);
        window.location.href = `/head-groups/edit/${encodedId}`; // Redirect to edit page
    });

    $(document).on('click', '.delete-btn', function() {
        let id = $(this).data('id');

        Swal.fire({
            title: "Are you sure?",
            text: "This record will be deleted!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonText: "Yes, delete it!",
            cancelButtonText: "Cancel"
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "<?php echo e(route('head-groups.delete')); ?>",
                    type: 'POST',
                    data: {
                        id: id,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.status) {
                            Swal.fire("Deleted!", response.message, "success");
                            table.replaceData(); // 🔄 reload Tabulator data
                        } else {
                            Swal.fire("Error!", response.message || "Failed to delete", "error");
                        }
                    },
                    error: function(xhr) {
                        Swal.fire("Error!", "An error occurred while deleting.", "error");
                    }
                });
            }
        });
    });
    $(document).on('click', '.status-btn', function() {
        let id = $(this).data('id');
        let status = $(this).data('status');
        console.log(status);
        let newStatus = status === 'active' ? 'inactive' : 'active';

        Swal.fire({
            title: "Are you sure?",
            text: "You want to make it '" + newStatus + "'",
            icon: "warning",
            showCancelButton: true,
            confirmButtonText: "Yes!",
            cancelButtonText: "Cancel"
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "<?php echo e(route('head-groups.status')); ?>",
                    type: 'POST',
                    data: {
                        id: id,
                        new_status: newStatus,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.status) {
                            Swal.fire("Changed!", response.message, "success");
                            table.replaceData(); // 🔄 reload Tabulator data
                        } else {
                            Swal.fire("Error!", response.message || "Failed to change", "error");
                        }
                    },
                    error: function(xhr) {
                        Swal.fire("Error!", "An error occurred while changing status.", "error");
                    }
                });
            }
        });
    });

    document.getElementById("page-size").addEventListener("change", function() {
        table.setPageSize(Number(this.value));
    });
    document.getElementById("org-size").addEventListener("change", function() {
        table.setData();
    });
    document.getElementById("search-string").addEventListener("input", function() {
        table.setData();
    });
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/ramakrishna-sevashram/resources/views/headGroups/index.blade.php ENDPATH**/ ?>