<?php $__env->startSection('content'); ?>
    <div class="ledgers-page-sec bg-gray-100 col-span-12 lg:col-span-12">
        <div class="ledgers-page-wraper flex w-full bg-white shadow-md rounded-2xl overflow-hidden">
            <div class="w-full p-4">
                <div class="content-box">

                    <!-- Date Filter -->
                    

                    <div class="flex justify-between items-center mb-4">

                        <div>
                            <h3 class="text-base font-medium text-black">
                                 <?php echo e(ucfirst($vendor->vendor_name)); ?>

                            </h3>
                        </div>

                        <div class="flex gap-4 items-end">
                            <div>
                                <label for="from_date" class="text-sm">From Date</label>
                                <input type="date" id="from_date" class="border rounded p-2">
                            </div>
                            <div>
                                <label for="to_date" class="text-sm">To Date</label>
                                <input type="date" id="to_date" class="border rounded p-2">
                            </div>
                            <div class="flex items-end gap-2">
                                <button type="button" id="filterBtn"
                                    class="bg-blue-600 text-white px-4 py-2 rounded shadow">Filter</button>
                                <button type="button" id="clearBtn"
                                    class="bg-gray-500 text-white px-4 py-2 rounded shadow">Clear</button>
                            </div>
                        </div>

                    </div>

                    <?php if($vendorType == 'internal'): ?>
                        <?php if(isset($vendorRecords) && $vendorRecords->count() > 0): ?>
                            <div class="sngl-box">
                                <!-- Cash Payments -->
                                <div>
                                    <h3 class="text-base font-medium mb-2 text-black mb-4">Transaction History</h3>
                                    <?php
                                        $totalAmountSum = 0;
                                        $paidAmountSum = 0;
                                    ?>
                                    <table
                                        class="w-full text-left border-collapse shadow-sm rounded-lg overflow-hidden mb-3">
                                        <thead>
                                            <tr class="bg-gray-100 text-gray-700">
                                                <th class="p-3">Date</th>
                                                <th class="p-3">Expense Head Name</th>
                                                <th class="p-3">Narration</th>
                                                <th class="p-3 text-right">Total Salary Paid</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody id="cashTable" class="divide-y"></tbody>
                                        <tfoot>
                                            <?php $__empty_1 = true; $__currentLoopData = $vendorRecords; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <?php
                                                    $totalAmountSum += $record->total_amount;
                                                    $paidAmountSum += $record->paid_amount;
                                                    $balance = $record->total_amount - $record->paid_amount;
                                                ?>
                                                <tr class="hover:bg-gray-50">
                                                    <td class="p-3">
                                                        <?php echo e(\Carbon\Carbon::parse($record->created_at)->format('d-m-Y')); ?>

                                                    </td>
                                                    <td class="p-3"><?php echo e($record->expense_head_name ?? '-'); ?></td>
                                                    <td class="p-3"><?php echo e($record->transaction_narration ?? '-'); ?></td>

                                                    <td class="p-3 text-right text-blue-600">₹
                                                        <?php echo e(number_format($record->paid_amount, 2)); ?></td>
                                                    
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <tr>
                                                    <td colspan="5" class="p-3 text-center text-gray-500">No records
                                                        found
                                                    </td>
                                                </tr>
                                            <?php endif; ?>

                                        </tfoot>
                                    </table>
                                </div>


                                <!-- Grand Total -->
                                <div class="mt-4">
                                    <table class="w-full text-left border-collapse shadow-sm rounded-lg overflow-hidden">
                                        <tfoot>
                                            <?php $grandBalance = $totalAmountSum - $paidAmountSum; ?>
                                            <tr class="bg-gray-200 font-bold">
                                                <td></td>
                                                <td class="p-3 text-right">Grand Total</td>
                                                <td class="p-3 text-right">₹ <?php echo e(number_format($totalAmountSum, 2)); ?></td>
                                                <td class="p-3 text-right">₹ <?php echo e(number_format($paidAmountSum, 2)); ?></td>
                                                
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>

                            </div>
                        <?php else: ?>
                            <div class="sngl-box">
                                <p>No records found !!</p>
                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <?php if(isset($vendorRecords) && $vendorRecords->count() > 0): ?>
                            <div class="sngl-box">
                                <!-- Cash Payments -->
                                <div>
                                    <h3 class="text-base font-medium mb-2 text-black mb-4">Transaction History</h3>
                                    <?php
                                        $totalAmountSum = 0;
                                        $paidAmountSum = 0;
                                    ?>
                                    <table
                                        class="w-full text-left border-collapse shadow-sm rounded-lg overflow-hidden mb-3">
                                        <thead>
                                            <tr class="bg-gray-100 text-gray-700">
                                                <th class="p-3">Date</th>
                                                <th class="p-3">Expense Head Name</th>
                                                <th class="p-3">Narration</th>
                                                <th class="p-3 text-right">Total Payment Amount</th>
                                                <th class="p-3 text-right">Total Paid Amount</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody id="cashTable" class="divide-y"></tbody>
                                        <tfoot>
                                            <?php $__empty_1 = true; $__currentLoopData = $vendorRecords; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <?php
                                                    $totalAmountSum += $record->total_amount;
                                                    $paidAmountSum += $record->paid_amount;
                                                    $balance = $record->total_amount - $record->paid_amount;
                                                ?>
                                                <tr class="hover:bg-gray-50">
                                                    <td class="p-3">
                                                        <?php echo e(\Carbon\Carbon::parse($record->created_at)->format('d-m-Y')); ?>

                                                    </td>
                                                    <td class="p-3"><?php echo e($record->expense_head_name ?? '-'); ?></td>
                                                    <td class="p-3"><?php echo e($record->transaction_narration ?? '-'); ?></td>
                                                    <td class="p-3 text-right text-blue-600">₹
                                                        <?php echo e(number_format($record->total_amount, 2)); ?></td>
                                                    <td class="p-3 text-right text-blue-600">₹
                                                        <?php echo e(number_format($record->paid_amount, 2)); ?></td>
                                                    <td
                                                        class="p-3 text-right font-bold
                                               <?php echo e($balance > 0 ? 'text-red-600' : ($balance < 0 ? 'text-orange-600' : 'text-green-600')); ?>">
                                                        <?php if($balance > 0): ?>
                                                            Due: ₹ <?php echo e(number_format($balance, 2)); ?>

                                                        <?php elseif($balance < 0): ?>
                                                            Extra: ₹ <?php echo e(number_format(abs($balance), 2)); ?>

                                                        <?php else: ?>
                                                            Cleared
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <tr>
                                                    <td colspan="5" class="p-3 text-center text-gray-500">No records
                                                        found
                                                    </td>
                                                </tr>
                                            <?php endif; ?>

                                        </tfoot>
                                    </table>
                                </div>


                                <!-- Grand Total -->
                                <div class="mt-4">
                                    <table class="w-full text-left border-collapse shadow-sm rounded-lg overflow-hidden">
                                        <tfoot>
                                            <?php $grandBalance = $totalAmountSum - $paidAmountSum; ?>
                                            <tr class="bg-gray-200 font-bold">
                                                <td></td>
                                                <td class="p-3 text-right">Grand Total</td>
                                                <td class="p-3 text-right">₹ <?php echo e(number_format($totalAmountSum, 2)); ?></td>
                                                <td class="p-3 text-right">₹ <?php echo e(number_format($paidAmountSum, 2)); ?></td>
                                                <td
                                                    class="p-3 text-right
                                     <?php echo e($grandBalance > 0 ? 'text-red-600' : ($grandBalance < 0 ? 'text-orange-600' : 'text-green-600')); ?>">
                                                    <?php if($grandBalance > 0): ?>
                                                        Outstanding Balance : ₹ <?php echo e(number_format($grandBalance, 2)); ?>

                                                    <?php elseif($grandBalance < 0): ?>
                                                        Extra: ₹ <?php echo e(number_format(abs($grandBalance), 2)); ?>

                                                    <?php else: ?>
                                                        Cleared
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>

                            </div>
                        <?php else: ?>
                            <div class="sngl-box">
                                <p>No records found !!</p>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="mt-6">
            <button onclick="history.back()"
                class="px-4 py-2 rounded-lg bg-gray-500 hover:bg-gray-600 text-white shadow text-sm transition">
                ← Back
            </button>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravelproject\ramkrishna-sevashram-new\resources\views/ledgers/vendor_detail.blade.php ENDPATH**/ ?>