<?php $__env->startSection('content'); ?>
    <?php
        use Carbon\Carbon;
        $financialYear = \App\Models\AccountingYear::current();
        $currentOrg = \App\Models\Organisation::current();
        $orgId = $currentOrg ? $currentOrg->organisation_id : null;

        if ($financialYear) {
            [$fyStart, $fyEnd] = array_map('trim', explode(' to ', $financialYear->accounting_year_financial));
            $minDate = Carbon::createFromFormat('d-m-Y', $fyStart)->toDateString();
            $maxDateCandidate = Carbon::createFromFormat('d-m-Y', $fyEnd);
            $today = Carbon::today();
            $maxDate = $today->greaterThan($maxDateCandidate)
                ? $maxDateCandidate->toDateString()
                : $today->toDateString();
        } else {
            $minDate = now()->subYear()->toDateString();
            $maxDate = now()->toDateString();
        }
    ?>

    <div class="intro-y col-span-12 lg:col-span-12">
        <div class="intro-y box mt-5">
            <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                <h2 class="font-medium text-base mr-auto">
                    Transaction Entry
                </h2>
            </div>

            <!-- Tabs Navigation -->
            <div class="transaction-create-page p-5 border-b border-gray-200 pb-0" style="background-color: #f0f4ff">
                <ul class="flex flex-wrap -mb-px text-sm font-medium text-center" id="transactionTabs" role="tablist">
                    <li class="mr-2" role="presentation">
                        <button class="inline-block p-4 border-b-2 rounded-t-lg active" id="income-tab" data-tab="income"
                            type="button" role="tab">
                            <i class="w-4 h-4 mr-2">💰</i> Income Transaction
                        </button>
                    </li>
                    <li class="mr-2" role="presentation">
                        <button
                            class="inline-block p-4 border-b-2 rounded-t-lg border-transparent hover:text-gray-600 hover:border-gray-300"
                            id="expense-tab" data-tab="expense" type="button" role="tab">
                            <i class="w-4 h-4 mr-2">💸</i> Expense Transaction
                        </button>
                    </li>
                    <li class="mr-2" role="presentation">
                        <button
                            class="inline-block p-4 border-b-2 rounded-t-lg border-transparent hover:text-gray-600 hover:border-gray-300"
                            id="contra-tab" data-tab="contra" type="button" role="tab">
                            <i class="w-4 h-4 mr-2">🔄</i> Contra Entry
                        </button>
                    </li>
                </ul>
            </div>

            <!-- Tab Content -->
            <div class="p-5">
                <!-- Single Form for Both Income and Expense -->
                <form id="transactionForm" method="POST" enctype="multipart/form-data"
                    action="<?php echo e(route('transactions.store')); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="transcation_type" id="transaction_type" value="income">

                    <div class="grid grid-cols-12 gap-5">
                        <div class="col-span-12 md:col-span-6">
                            <label for="organisation_id" class="form-label font-semibold">
                                Organisation <span class="text-red-500">*</span>
                            </label>
                            <select name="organisation_id" id="organisation_id"
                                class="input w-full border mt-2 custm-drpdwn" required>
                                <option value="">-- Select Organisation --</option>
                                <?php $__currentLoopData = $organisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organisation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($organisation->organisation_id); ?>"
                                        <?php echo e((string) $orgId === (string) $organisation->organisation_id ? 'selected' : ''); ?>>
                                        <?php echo e($organisation->organisation_name); ?>

                                        <?php echo e($organisation->is_current ? '(Current)' : ''); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-organisation"></div>
                        </div>

                        <div class="col-span-12 md:col-span-6">
                            <label for="account_type_id" class="form-label font-semibold">Division</label>
                            <select name="account_type_id" id="account_type_id"
                                class="input w-full border mt-2 custm-drpdwn">
                                <option value="">-- Select Division --</option>
                            </select>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-account-type"></div>
                        </div>

                        <div class="col-span-12 md:col-span-6">
                            <label for="head_id" class="form-label font-semibold">
                                Heads <span class="text-red-500">*</span>
                            </label>
                            <select name="head_id" id="head_id" class="input w-full border mt-2 custm-drpdwn"
                                required>
                                <option value="">-- Select Head --</option>
                                <?php if(!empty($allHeads)): ?>
                                    <?php $__currentLoopData = $allHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>{
                                        <option value="<?php echo e($head['id']); ?>">
                                            <?php echo e($head['name']); ?>

                                        </option>
                                    }
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-head"></div>
                        </div>

                        <!-- Asset Selection - Only visible when head group is Assets -->
                        <div id="assetSection" class="col-span-12 md:col-span-6" style="display: none;">
                            <label for="asset_id" class="form-label font-semibold">
                                Asset <span class="text-red-500">*</span>
                            </label>
                            <div class="relative">
                                <input type="text" id="asset_search" class="input w-full border mt-2"
                                    placeholder="Type to search asset..." autocomplete="off">
                                <input type="hidden" name="asset_id" id="asset_id">
                                <ul id="assetOptions"
                                    class="absolute z-50 w-full bg-white border border-gray-300 rounded-md shadow-lg mt-1 max-h-60 overflow-y-auto hidden">
                                    <?php if(!empty($assets)): ?>
                                        <?php $__currentLoopData = $assets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asset): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li data-id="<?php echo e($asset->asset_id); ?>"
                                                class="px-3 py-2 hover:bg-gray-100 cursor-pointer">
                                                <?php echo e($asset->asset_name); ?>

                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-asset"></div>
                        </div>

                        <div class="col-span-12 md:col-span-6">
                            <label for="payment_type_id" class="form-label font-semibold">Payment Type</label>
                            <select name="payment_type_id" id="payment_type_id"
                                class="input w-full border mt-2 custm-drpdwn">
                                <option value="">-- Select Payment Type --</option>
                                <?php $__currentLoopData = $paymentTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paymentType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($paymentType->id); ?>">
                                        <?php echo e($paymentType->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-payment-type"></div>
                        </div>

                        <!-- Pay To Section - Only visible for Expense Tab -->
                        <div id="payToSection" class="col-span-12" style="display: none;">
                            <label class="form-label font-semibold">
                                Pay To <span class="text-red-500">*</span>
                            </label>
                            <div class="mt-2" style="background-color: #f1f1f1c2; padding: 15px; border-radius: 5px;">
                                <div class="flex gap-4 mb-3 items-center">
                                    <label class="flex items-center">
                                        <input type="radio" name="pay_to" value="external" id="pay_to_vendor"
                                            class="mr-2">
                                        <span>Vendor</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="radio" name="pay_to" value="internal" id="pay_to_staff"
                                            class="mr-2">
                                        <span>Staff</span>
                                    </label>
                                    <button type="button" id="clearPayToBtn"
                                        class="px-3 py-1 text-sm hover:bg-gray-300 text-gray-700 rounded border" style="background-color: #fbb4b4;color: #000;border: none;">
                                        Clear
                                    </button>
                                </div>

                                <!-- Searchable Select for Vendor/Staff -->
                                <div id="vendorStaffSelectContainer" style="display: none;">
                                    <div class="relative">
                                        <input type="text" id="vendor_staff_search"
                                            class="input w-full border mt-2"
                                            placeholder="Type to search vendor or staff name..."
                                            autocomplete="off">
                                        <input type="hidden" name="vendor_staff_id" id="vendor_staff_id">
                                        <ul id="vendorStaffOptions"
                                            class="absolute z-50 w-full bg-white border border-gray-300 rounded-md shadow-lg mt-1 max-h-60 overflow-y-auto hidden">
                                        </ul>
                                    </div>
                                    <div class="text-red-500 text-sm mt-1 error-message" id="error-vendor-staff"></div>
                                </div>

                                <!-- Bill Amount Field - Only visible for Vendor -->
                                <div id="billAmountContainer" style="display: none;" class="mt-3">
                                    <label for="bill_amount" class="form-label font-semibold">
                                        Bill Amount (₹) <span class="text-red-500">*</span>
                                    </label>
                                    <input type="number" min="0" step="0.01" name="bill_amount"
                                        id="bill_amount" class="input w-full border mt-2"
                                        placeholder="Enter bill amount">
                                    <div class="text-red-500 text-sm mt-1 error-message" id="error-bill-amount"></div>
                                </div>
                            </div>
                        </div>

                        <div class="col-span-12 md:col-span-6">
                            <label for="transaction_amount" class="form-label font-semibold">
                                Transaction Amount (₹) <span class="text-red-500">*</span>
                            </label>
                            <input type="number" min="0" step="0.01" name="transaction_amount"
                                id="transaction_amount" class="input w-full border mt-2"
                                placeholder="Enter amount" required>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-amount"></div>
                        </div>

                        <div class="col-span-12 md:col-span-6">
                            <label for="transaction_date" class="form-label font-semibold">
                                Transaction Date <span class="text-red-500">*</span>
                            </label>
                            <input type="date" name="transaction_date" id="transaction_date"
                                class="input w-full border mt-2" min="<?php echo e($minDate); ?>" max="<?php echo e($maxDate); ?>"
                                value="<?php echo e(old('transaction_date', now()->toDateString())); ?>"
                                onfocus="this.showPicker()" required>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-date"></div>
                        </div>

                        <div class="col-span-12 md:col-span-6">
                            <label for="money_receipt_no" class="form-label font-semibold">Money Receipt
                                No.</label>
                            <input type="text" name="money_receipt_no" id="money_receipt_no"
                                class="input w-full border mt-2" placeholder="Enter receipt number">
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-receipt"></div>
                        </div>

                        <div class="col-span-12 md:col-span-6">
                            <label for="transaction_reference" class="form-label font-semibold">Transaction
                                Reference</label>
                            <input type="text" name="transaction_reference" id="transaction_reference"
                                class="input w-full border mt-2" placeholder="Enter reference (optional)">
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-reference"></div>
                        </div>

                        <div class="col-span-12">
                            <label for="transaction_narration"
                                class="form-label font-semibold">Narration</label>
                            <textarea name="transaction_narration" id="transaction_narration" class="input w-full border mt-2"
                                rows="3" placeholder="Add notes for this transaction (optional)"><?php echo e(old('transaction_narration')); ?></textarea>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-narration"></div>
                        </div>

                        <div class="col-span-12">
                            <label for="files" class="form-label font-semibold">Upload Files</label>
                            <input type="file" name="files[]" id="files" class="input w-full border mt-2" style="background-color: #eee; margin-bottom: 5px;"
                                accept="image/*,application/pdf" multiple>
                            <small class="text-gray-500">You can upload multiple images or PDFs</small>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-files"></div>
                        </div>
                    </div>

                    <div class="flex flex-col sm:flex-row sm:justify-end gap-3 mt-8">
                        <button type="reset"
                            class="px-4 py-2 rounded bg-gray-500 hover:bg-gray-600 text-white shadow">
                            Reset
                        </button>
                        <button type="submit" id="submitTransactionForm"
                            class="button px-4 py-2 bg-theme-1 text-white">
                            <span class="submit-text">Save Transaction</span>
                            <span class="loading-text" style="display: none;">
                                <i class="fa fa-spinner fa-spin"></i> Saving...
                            </span>
                        </button>
                    </div>
                </form>

                <!-- Income Tab Panel (empty, form is shared) -->
                <div id="income-panel" class="tab-panel active"></div>

                <!-- Expense Tab Panel (empty, form is shared) -->
                <div id="expense-panel" class="tab-panel" style="display: none;"></div>

                <!-- Contra Tab -->
                <div id="contra-panel" class="tab-panel" style="display: none;">
                    <div class="text-center py-8">
                        <a href="<?php echo e(route('transactions.contra.create')); ?>"
                            class="inline-block px-6 py-3 bg-theme-1 text-white rounded-lg hover:bg-theme-1-dark shadow-md transition">
                            <i class="w-4 h-4 mr-2 inline-block">🔄</i> Go to Contra Entry Screen
                        </a>
                        <p class="mt-4 text-gray-600">Click the button above to access the contra transaction entry form.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->make('utils.alert', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <style>
        .tab-panel {
            display: none;
        }

        .tab-panel.active {
            display: block;
        }

        #transactionTabs button {
            transition: all 0.3s ease;
        }

        #transactionTabs button.active {
            border-color: #3b82f6;
            color: #3b82f6;
        }

        #transactionTabs button:not(.active) {
            border-color: transparent;
            color: #6b7280;
        }

        #transactionTabs button:hover:not(.active) {
            border-color: #d1d5db;
            color: #374151;
        }

        #vendorStaffOptions {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        #vendorStaffOptions li {
            border-bottom: 1px solid #e5e7eb;
        }

        #vendorStaffOptions li:last-child {
            border-bottom: none;
        }

        #vendorStaffOptions li:hover {
            background-color: #f3f4f6;
        }
    </style>
  
    <script>
        $(document).ready(function() {
            let searchTimeout;
            let currentPayToType = 'vendor';

            // Tab switching
            $('#transactionTabs button').on('click', function() {
                const tabName = $(this).data('tab');

                // Update tab buttons
                $('#transactionTabs button').removeClass('active').addClass('border-transparent');
                $(this).addClass('active').removeClass('border-transparent');

                // Update transaction type
                $('#transaction_type').val(tabName);

                // Update panels
                $('.tab-panel').removeClass('active').hide();
                $('#' + tabName + '-panel').addClass('active').show();

                // Show/hide Pay To section based on tab
                if (tabName === 'expense') {
                    $('#payToSection').show();
                    // Don't show select container by default - only when radio is selected
                    $('#vendorStaffSelectContainer').hide();
                    $('#billAmountContainer').hide();
                } else {
                    $('#payToSection').hide();
                    $('#vendorStaffSelectContainer').hide();
                    $('#billAmountContainer').hide();
                    $('#vendor_staff_search').val('');
                    $('#vendor_staff_id').val('');
                    $('#bill_amount').val('');
                    // Clear radio button selections
                    $('input[name="pay_to"]').prop('checked', false);
                }

                // Update submit button text
                const submitText = tabName === 'expense' ? 'Save Expense' : 'Save Income';
                $('#submitTransactionForm .submit-text').text(submitText);
            });

            // Handle Pay To radio button changes
            $('input[name="pay_to"]').on('change', function() {
                currentPayToType = $(this).val();
                // Show select container when radio button is selected
                $('#vendorStaffSelectContainer').show();

                // Show/hide Bill Amount field based on selection
                if (currentPayToType === 'external') {
                    // Vendor selected - show bill amount field
                    $('#billAmountContainer').show();
                    $('#vendor_staff_search').attr('placeholder', 'Type to search vendor name...');
                } else {
                    // Staff selected - hide bill amount field
                    $('#billAmountContainer').hide();
                    $('#bill_amount').val('');
                    $('#vendor_staff_search').attr('placeholder', 'Type to search staff name...');
                }

                // Clear previous selection when switching
                $('#vendor_staff_search').val('');
                $('#vendor_staff_id').val('');
                $('#vendorStaffOptions').addClass('hidden');
                $('#vendor_staff_search').focus();
            });

            // Handle Clear button click
            $('#clearPayToBtn').on('click', function() {
                // Uncheck all radio buttons
                $('input[name="pay_to"]').prop('checked', false);
                // Hide select container
                $('#vendorStaffSelectContainer').hide();
                // Hide bill amount field
                $('#billAmountContainer').hide();
                $('#bill_amount').val('');
                // Clear search and hidden field
                $('#vendor_staff_search').val('');
                $('#vendor_staff_id').val('');
                $('#vendorStaffOptions').addClass('hidden').empty();
                // Clear error messages
                $('#error-vendor-staff').text('');
                $('#error-bill-amount').text('');
            });

            // Searchable select for Vendor/Staff
            $('#vendor_staff_search').on('input', function() {
                const search = $(this).val().trim();
                const $optionsBox = $('#vendorStaffOptions');
                const $hiddenField = $('#vendor_staff_id');

                // Clear previous timeout
                clearTimeout(searchTimeout);

                if (search.length === 0) {
                    $optionsBox.addClass('hidden').empty();
                    $hiddenField.val('');
                    return;
                }

                // Debounce search
                searchTimeout = setTimeout(function() {
                    const type = currentPayToType; // 'vendor' or 'staff'

                    $.ajax({
                        url: '<?php echo e(route('vendor.search')); ?>',
                        method: 'GET',
                        data: {
                            search: search,
                            type: type
                        },
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(response) {
                            if (response.success && response.data.length > 0) {
                                $optionsBox.empty().removeClass('hidden');

                                response.data.forEach(function(item) {
                                    const $li = $('<li>')
                                        .text(item.vendor_name)
                                        .attr('data-id', item.vendor_id)
                                        .addClass('px-3 py-2 hover:bg-gray-100 cursor-pointer')
                                        .on('click', function() {
                                            $('#vendor_staff_search').val(item.vendor_name);
                                            $hiddenField.val(item.vendor_id);
                                            $optionsBox.addClass('hidden');
                                            $('#error-vendor-staff').text('');
                                        });
                                    $optionsBox.append($li);
                                });
                            } else {
                                $optionsBox.addClass('hidden').empty();
                            }
                        },
                        error: function() {
                            $optionsBox.addClass('hidden').empty();
                        }
                    });
                }, 300);
            });

            // Hide options when clicking outside
            $(document).on('click', function(e) {
                if (!$(e.target).closest('#vendorStaffSelectContainer').length) {
                    $('#vendorStaffOptions').addClass('hidden');
                }
                if (!$(e.target).closest('#assetSection').length) {
                    $('#assetOptions').addClass('hidden');
                }
            });

            // Check head group when head_id changes
            $('#head_id').on('change', function() {
                const headId = $(this).val();
                const $assetSection = $('#assetSection');
                const $assetId = $('#asset_id');
                const $assetSearch = $('#asset_search');

                // Hide asset section by default
                $assetSection.hide();
                $assetId.val('');
                $assetSearch.val('');
                $('#error-asset').text('');

                if (!headId) {
                    return;
                }

                // Fetch head group info
                $.ajax({
                    url: '<?php echo e(route('transactions.head-group-info')); ?>',
                    method: 'GET',
                    data: {
                        head_id: headId
                    },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.success && response.is_assets_group) {
                            // Show asset section if head group is assets
                            $assetSection.show();
                            $('#asset_id').prop('required', true);
                        } else {
                            // Hide asset section
                            $assetSection.hide();
                            $('#asset_id').prop('required', false);
                        }
                    },
                    error: function() {
                        $assetSection.hide();
                        $('#asset_id').prop('required', false);
                    }
                });
            });

            // Asset search functionality
            $('#asset_search').on('input', function() {
                const search = $(this).val().toLowerCase().trim();
                const $optionsBox = $('#assetOptions');
                const $hiddenField = $('#asset_id');

                if (search.length === 0) {
                    $optionsBox.addClass('hidden');
                    return;
                }

                // Filter assets
                $optionsBox.find('li').each(function() {
                    const assetName = $(this).text().toLowerCase();
                    if (assetName.includes(search)) {
                        $(this).show();
                    } else {
                        $(this).hide();
                    }
                });

                // Show options box if there are visible items
                if ($optionsBox.find('li:visible').length > 0) {
                    $optionsBox.removeClass('hidden');
                } else {
                    $optionsBox.addClass('hidden');
                }
            });

            // Handle asset selection
            $(document).on('click', '#assetOptions li', function() {
                const assetId = $(this).data('id');
                const assetName = $(this).text();
                $('#asset_search').val(assetName);
                $('#asset_id').val(assetId);
                $('#assetOptions').addClass('hidden');
                $('#error-asset').text('');
            });

            // Load account types when organisation changes
            $('#organisation_id').on('change', function() {
                const orgId = $(this).val();
                loadAccountTypes(orgId, '#account_type_id');
            });

            // Load account types on page load if organisation is selected
            if ($('#organisation_id').val()) {
                $('#organisation_id').trigger('change');
            }

            // Function to load account types
            function loadAccountTypes(orgId, selectId) {
                if (!orgId) {
                    $(selectId).html('<option value="">-- Select Division --</option>');
                    return;
                }

                $.ajax({
                    url: '<?php echo e(route('account-types.get-by-org')); ?>',
                    method: 'GET',
                    data: {
                        organisation_id: orgId
                    },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        let options = '<option value="">-- Select Division --</option>';
                        if (response.data && response.data.length > 0) {
                            response.data.forEach(function(type) {
                                options +=
                                    `<option value="${type.account_type_id}">${type.account_type_Name}</option>`;
                            });
                        }
                        $(selectId).html(options);
                    },
                    error: function() {
                        $(selectId).html('<option value="">-- Select Division --</option>');
                    }
                });
            }



            // Form submission
            $('#transactionForm').on('submit', function(e) {
                e.preventDefault();
                submitForm($(this), '#submitTransactionForm');
            });

            function submitForm($form, submitBtnId) {
                const $submitBtn = $(submitBtnId);
                const $submitText = $submitBtn.find('.submit-text');
                const $loadingText = $submitBtn.find('.loading-text');
                const type = $('#transaction_type').val();

                // Disable submit button and show loading
                $submitBtn.prop('disabled', true);
                $submitText.hide();
                $loadingText.show();

                // Clear previous errors
                $form.find('.error-message').text('').hide();

                const formData = new FormData($form[0]);

                $.ajax({
                    url: $form.attr('action'),
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.success) {
                            if (typeof showAlert === 'function') {
                                showAlert('success', response.message ||
                                    `${type.charAt(0).toUpperCase() + type.slice(1)} transaction saved successfully.`
                                    );
                            } else {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Success!',
                                    text: response.message ||
                                        `${type.charAt(0).toUpperCase() + type.slice(1)} transaction saved successfully.`,
                                    timer: 2500,
                                    showConfirmButton: false
                                });
                            }

                            // Reset form
                            $form[0].reset();

                            // Reset Pay To section
                            $('#payToSection').hide();
                            $('#vendorStaffSelectContainer').hide();
                            $('#billAmountContainer').hide();
                            $('#vendor_staff_search').val('');
                            $('#vendor_staff_id').val('');
                            $('#bill_amount').val('');
                            $('input[name="pay_to"]').prop('checked', false);

                            // Reset Asset section
                            $('#assetSection').hide();
                            $('#asset_search').val('');
                            $('#asset_id').val('');
                            $('#asset_id').prop('required', false);

                            // Redirect or reload after delay
                            setTimeout(function() {
                                if (response.redirect) {
                                    window.location.href = response.redirect;
                                } else {
                                    window.location.reload();
                                }
                            }, 1500);
                        } else {
                            showError(response.message || 'An error occurred');
                            $submitBtn.prop('disabled', false);
                            $submitText.show();
                            $loadingText.hide();
                        }
                    },
                    error: function(xhr) {
                        let errorMessage = `Failed to save ${type} transaction. Please try again.`;

                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorMessage = xhr.responseJSON.message;
                        } else if (xhr.responseJSON && xhr.responseJSON.errors) {
                            // Handle validation errors
                            const errors = xhr.responseJSON.errors;
                            $.each(errors, function(key, value) {
                                const errorId = `#error-${key.replace(/_/g, '-')}`;
                                $(errorId).text(value[0]).show();
                            });
                            errorMessage = 'Please fix the validation errors above.';
                        }

                        showError(errorMessage);
                        $submitBtn.prop('disabled', false);
                        $submitText.show();
                        $loadingText.hide();
                    }
                });
            }

            function showError(message) {
                if (typeof showAlert === 'function') {
                    showAlert('error', message);
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: message,
                        timer: 3000,
                        showConfirmButton: false
                    });
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/download/public_html/resources/views/jounaltransactions/create.blade.php ENDPATH**/ ?>