<?php $__env->startSection('content'); ?>
    <!-- Main Content -->
    <div class="col-span-12 xxl:col-span-9 grid grid-cols-12 gap-6 px-4 sm:px-6 lg:px-8">
        <!-- Hero Welcome Section -->
        <div class="col-span-12 mt-6">
            <div class="relative overflow-hidden bg-gradient-to-br from-blue-600 via-indigo-600 to-purple-600 rounded-3xl shadow-2xl p-8 sm:p-4 lg:p-8">
                <!-- Decorative Background Elements -->
                <!-- <div class="absolute top-0 right-0 -mt-4 -mr-4 w-64 h-64 bg-blue-200 opacity-10 rounded-full blur-3xl"></div>
                <div class="absolute bottom-0 left-0 -mb-8 -ml-8 w-48 h-48 bg-white opacity-10 rounded-full blur-2xl"></div> -->
                
                <div class="relative z-10">
                    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-6">
                        <div class="flex-1">
                            <h1 class="text-3xl sm:text-4xl lg:text-5xl font-bold">
                                Welcome back, <span style="color: #93adfb;"><?php echo e(Auth::user()->name); ?></span>
                            </h1>
                            <p class="text-lg sm:text-xl mb-3">
                                Here's your financial overview for today
                            </p>
                            
                            <!-- Info Cards -->
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 mt-5">
                                <div class="bg-white/20 backdrop-blur-md rounded-2xl p-3 border border-white/30 transition-all duration-300 hover:bg-white/30 hover:scale-105">
                                    <div class="flex items-center gap-0 mb-2">
                                        <div class="bg-white/30 p-2 rounded-lg">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                            </svg>
                                        </div>
                                        <h4 class="text-xs sm:text-sm uppercase tracking-wider font-semibold text-gray-600">Current Year</h4>
                                    </div>
                                    <p class="text-xl sm:text-2xl font-bold">
                                        <?php echo e(\App\Models\AccountingYear::current()->accounting_year_financial ?? 'No Selected'); ?>

                                    </p>
                                </div>
                                
                                <div class="bg-white/20 backdrop-blur-md rounded-2xl p-3 border border-white/30 transition-all duration-300 hover:bg-white/30 hover:scale-105">
                                    <div class="flex items-center gap-0 mb-2">
                                        <div class="bg-white/30 p-2 rounded-lg">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                            </svg>
                                        </div>
                                        <h4 class="text-xs sm:text-sm text-gray-600 uppercase tracking-wider font-semibold">Current Organisation</h4>
                                    </div>
                                    <p class="text-xl sm:text-2xl font-bold">
                                        <?php echo e(\App\Models\Organisation::current()->organisation_name ?? 'No Selected'); ?>

                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Financial Summary Cards -->
        <div class="col-span-12 grid grid-cols-1 md:grid-cols-3 gap-6 mt-6">
            <!-- Cash in Hand Card -->
            <div class="group relative overflow-hidden bg-gradient-to-br from-green-50 to-emerald-50 rounded-2xl shadow-lg border border-green-100 hover:shadow-2xl transition-all duration-300 hover:-translate-y-1">
                <div class="absolute top-0 right-0 w-32 h-32 bg-green-200 opacity-20 rounded-full -mr-16 -mt-16"></div>
                <div class="relative p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="bg-gradient-to-br from-green-500 to-emerald-600 p-3 rounded-xl shadow-lg">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z" />
                            </svg>
                        </div>
                        <span class="px-3 py-1 bg-green-100 text-green-700 text-xs font-semibold rounded-full">Liquid</span>
                    </div>
                    <h5 class="text-gray-600 text-sm font-medium uppercase tracking-wide mb-2">Cash in Hand</h5>
                    <h2 class="text-3xl font-bold text-gray-900 mb-1">
                        ₹ <?php echo e(number_format($yearWise_totalBanance['total_cash_in_hand'] ?? 0, 2)); ?>

                    </h2>
                    <p class="text-xs text-gray-500 mt-2">Available immediately</p>
                </div>
            </div>

            <!-- Cash at Bank Card -->
            <div class="group relative overflow-hidden bg-gradient-to-br from-blue-50 to-cyan-50 rounded-2xl shadow-lg border border-blue-100 hover:shadow-2xl transition-all duration-300 hover:-translate-y-1">
                <div class="absolute top-0 right-0 w-32 h-32 bg-blue-200 opacity-20 rounded-full -mr-16 -mt-16"></div>
                <div class="relative p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="bg-gradient-to-br from-blue-500 to-cyan-600 p-3 rounded-xl shadow-lg">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
                            </svg>
                        </div>
                        <span class="px-3 py-1 bg-blue-100 text-blue-700 text-xs font-semibold rounded-full">Bank</span>
                    </div>
                    <h5 class="text-gray-600 text-sm font-medium uppercase tracking-wide mb-2">Cash at Bank</h5>
                    <h2 class="text-3xl font-bold text-gray-900 mb-1">
                        ₹ <?php echo e(number_format($yearWise_totalBanance['total_cash_at_bank'] ?? 0, 2)); ?>

                    </h2>
                    <p class="text-xs text-gray-500 mt-2">In bank accounts</p>
                </div>
            </div>

            <!-- Net Assets Card -->
            <div class="group relative overflow-hidden bg-gradient-to-br from-purple-50 to-pink-50 rounded-2xl shadow-lg border border-purple-100 hover:shadow-2xl transition-all duration-300 hover:-translate-y-1">
                <div class="absolute top-0 right-0 w-32 h-32 bg-purple-200 opacity-20 rounded-full -mr-16 -mt-16"></div>
                <div class="relative p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="bg-gradient-to-br from-purple-500 to-pink-600 p-3 rounded-xl shadow-lg">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                            </svg>
                        </div>
                        <span class="px-3 py-1 bg-purple-100 text-purple-700 text-xs font-semibold rounded-full">Total</span>
                    </div>
                    <h5 class="text-gray-600 text-sm font-medium uppercase tracking-wide mb-2">Net Assets</h5>
                    <h2 class="text-3xl font-bold text-gray-900 mb-1">
                        ₹ <?php echo e(number_format($netAssets['net_asset'] ?? 0, 2)); ?>

                    </h2>
                    <p class="text-xs text-gray-500 mt-2">Total net worth</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Sidebar Section -->
    <div class="col-span-12 xxl:col-span-3 xxl:border-l border-gray-200 -mb-10 pb-10">
        <div class="xxl:pl-6 grid grid-cols-12 gap-6" style="padding-top: 30px;">
            <!-- Quick Stats Card -->
            <div class="col-span-12 sm:col-span-6 xxl:col-span-12">
                <div class="bg-gradient-to-br from-gray-50 to-gray-100 rounded-2xl p-6 border border-gray-200 shadow-lg">
                    <h3 class="text-lg font-bold text-gray-800 mb-4 flex items-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-indigo-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                        </svg>
                        Quick Summary
                    </h3>
                    
                    <div class="space-y-4">
                        <!-- Total Cash -->
                        <div class="bg-white rounded-xl p-4 border border-gray-200">
                            <div class="flex items-center justify-between mb-2">
                                <span class="text-sm text-gray-600 font-medium">Total Cash</span>
                                <div class="bg-green-100 p-1.5 rounded-lg">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-green-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>
                            </div>
                            <p class="text-xl font-bold text-gray-900">
                                ₹ <?php echo e(number_format(($yearWise_totalBanance['total_cash_in_hand'] ?? 0) + ($yearWise_totalBanance['total_cash_at_bank'] ?? 0), 2)); ?>

                            </p>
                        </div>

                        <!-- Net Assets -->
                        <div class="bg-white rounded-xl p-4 border border-gray-200">
                            <div class="flex items-center justify-between mb-2">
                                <span class="text-sm text-gray-600 font-medium">Net Assets</span>
                                <div class="bg-purple-100 p-1.5 rounded-lg">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-purple-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6" />
                                    </svg>
                                </div>
                            </div>
                            <p class="text-xl font-bold text-gray-900">
                                ₹ <?php echo e(number_format($netAssets['net_asset'] ?? 0, 2)); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Custom Styles -->
    <style>
        .animate-wave {
            display: inline-block;
            animation: wave 1.5s ease-in-out infinite;
        }

        @keyframes wave {
            0%, 100% {
                transform: rotate(0deg);
            }
            25% {
                transform: rotate(-15deg);
            }
            75% {
                transform: rotate(15deg);
            }
        }

        /* Smooth transitions for all interactive elements */
        * {
            transition-property: transform, box-shadow, background-color;
            transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/download/public_html/resources/views/dashboard.blade.php ENDPATH**/ ?>