<!DOCTYPE html>
<html lang="en" class="light">
<!-- BEGIN: Head -->

<head>
    <meta charset="utf-8">
    <link href="<?php echo e(asset('build/assets/dist/images/logo.svg')); ?>" rel="shortcut icon">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description"
        content="Midone admin is super flexible, powerful, clean & modern responsive tailwind admin template with unlimited possibilities.">
    <meta name="keywords"
        content="admin template, Midone admin template, dashboard template, flat admin template, responsive admin template, web app">
    <meta name="author" content="LEFT4CODE">
    <title>Login - Midone - Tailwind HTML Admin Template</title>
    <!-- BEGIN: CSS Assets-->
    <link rel="stylesheet" href="<?php echo e(asset('build/assets/dist/css/app.css')); ?> " />
    <!-- END: CSS Assets-->
<style>

.login{min-height: 100vh; display: flex;justify-content: center;align-items: center;}
.login .container {padding: 50px 0;}
.login-form-box {display: flex;justify-content: center;align-items: center;}
.login-form-box {display: flex;justify-content: center;align-items: center;}
.login .login-img img{max-width: 180px;}
.login .password-box {position: relative;}
.login .password-box input[type="password"]{padding-right: 40px;}
.login .password-box span {position: absolute;bottom: 16px;z-index: 99;right: 8px;}





</style>

</head>
<!-- END: Head -->

<body class="login">
    <div class="container">
        <div class="block xl:grid grid-cols-2 gap-4">
            <!-- BEGIN: Login Info -->
            <div class="hidden xl:flex flex-col">
                <div class="my-auto login-img">
                    <img alt="Midone Tailwind HTML Admin Template" class="-intro-x w-1/2 -mt-16"
                        src="<?php echo e(asset('build/assets/dist/images/srks_logo.svg')); ?>">
                        
                    <div class="-intro-x text-white font-medium text-4xl leading-tight mt-10">
                        A few more clicks to
                        <br>
                        sign in to your account.
                    </div>
                    <div class="-intro-x mt-5 text-lg text-white dark:text-gray-500">Manage all your e-commerce accounts
                        in one place</div>
                </div>
            </div>
            <!-- END: Login Info -->
            <!-- BEGIN: Login Form -->
            <div class="login-form-box">
            <form method="POST" action="<?php echo e(route('login')); ?>">
                <?php echo csrf_field(); ?>

                <div class="h-screen xl:h-auto flex py-5 xl:py-0 my-10 xl:my-0">

                    <div
                        class="my-auto mx-auto xl:ml-20 bg-white xl:bg-transparent px-5 sm:px-8 py-8 xl:p-0 rounded-md shadow-md xl:shadow-none w-full sm:w-3/4 lg:w-2/4 xl:w-auto">
                        <h2 class="intro-x font-bold text-2xl xl:text-3xl text-center xl:text-left">
                            Sign In
                        </h2>
                        <div class="intro-x mt-2 text-gray-500 xl:hidden text-center">A few more clicks to sign in to
                            your account. Manage all your e-commerce accounts in one place</div>
                        <?php if(session('error')): ?>
                            <div
                                class="rounded-md flex items-center px-5 py-4 mb-2 border border-theme-6 text-theme-6 dark:border-theme-6">
                                <?php echo e(session('error')); ?>

                            </div>
                        <?php endif; ?>
                        <div class="intro-x mt-8">
                            <input type="email"
                                class="intro-x login__input input input--lg border border-gray-300 block"
                                placeholder="Email" name="email" id="email">
                                <div class="password-box">
                            <input type="password"
                                class="intro-x login__input input input--lg border border-gray-300 block mt-4"
                                placeholder="Password" name="password" id="password">

                            <span class="action-link text-primary font-weight-bold text-xs" data-action="show-password"
                                data-toggle="tooltip" data-original-title="Show Password">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5"
                                    stroke-linecap="round" stroke-linejoin="round"
                                    class="feather feather-eye w-4 h-4 mr-1">
                                    <path d="M1 12s4-7 11-7 11 7 11 7-4 7-11 7-11-7-11-7z"></path>
                                    <circle cx="12" cy="12" r="3"></circle>
                                </svg>

                            </span>
                            </div>
                        </div>

                        <div class="intro-x mt-5 xl:mt-8 text-center xl:text-left">
                            <button
                                class="button button--lg w-full xl:w-32 text-white bg-theme-1 xl:mr-3 align-top">Login</button>

                        </div>

                    </div>
                </div>

            </form>
            </div>

            <!-- END: Login Form -->
        </div>
    </div>

    <!-- BEGIN: JS Assets-->
    <script src="<?php echo e(asset('build/assets/dist/js/app.js')); ?>"></script>
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $(document).on("click", "[data-action='show-password']", function(e) {
                e.preventDefault();

                var $iconWrapper = $(this);
                var $passwordInput = $("#password");
                var $svg = $iconWrapper.find("svg");
                var isPassword = $passwordInput.attr("type") === "password";
                $passwordInput.attr("type", isPassword ? "text" : "password");

                if (isPassword) {
                    $svg.replaceWith(`
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5"
                    stroke-linecap="round" stroke-linejoin="round"
                    class="feather feather-eye-off w-4 h-4 mr-1">
                    <path d="M17.94 17.94A10.07 10.07 0 0 1 12 19c-7 0-11-7-11-7
                             a18.45 18.45 0 0 1 5.06-5.94M9.88 9.88A3 3 0 0 0 
                             12 15a3 3 0 0 0 2.12-5.12M1 1l22 22"></path>
                </svg>
            `);
                    $iconWrapper.attr("data-original-title", "Hide Password").tooltip("dispose").tooltip();
                } else {
                    $svg.replaceWith(`
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5"
                    stroke-linecap="round" stroke-linejoin="round"
                    class="feather feather-eye w-4 h-4 mr-1">
                    <path d="M1 12s4-7 11-7 11 7 11 7-4 7-11 7-11-7-11-7z"></path>
                    <circle cx="12" cy="12" r="3"></circle>
                </svg>
            `);
                    $iconWrapper.attr("data-original-title", "Show Password").tooltip("dispose").tooltip();
                }
            });
        });
    </script>

    <!-- END: JS Assets-->
</body>

</html>
<?php /**PATH /var/www/html/ramakrishna-sevashram/resources/views/login.blade.php ENDPATH**/ ?>