<?php $__env->startSection('content'); ?>
    <div class="intro-y col-span-12 lg:col-span-12">

        <!-- BEGIN: Select Options -->
        <div class="intro-y box mt-5" style="padding: 20px 20px 20px 30px;">
            <h2 class="text-xl font-bold mb-6">Add Asset Brought Forward</h2>
            <?php
                $currentOrg = \App\Models\Organisation::current();
                $orgId = $currentOrg ? $currentOrg->organisation_id : null;
            ?>

            <?php if($errors->any()): ?>
                <div class="rounded-md flex items-center px-5 py-4 mb-4 border border-theme-6 text-theme-6">
                    <ul class="list-disc list-inside">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form id="assetBroughtForwardForm" action="<?php echo e(route('asset.brought.forward.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <div class="mt-3">
                            <input type="hidden" name="organisation_id" value="<?php echo e($orgId ?? ''); ?>">
                            <label>Organisation <span style="color: red">*</span></label>
                            <select id="organisation_id" class="input w-full border mt-2" disabled>
                                <option value="">-- Select Organisation --</option>
                                <?php
                                    $organisations = \App\Models\Organisation::where('status', 'active')->get();
                                ?>
                                <?php $__currentLoopData = $organisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organisation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($organisation->organisation_id); ?>"
                                        <?php echo e(old('organisation_id', $orgId) == $organisation->organisation_id ? 'selected' : ''); ?>>
                                        <?php echo e($organisation->organisation_name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if(!$orgId): ?>
                                <div class="text-red-500 text-sm mt-1">Please select a current organisation first.</div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div>
                        <div class="mt-3">
                            <label>Accounting Year <span class="text-red-500">*</span></label>
                            <select id="accounting_year_id" name="accounting_year_id"
                                class="w-full border p-2 rounded mt-2 <?php $__errorArgs = ['accounting_year_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                required>
                                <option value="">-- Select Accounting Year --</option>
                                <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($year->accounting_year_id); ?>"
                                        <?php echo e(old('accounting_year_id') == $year->accounting_year_id ? 'selected' : ''); ?>>
                                        <?php echo e($year->accounting_year_financial); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['accounting_year_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-red-500 text-sm mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-accounting-year"></div>
                        </div>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <div class="mt-3">
                            <label>Total Asset Amount <span class="text-red-500">*</span></label>
                            <input type="text" id="total_asset_amount" name="total_asset_amount"
                                class="w-full border p-2 rounded mt-2 <?php $__errorArgs = ['total_asset_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                value="<?php echo e(old('total_asset_amount')); ?>" placeholder="Enter Total Asset Amount" required>
                            <?php $__errorArgs = ['total_asset_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-red-500 text-sm mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-total-amount"></div>
                        </div>
                    </div>
                    <div>
                        <div class="mt-3">
                            <label>Transaction Date <span class="text-red-500">*</span></label>
                            <input type="date" id="transaction_date" name="transaction_date"
                                class="w-full border p-2 rounded mt-2 <?php $__errorArgs = ['transaction_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                value="<?php echo e(old('transaction_date')); ?>" required>
                            <?php $__errorArgs = ['transaction_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-red-500 text-sm mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-transaction-date"></div>
                        </div>
                    </div>
                </div>

                <div class="mt-5">
                    <a href="<?php echo e(route('asset.brought.forward.index')); ?>"
                        class="px-4 py-2 rounded bg-gray-500 hover:bg-gray-600 text-white shadow text-sm mr-3">Cancel</a>
                    <button type="submit" id="save-btn" class="button w-24 bg-theme-1 text-white">Save</button>
                </div>
            </form>

        </div>
    </div>

    <script>
        $(document).ready(function() {
            // Format number input
            $('#total_asset_amount').on('input', function() {
                let val = this.value;
                val = val.replace(/[^0-9.]/g, "");
                let parts = val.split(".");
                if (parts.length > 2) {
                    val = parts[0] + "." + parts.slice(1).join("");
                }
                this.value = val;
            });

            $('#assetBroughtForwardForm').on('submit', function(e) {
                let form = $(this)[0];
                if (form.checkValidity()) {
                    $('#save-btn').prop('disabled', true).text('Submitting...');
                    return true;
                } else {
                    e.preventDefault();
                    form.reportValidity();
                    return false;
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravelproject\ramkrishna-sevashram-new\resources\views/assetBroughtForward/create.blade.php ENDPATH**/ ?>