<?php $__env->startSection('content'); ?>
    <div class="intro-y col-span-12 lg:col-span-12">

        <!-- BEGIN: Select Options -->
        <div class="intro-y box mt-5" style="padding: 20px 20px 20px 30px;">
            <h2 class="text-xl font-bold mb-6">Edit Asset Brought Forward</h2>
            <?php
                $orgId = \App\Models\Organisation::current()->organisation_id;
            ?>

            <form id="assetBroughtForwardForm"
                action="<?php echo e(route('asset.brought.forward.update', base64_encode($assetBroughtForward->id))); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <div class="mt-3">
                            <input type="hidden" name="organisation_id" value="<?php echo e($orgId); ?>">
                            <label>Organisation <span style="color: red">*</span></label>
                            <select id="organisation_id" class="input w-full border mt-2" disabled>
                                <option value="">-- Select Organisation --</option>
                                <?php
                                    $organisations = \App\Models\Organisation::where('status', 'active')->get();
                                ?>
                                <?php $__currentLoopData = $organisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organisation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($organisation->organisation_id); ?>"
                                        <?php echo e(old('organisation_id', $orgId) == $organisation->organisation_id ? 'selected' : ''); ?>>
                                        <?php echo e($organisation->organisation_name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <div>
                        <div class="mt-3">
                            <label>Accounting Year <span class="text-red-500">*</span></label>
                            <select id="accounting_year_id" name="accounting_year_id" class="w-full border p-2 rounded mt-2"
                                required>
                                <option value="">-- Select Accounting Year --</option>
                                <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($year->accounting_year_id); ?>"
                                        <?php echo e(old('accounting_year_id', $assetBroughtForward->financial_year_id) == $year->accounting_year_id ? 'selected' : ''); ?>>
                                        <?php echo e($year->accounting_year_financial); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-accounting-year"></div>
                        </div>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <div class="mt-3">
                            <label>Total Asset Amount <span class="text-red-500">*</span></label>
                            <input type="text" id="total_asset_amount" name="total_asset_amount"
                                class="w-full border p-2 rounded mt-2"
                                value="<?php echo e(old('total_asset_amount', $assetBroughtForward->total_asset_amount)); ?>"
                                placeholder="Enter Total Asset Amount" required>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-total-amount"></div>
                        </div>
                    </div>
                    <div>
                        <div class="mt-3">
                            <label>Transaction Date <span class="text-red-500">*</span></label>
                            <input type="date" id="transaction_date" name="transaction_date"
                                class="w-full border p-2 rounded mt-2"
                                value="<?php echo e(old('transaction_date', $assetBroughtForward->dated_as_on)); ?>" required>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-transaction-date"></div>
                        </div>
                    </div>
                </div>

                <div class="mt-5">
                    <a href="<?php echo e(route('asset.brought.forward.index')); ?>"
                        class="px-4 py-2 rounded bg-gray-500 hover:bg-gray-600 text-white shadow text-sm mr-3">Cancel</a>
                    <button type="button" id="save-btn" class="button w-24 bg-theme-1 text-white">Update</button>
                </div>
            </form>

        </div>
    </div>

    <script>
        $(document).ready(function() {
            // Format number input
            $('#total_asset_amount').on('input', function() {
                let val = this.value;
                val = val.replace(/[^0-9.]/g, "");
                let parts = val.split(".");
                if (parts.length > 2) {
                    val = parts[0] + "." + parts.slice(1).join("");
                }
                this.value = val;
            });

            $('#save-btn').on('click', function(e) {
                let form = $('#assetBroughtForwardForm')[0];
                if (form.checkValidity()) {
                    $(this).prop('disabled', true).text('Updating...');
                    form.submit();
                } else {
                    form.reportValidity();
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/download/public_html/resources/views/assetBroughtForward/edit.blade.php ENDPATH**/ ?>