<?php $__env->startSection('content'); ?>
    <div class="ledgers-page-sec col-span-12 lg:col-span-12">
        <div class="ledgers-page-wraper flex w-full bg-white shadow-md rounded-2xl overflow-hidden">

            <div class="w-full bg-white border-r pb-3">
                <h2 class="text-lg font-semibold p-4 border-b">Vendor Heads</h2>

                <?php if($vendorsWithRecords->isEmpty()): ?>
                    <p class="p-4 text-gray-500">No Vendor data found for this financial year.Please<a
                            href="<?php echo e(route('expense.create')); ?>" style="color: blue"> Add Data</a> from Expense
                        Screen.</p>
                <?php else: ?>
                    <?php $__currentLoopData = $vendorsWithRecords; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                     <?php
                            $vendoeSlug = \Illuminate\Support\Str::slug($vendor->vendor_name);
                        ?>
                        <ul id="tabMenu" class="income-head">
                            <li data-tab="tab1">
                                <a href="<?php echo e(route('ledger.vendor-details', ['vendor' => $vendoeSlug, 'id' => base64_encode($vendor->vendor_id)])); ?>">
                                    <?php echo e(ucfirst($vendor->vendor_name)); ?>

                                </a>
                            </li>
                            <li>
                                Total amount paid to Vendor - ₹ <?php echo e($vendor->transaction_amount); ?>

                                <span><a href="<?php echo e(route('ledger.vendor-details', ['vendor' => $vendoeSlug, 'id' => base64_encode($vendor->vendor_id)])); ?>"
                                        class="edit-btn"> View Details </a></span>
                            </li>
                        </ul>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>

        </div>
        <div class="mt-6">
            <button onclick="history.back()"
                class="px-4 py-2 rounded-lg bg-gray-500 hover:bg-gray-600 text-white shadow text-sm transition">
                ← Back
            </button>
        </div>

        <script>
            const tabs = document.querySelectorAll("#tabMenu li");
            const contents = document.querySelectorAll(".tab-content");

            function activateTab(tab) {
                // reset all
                tabs.forEach(el => el.classList.remove("border-blue-600", "bg-blue-50"));
                contents.forEach(c => c.classList.remove("active"));

                // activate clicked tab
                tab.classList.add("border-blue-600", "bg-blue-50");
                document.getElementById(tab.dataset.tab).classList.add("active");
            }

            // click handling
            tabs.forEach(tab => {
                tab.addEventListener("click", () => activateTab(tab));
            });
        </script>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravelproject\ramkrishna-sevashram-new\resources\views/ledgers/vendors.blade.php ENDPATH**/ ?>