<?php $__env->startSection('content'); ?>
    <div class="intro-y col-span-12 lg:col-span-12">

        <!-- BEGIN: Select Options -->
        <div class="intro-y box mt-5 income-head-top-sec">
            <h2 class="text-lg font-medium mr-auto">Liability Brought Forward</h2>
            <div class="w-full sm:w-auto flex mt-4 sm:mt-0">
                <a href="<?php echo e(route('liability.brought.forward.create')); ?>">
                    <button class="button text-white bg-theme-1 shadow-md">
                        Add Liability Brought Forward
                    </button>
                </a>
            </div>
        </div>
    </div>
    </div>
    <!-- BEGIN: HTML Table Data -->
    <div class="intro-y box p-5 mt-5">
        <div class="flex flex-col sm:flex-row sm:items-end xl:items-start">
            <form class="xl:flex w-full" id="tabulator-html-filter-form">
                <div class="sm:flex items-center justify-between w-full">
                    <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center gap-2 flex-wrap">
                            <label for="page-size" class="form-label mb-0">Data Per Page</label>
                            <select id="page-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                                <option value="10">10</option>
                                <option value="30">30</option>
                                <option value="50">50</option>
                                <option value="100">100</option>
                            </select>
                        </div>
                    </div>
                    &nbsp; &nbsp; &nbsp;
                    <div>
                        <input type="text" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border" id="search-string"
                            placeholder="Search...">
                    </div>

                </div>
            </form>
        </div>
        <div class="overflow-x-auto scrollbar-hidden">
            <div class="mt-5 table-report table-report--tabulator" id="liability-brought-forward-table"></div>
        </div>
    </div>
    <!-- END: HTML Table Data -->


    <script src="<?php echo e(asset('js/tabulator.min.js')); ?>"></script>
    <script>
        $(document).ready(function() {

            <?php if(session('success')): ?>
                Swal.fire({
                    icon: 'success',
                    title: 'Success!',
                    text: <?php echo json_encode(session('success'), 15, 512) ?>,
                    timer: 2500,
                    showConfirmButton: false
                });
            <?php endif; ?>

            <?php if(session('error')): ?>
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: <?php echo json_encode(session('error'), 15, 512) ?>,
                    timer: 2500,
                    showConfirmButton: false
                });
            <?php endif; ?>

        });
    </script>

    <?php echo $__env->make('utils.alert', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        });

        var table = new Tabulator("#liability-brought-forward-table", {
            ajaxURL: "<?php echo e(route('liability.brought.forward.details')); ?>",
            ajaxParams: function() {
                return {
                    _token: document.querySelector('meta[name="csrf-token"]').getAttribute("content"),
                    search: document.querySelector("#search-string").value,
                };
            },

            ajaxConfig: "POST",
            layout: "fitColumns",
            theme: "bootstrap5",
            paginationMode: "remote",
            pagination: true,
            paginationSize: 10,
            paginationSizeSelector: false,
            layout: "fitColumns",
            search: true,
            movableRows: true,
            movableColumns: true,

            // 🔹 Custom loader spinner
            ajaxLoaderLoading: `
                   <div style='display:inline-block; border:4px solid #333; border-radius:10px; background:#fff; font-weight:bold; font-size:16px; color:#000; padding:10px 20px;'>Loading Data</div>
                `,


            columnDefaults: {
                headerHozAlign: "left",
                tooltip: true,
            },
            columns: [{
                    formatter: "handle",
                    width: 40,
                    headerSort: false,
                    frozen: true,
                    hozAlign: "center",
                },
                {
                    title: "SL",
                    field: "id",
                    headerSort: true,
                },
                {
                    title: "Financial Year",
                    field: "financial_year.accounting_year_financial",
                    headerSort: true,
                    minWidth: 200
                },
                {
                    title: "Total Liability Amount",
                    field: "total_liability_amount",
                    headerSort: true,
                    minWidth: 200,
                    formatter: function(cell) {
                        let value = cell.getValue();
                        return value ? '₹ ' + parseFloat(value).toLocaleString('en-IN', {
                            minimumFractionDigits: 2,
                            maximumFractionDigits: 2
                        }) : '₹ 0.00';
                    }
                },
                {
                    title: "Dated As On",
                    field: "dated_as_on",
                    headerSort: true,
                    minWidth: 150,
                    formatter: function(cell) {
                        let value = cell.getValue();
                        if (value) {
                            let date = new Date(value);
                            return date.toLocaleDateString('en-GB');
                        }
                        return '';
                    }
                },
                {
                    title: "Action",
                    headerHozAlign: "center",
                    headerSort: false,
                    formatter: function(cell) {
                        let data = cell.getRow().getData();
                        let encodedId = btoa(data.id);
                        return `
                    <button class="edit-btn" data-id="${encodedId}" style="color: blue;"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="feather feather-check-square w-4 h-4 mr-1"><polyline points="9 11 12 14 22 4"></polyline><path d="M21 12v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11"></path>
                    </svg></button>
                    <button class="delete-btn" data-id="${encodedId}"style="color: red;"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2 w-4 h-4 mr-1">
                    <polyline points="3 6 5 6 21 6"></polyline>
                    <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                    <line x1="10" y1="11" x2="10" y2="17"></line>
                    <line x1="14" y1="11" x2="14" y2="17"></line>
                    </svg></button>
                `;
                    },
                    hozAlign: "center",
                    width: 180,
                },

            ],
            rowFormatter: function(row) {
                const data = row.getData();
                if (data.is_current === 1) {
                    row.getElement().style.backgroundColor = "lightblue";
                    row.getElement().style.color = "black";
                }
            },

            ajaxResponse: function(url, params, response) {
                return {
                    data: response.data,
                    last_page: response.last_page,
                    current_page: response.current_page,
                    total: response.total
                };
            },
        });

        $(document).on('click', '.edit-btn', function() {
            let encodedId = $(this).data('id');
            window.location.href = `/liability-brought-forward/edit/${encodedId}`;
        });

        $(document).on('click', '.delete-btn', function() {
            let encodedId = $(this).data('id');

            Swal.fire({
                title: "Are you sure?",
                text: "This record will be deleted!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, delete it!",
                cancelButtonText: "Cancel"
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: `/liability-brought-forward/delete/${encodedId}`,
                        type: 'POST',
                        data: {
                            _token: $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(response) {
                            Swal.fire("Deleted!",
                                "Liability Brought Forward deleted successfully.", "success"
                                );
                            table.replaceData();
                        },
                        error: function(xhr) {
                            Swal.fire("Error!", "An error occurred while deleting.", "error");
                        }
                    });
                }
            });
        });

        document.getElementById("page-size").addEventListener("change", function() {
            table.setPageSize(Number(this.value));
        });

        document.getElementById("search-string").addEventListener("input", function() {
            table.setData();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravelproject\ramkrishna-sevashram-new\resources\views/liabilityBroughtForward/index.blade.php ENDPATH**/ ?>