<?php $__env->startSection('content'); ?>
<script>
    var isError = false;
</script>
<?php // dd($organisations); ?>
<div class="intro-y col-span-12 lg:col-span-12">
    <div class="intro-y box mt-5" style=" padding: 20px 20px 30px 20px;">
        <div class="intro-y mt-5">

            <h2 class="text-xl font-bold mb-4">Add Members in Bulk </h2>
            <div class="mb-4">
                <a href="<?php echo e(route('donor.downloadSampleCSV')); ?>"
                    class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">
                    Download Sample CSV
                </a>
            </div>
            
            <form action="<?php echo e(route('donors.importCSV')); ?>" method="POST" enctype="multipart/form-data"
                id="bulk_cv_import">
                <?php echo csrf_field(); ?>
                <div class="preview">
                    <div class="intro-y col-span-12 lg:col-span-12">
                        <div class="intro-y">
                            <div class="p-5" id="input">
                                <div class="preview">
                                    <div class="w-full -ml-4 -mr-4 flex flex-wrap">
                                        <div class="w-6/12 px-4">
                                            <div class="mt-3">
                                                <label>Organisation <span style="color: red">*</span></label>
                                                <select id="organisation_id" name="organisation_id"
                                                    class="input w-full border mt-2 custm-drpdwn _required" required disabled>
                                                    <option value="">-- Select Organisation --</option>
                                                    <option value="<?php echo e($orgId); ?>"
                                                       selected>
                                                        <?php echo e($organisationsName); ?>

                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="w-6/12 px-4">
                                            <div class="mt-3" id="accountTypeWrapper">
                                                <label>Division</label>
                                                <select id="account_type_id" name="account_type_id"
                                                    class="input w-full border mt-2 custm-drpdwn">
                                                    <option value="">-- Select Division --</option>
                                                    <?php $__currentLoopData = $accountTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($aType['account_type_id']); ?>" <?php echo e(old('account_type_id') == $aType['account_type_id'] ?? 'selected'); ?>><?php echo e($aType['account_type_Name']); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>;
                                                </select>
                                            </div>
                                        </div>
                                        <div class="w-6/12 px-4">
                                            <div class="mt-3">
                                                <label>Select Member Type &nbsp; <span
                                                        style="color:red;">*</span></label>
                                                <select name="donor_type" class="w-full border mt-2 p-2 rounded _required"
                                                    required disabled>
                                                    <option value="members" selected>Members</option>
                                                    <option value="foreign_members">Family Members</option>
                                                    <option value="non_members">Non Members</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="w-6/12 px-4">
                                            <div class="mt-3">
                                                <label>Upload Csv File</label>
                                                <input type="file" class="w-full border mt-2 p-2 rounded _required"
                                                    name="csv_file" accept="" multiple required>
                                                <ul id="file-list" class="mt-2 text-sm text-gray-600 space-y-1">
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="sm:pl-5 mt-5">
                        <a href="<?php echo e(route('donor.index')); ?>"><span
                                class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600 mr-2">
                                ← Back
                            </span></a>
                        <button type="submit" id="import_csv_submit"
                            class="button w-24 bg-theme-1 text-white">Save</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<?php if(session('success')): ?>
<script>
    toastr.success(<?php echo json_encode(session('success'), 15, 512) ?>, "Success", toastrProperties);
</script>
<?php elseif(session('error')): ?>
<script>
    toastr.error(<?php echo json_encode(session('error'), 15, 512) ?>, "Error", toastrProperties);
</script>
<?php endif; ?>
<script src="<?php echo e(asset('js/skj-validations@v2.js')); ?>"></script>
<script src="<?php echo e(asset('js/members/addBulkMembers.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravelproject\ramkrishna-sevashram-new\resources\views/donor/bulkUploadForm.blade.php ENDPATH**/ ?>