<?php $__env->startSection('content'); ?>
    <div class="intro-y col-span-12 lg:col-span-12">

        <div class="intro-y box mt-5" style=" padding: 20px 20px 30px 20px;">
            <!-- BEGIN: Horizontal Form -->
            <div class="intro-y mt-5">
                <?php
                    $orgId = \App\Models\Organisation::current()->organisation_id;
                ?>

                <h2 class="text-xl font-bold mb-4">Add Member</h2>

                
                <?php if($errors->any()): ?>
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                        <ul class="list-disc pl-5">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form id="donorForm" action="<?php echo e(route('donor.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>

                    <div class="grid grid-cols-2 gap-4">
                        <div class="donorclass">
                            <label class="block text-gray-700">Organisation <span style="color: red">*</span></label>
                            <select id="organisation_id" name="organisation_id"
                                class="input w-full border mt-2 custm-drpdwn" disabled>
                                <option value="">-- Select Organisation --</option>
                                <?php $__currentLoopData = $organisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organisation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($organisation->organisation_id); ?>"
                                        <?php echo e(old('organisation_id', $orgId) == $organisation->organisation_id ? 'selected' : ''); ?>>
                                        <?php echo e($organisation->organisation_name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-organisation"></div>
                        </div>
                        <input type="hidden" value="<?php echo e($orgId); ?>" id="organisation_id" name="organisation_id">
                        <div class="donorclass">
                            <div id="accountTypeWrapper">
                                <label class="block text-gray-700">Division</label>
                                <select id="account_type_id" name="account_type_id"
                                    class="input w-full border mt-2 custm-drpdwn" disabled>
                                    <option value="">-- Select Division --</option>
                                </select>
                                <small id="accountTypeMsg" class="text-red-500" style="display:none;">
                                    Please select organisation first
                                </small>
                                <div class="text-red-500 text-sm mt-1 error-message" id="error-account-type"></div>
                            </div>
                        </div>
                        <div class="donorclass">
                            <label class="block text-gray-700">Donor Type <span class="text-red-500">*</span></label>
                            <select id="donor_type" name="donor_type" class="w-full border p-2 rounded">
                                <option value="">-- Select --</option>
                                <option value="members" <?php echo e(old('donor_type') == 'members' ? 'selected' : ''); ?>>Members
                                </option>
                                <option value="foreign_members"
                                    <?php echo e(old('donor_type') == 'foreign_members' ? 'selected' : ''); ?>>
                                    Family Members</option>
                                <option value="non_members" <?php echo e(old('donor_type') == 'non_members' ? 'selected' : ''); ?>>
                                    Non Members
                                </option>
                            </select>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-donor-type"></div>
                        </div>

                        <div class="donorclass">
                            <label class="block text-gray-700">Name <span class="text-red-500">*</span></label>
                            <input type="text" id="donor_name" name="donor_name" value="<?php echo e(old('donor_name')); ?>"
                                class="w-full border p-2 rounded">
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-donor-name"></div>
                        </div>
                        <div class="donorclass">
                            <label class="block text-gray-700">Donor Folio Number</label>
                            <input type="text" id="donor_folio_no" name="donor_folio_no"
                                value="<?php echo e(old('donor_folio_no')); ?>" class="w-full border p-2 rounded">
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-folio-no"></div>
                        </div>

                        <div class="donorclass">
                            <label class="block text-gray-700">Phone Number</label>
                            <input type="text" id="donor_phone_number" name="donor_phone_number"
                                value="<?php echo e(old('donor_phone_number')); ?>" class="w-full border p-2 rounded">
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-phone-number"></div>
                        </div>
                        <div class="donorclass">
                            <label class="block text-gray-700">Address</label>
                            <textarea id="donor_address" name="donor_address" class="w-full border p-2 rounded"><?php echo e(old('donor_address')); ?></textarea>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-address"></div>
                        </div>

                    </div>
                    <div class="sm:pl-5 mt-5 flex items-center space-x-3">
                        <a href="<?php echo e(route('donor.index')); ?>"
                            class="inline-flex items-center px-4 py-2 rounded bg-gray-500 hover:bg-gray-600 text-white">Cancel</a>
                        <button id="saveDonor" type="submit"
                            class="inline-flex items-center justify-center w-24 px-4 py-2 rounded bg-theme-1 text-white">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <?php if(session('success')): ?>
        <script>
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: "<?php echo e(session('success')); ?>",
                timer: 2000,
                showConfirmButton: false
            });
        </script>
    <?php endif; ?>
    <script>

        $("#donorForm").on("submit", function () {
            let $submitBtn = $("#saveDonor");

            $submitBtn.prop("disabled", true);  // disable button
            $submitBtn.text("Submitting..."); // update text
            submitBtn.classList.add('opacity-70', 'cursor-not-allowed');
            return true; // allow form to submit
        });

        const donorName = document.getElementById("donor_name");
        const errorEl = document.getElementById("error-donor-name");

        donorName.addEventListener("input", function() {
            this.value = this.value.replace(/[^A-Za-z\s]/g, '');
            if (this.value.length > 55) {
                this.value = this.value.slice(0, 55);
            }
            if (this.value === '') {
                errorEl.innerText = "Name should contain only letters and spaces.";
            } else {
                errorEl.innerText = "";
            }
        });
        const folioNo = document.getElementById("donor_folio_no");
        const folioError = document.getElementById("error-folio-no");

        folioNo.addEventListener("input", function() {
            let value = this.value.replace(/[^A-Za-z0-9]/g, '');
            if (value.length > 20) value = value.slice(0, 20);
            this.value = value;
            folioError.innerText = this.value === '' ? "Folio number cannot be empty." : "";
        });
        const phone = document.getElementById("donor_phone_number");
        const phoneError = document.getElementById("error-phone-number");

        phone.addEventListener("input", function() {
            this.value = this.value.replace(/[^0-9]/g, '');
            if (this.value.length > 10) this.value = this.value.slice(0, 10);
            phoneError.innerText = this.value === '' ? "Phone number cannot be empty." : "";
        });

        const address = document.getElementById("donor_address");
        const addressError = document.getElementById("error-address");

        address.addEventListener("input", function() {
            this.value = this.value.replace(/[^A-Za-z0-9\s,.-]/g, '');
            if (this.value.length > 100) this.value = this.value.slice(0, 100);
            addressError.innerText = this.value === '' ? "Address cannot be empty." : "";
        });

        document.getElementById("organisation_id").addEventListener("change", function() {
            document.getElementById("error-organisation").innerText = "";
        });
        document.getElementById("account_type_id").addEventListener("change", function() {
            document.getElementById("error-account-type").innerText = "";
        });
        document.getElementById("donor_type").addEventListener("change", function() {
            document.getElementById("error-donor-type").innerText = "";
        });
        document.getElementById("donor_name").addEventListener("input", function() {
            document.getElementById("error-donor-name").innerText = "";
        });


        //organisation and accountype checking start.
        let accountTypes = <?php echo json_encode($accountTypes, 15, 512) ?>;
        let orgSelect = document.getElementById('organisation_id');
        let accSelect = document.getElementById('account_type_id');
        let msg = document.getElementById('accountTypeMsg');



        let oldOrg = "<?php echo e(old('organisation_id', $orgId)); ?>";
        let oldAcc = "<?php echo e(old('account_type_id')); ?>";

        function populateAccountTypes(oldOrg) {
            accSelect.innerHTML = '<option value="">-- Select Division --</option>';

            if (oldOrg) {
                let filtered = accountTypes.filter(at => at.organisation_id == oldOrg);

                if (filtered.length > 0) {
                    document.getElementById("accountTypeWrapper").style.display = "block";
                    filtered.forEach(at => {
                        let option = document.createElement('option');
                        option.value = at.account_type_id;
                        option.textContent = at.account_type_Name;

                        if (oldAcc == at.account_type_id) {
                            option.selected = true;
                        }
                        accSelect.appendChild(option);
                    });

                    accSelect.disabled = false;
                    msg.style.display = "none";
                } else {
                    accSelect.disabled = true;
                    msg.textContent = "No Division found for this organisation.";
                    msg.style.display = "block";
                    document.getElementById("accountTypeWrapper").style.display = "none";
                }
            } else {
                accSelect.disabled = true;
                msg.textContent = "Please select organisation first.";
                msg.style.display = "block";
            }
        }

        orgSelect.addEventListener('change', function() {
            populateAccountTypes(this.value);
        });

        accSelect.addEventListener('focus', function() {
            if (!orgSelect.value) {
                msg.textContent = "Please select organisation first.";
                msg.style.display = "block";
                setTimeout(() => msg.style.display = "none", 2000);
            }
        });

        if (oldOrg) {
            populateAccountTypes(oldOrg);
        }
        //organisation and accountype checking end.
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravelproject\ramkrishna-sevashram-new\resources\views/auth/donor/create.blade.php ENDPATH**/ ?>