<?php $__env->startSection('content'); ?>
<div class="col-span-12 lg:col-span-12">
    <div class="flex justify-between mt-5">
        <h2 class="text-lg font-medium mr-auto">
            Members
        </h2>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('modify-menu', 54)): ?>
        <div class="w-full sm:w-auto flex mt-4 sm:mt-0 mr-4">
            <a href="<?php echo e(route('donor.create')); ?>">
                <button class="secondary">
                    Add Member
                </button>
            </a>
        </div>
        <div class="w-full sm:w-auto flex mt-4 sm:mt-0 mr-4">
            <a href="<?php echo e(route('donor.importForm')); ?>">
                <button class="secondary">
                    Add Bulk Member
                </button>
            </a>
        </div>
        <?php endif; ?>
        <div class="w-full sm:w-auto flex mt-4 sm:mt-0 mr-4">
            <a href="<?php echo e(route('donor.member.donation.list')); ?>">
                <button class="primary">
                    Members Yearly Record
                </button>
            </a>
        </div>
    </div>
</div>
</div>
<div class="intro-y box p-5 mt-5">

    <div class="flex flex-col sm:flex-row sm:items-end xl:items-start">
        <form class="xl:flex w-full" id="tabulator-html-filter-form">
            <div class="sm:flex items-end justify-between w-full gap-4">
                <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center gap-2 flex-wrap">
                        <label for="page-size" class="form-label mb-0">Data Per Page</label>
                        <select id="page-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                            
                            <option value="10">10</option>
                            <option value="30">30</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                        </select>
                    </div>
                </div>
                <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center flex-wrap">
                        <label for="org-size" class="form-label mb-0">Members as per Organisation:</label>
                        <select id="org-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                            <option value="">All Members</option>
                            <?php $__currentLoopData = $organisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organisation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($organisation->organisation_id); ?>">
                                <?php echo e($organisation->organisation_name); ?>

                            </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="ms-4 me-4 d-flex align-items-center justify-content-between" style="max-width: 300px;">
                    <div class="d-flex align-items-center flex-wrap">
                        <label for="org-size" class="form-label mb-0">Defaulter Members List</label>
                        <select id="defaulter_mem" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border"
                            name="amount_flag">
                            <option value="">--select--</option>
                            <option value="not_paid">Pending</option>
                            <option value="paid">Paid</option>
                        </select>
                    </div>
                </div>
                <div>
                    <input type="text" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border" id="search-string"
                        placeholder="Search...">
                </div>
            </div>
        </form>
    </div>
    <div class="overflow-x-auto scrollbar-hidden">
        <div class="mt-5 table-report table-report--tabulator" id="donor-table"></div>
    </div>
</div>

<?php if(session('success')): ?>
<script>
    toastr.success(<?php echo json_encode(session('success'), 15, 512) ?>, "Success", toastrProperties);
</script>
<?php elseif(session('error')): ?>
<script>
    toastr.error(<?php echo json_encode(session('error'), 15, 512) ?>, "Error", toastrProperties);
</script>
<?php endif; ?>

<link href="<?php echo e(asset('build/assets/css/tabulator.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('css/tabulator_materialize.min.css')); ?>" rel="stylesheet">
<script type="text/javascript" src="<?php echo e(asset('js/tabulator.min.js')); ?>"></script>
<script>
    const canAddDonation = <?php echo json_encode(Gate::allows('modify-menu', 54), 512) ?>;
    const getDonorRoute = "<?php echo e(route('donor.details')); ?>";
</script>
<script src="<?php echo e(asset('js/members/memberListing.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/ramakrishna-sevashram/resources/views/donor/index.blade.php ENDPATH**/ ?>