<?php

namespace App\Exports;

use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class FailedStudentsExport implements FromCollection, WithHeadings
{
    protected $uploadId;

    public function __construct($uploadId)
    {
        $this->uploadId = $uploadId;
    }

    public function collection()
    {
        return DB::table('student_bulk_failed')
            ->where('upload_id', $this->uploadId)
            ->select('row_number', 'data', 'reason')
            ->orderBy('row_number')
            ->get();
    }

    public function headings(): array
    {
        return [
            'Row Number',
            'Student',
            'Failure Reason'
        ];
    }
}


