<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;

class StudentTemplateExport implements FromArray, WithHeadings, WithEvents
{
    protected array $headers;
    protected array $example;

    public function __construct(array $headers, array $example)
    {
        $this->headers = $headers;
        $this->example = $example;
    }

    public function headings(): array
    {
        return $this->headers;
    }

    public function array(): array
    {
        return [$this->example];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {

                $sheet = $event->sheet->getDelegate();

                // ===== AUTO COLUMN WIDTH =====
                foreach (range(1, count($this->headers)) as $i) {
                    $sheet->getColumnDimension(
                        Coordinate::stringFromColumnIndex($i)
                    )->setAutoSize(true);
                }

                // (No dropdowns, no hidden sheets)
            }
        ];
    }
}
