<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StaffMonthlySalary extends Model
{
    protected $table = 'staff_month_of_salary';

    protected $fillable = [
        'staff_id','basic','hra','medical_allowance','conveyance',
        'washing_allowance','special_allowance','total_earnings',
        'pf','esi','p_tax','tds','advance','others_deduction',
        'total_deductions','net_salary','employer_pf','employer_esi',
        'ctc','pay_for_month','paid_date','financial_year_id'
    ];

    public function staff()
    {
        return $this->belongsTo(Staff::class);
    }

    public function financialYear()
    {
        return $this->belongsTo(AcademicYear::class, 'financial_year_id');
    }

}
