@extends('layouts.auth')

@section('title', 'Login')

@section('content')

    <!--  -->
    <div class="login-form-box">
        <form method="POST" action="{{ route('login.post') }}">
            @csrf
            <div class="h-screen xl:h-auto flex py-5 xl:py-0 my-10 xl:my-0">

                <div
                    class="my-auto mx-auto xl:ml-20 bg-white xl:bg-transparent px-5 sm:px-8 py-8 xl:p-0 rounded-md shadow-md xl:shadow-none w-full sm:w-3/4 lg:w-2/4 xl:w-auto">
                    <h2 class="intro-x font-bold text-2xl xl:text-3xl text-center xl:text-left">
                        Sign In
                    </h2>
                    <div class="intro-x mt-2 text-gray-500 xl:hidden text-center">A few more clicks to sign in to
                        your account. Manage all your e-commerce accounts in one place</div>
                    <div class="intro-x mt-8">
                        <input type="email" class="intro-x login__input input input--lg border border-gray-300 block"
                            placeholder="Email" name="email" id="email">
                        @error('email')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                        <div class="password-box">
                            <input type="password"
                                class="intro-x login__input input input--lg border border-gray-300 block mt-4"
                                placeholder="Password" name="password" id="password">

                            <span class="action-link text-primary font-weight-bold text-xs" data-action="show-password"
                                data-toggle="tooltip" data-original-title="Show Password">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"
                                    fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-eye w-4 h-4 mr-1">
                                    <path d="M1 12s4-7 11-7 11 7 11 7-4 7-11 7-11-7-11-7z"></path>
                                    <circle cx="12" cy="12" r="3"></circle>
                                </svg>

                            </span>
                            @error('password')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>

                    <div class="intro-x mt-5 xl:mt-8 text-center xl:text-left">
                        <button
                            class="button button--lg w-full xl:w-32 text-white bg-theme-1 xl:mr-3 align-top">Login</button>

                    </div>

                </div>
            </div>

        </form>
    </div>

@endsection
