@extends('layouts.app')

@section('title','Dashboard')

@section('breadcrumb')
<li class="breadcrumb-item active">Class Setup</li>
@endsection

@section('content')
    <div id="school-setup-page" class="page-content">

        <h1 class="mb-4">Class Setup</h1>

        <div class="row">
            <div class="col-md-8">
                {{-- Classes --}}
                <div class="card mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Classes & Sections</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('class.add') }}" method="POST" class="mb-3">
                            @csrf
                            <label class="form-label">Add New Class</label>
                            <div class="input-group">
                                <input type="text" name="class_name" class="form-control"
                                    placeholder="e.g., Class 5" required>
                                <button class="btn btn-outline-secondary" type="submit">Add Class</button>
                            </div>
                        </form>

                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Class Name</th>
                                    <th>Sections</th>
                                    <th>Total Students</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($classes as $class)
                                    <tr>
                                        <td>{{ $class->class_name }}</td>
                                        <td>
                                            @foreach ($class->sections as $sec)
                                                <span  class="badge bg-info section-delete-btn" 
                                                    data-id="{{ $sec->id }}" 
                                                    data-url="{{ route('section.delete', $sec->id) }}">
                                                    {{ $sec->section_name }}
                                                    <!-- <i class="fa fa-trash-o"></i> -->
                                                    <i class="bi bi-trash"></i>
                                                </span>
                                            @endforeach
                                        </td>
                                        <td>{{ $class->students->count() }}</td>
                                        <td>

                                            {{-- Add New Section --}}
                                            <button
                                                type="button"
                                                class="btn btn-sm btn-outline-secondary addSectionBtn"
                                                data-class-id="{{ $class->id }}">
                                                Add Section
                                            </button>


                                            <button class="btn btn-sm btn-outline-primary class-edit-btn"
                                                data-id="{{ $class->id }}"
                                                data-name="{{ $class->class_name }}"
                                                data-url="{{ route('class.update', $class->id) }}"
                                                title="Edit Class">
                                                <i class="bi bi-pencil"></i>
                                            </button>

                                            <button class="btn btn-sm btn-outline-danger class-delete-btn"
                                                data-id="{{ $class->id }}"
                                                data-url="{{ route('class.delete', $class->id) }}"
                                                title="Delete Class">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>

    </div>
@endsection

@section('modal')
    <!-- Section Add Modal -->
    <div class="modal fade" id="sectionModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                
                <div class="modal-header">
                    <h5 class="modal-title">Add Section</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <form id="sectionForm">

                        @csrf
                        <input type="hidden" name="class_id" id="section_class_id">
                        <div class="mb-3">
                            <label class="form-label">Section Name</label>
                            <input type="text" name="section_name" class="form-control" required>
                        </div>

                        <!-- <div class="mb-3">
                            <label class="form-label">Class</label>
                            <select name="class_id" class="form-control" required>
                                <option value="">Select Class</option>
                                @foreach ($classes as $class)
                                    <option value="{{ $class->id }}">{{ $class->class_name }}</option>
                                @endforeach
                            </select>
                        </div> -->
                        <button type="submit" id="sectionSubmitBtn"  class="btn btn-primary">Save</button>
                    </form>
                </div>

            </div>
        </div>
    </div>

    <!-- Edit Class Modal -->
    <div class="modal fade" id="editClassModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="editClassForm" action="">
                    @csrf 
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Class</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" id="edit_class_id" name="id">
                        <div class="mb-3">
                            <label>Class Name</label>
                            <input type="text" id="edit_class_name" name="class_name" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="updateClassBtn" class="btn btn-primary">
                            Update
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection

@section('script')
    <script>
        $(document).on('click', '.addSectionBtn', function () {

            let classId = $(this).data('class-id');

            // Set hidden input
            $('#section_class_id').val(classId);

            // Clear old errors / inputs
            $('#sectionForm')[0].reset();
            $('.invalid-feedback').text('');
            $('.form-control').removeClass('is-invalid');

            // Open modal programmatically
            let modal = new bootstrap.Modal(document.getElementById('sectionModal'));
            modal.show();
        });
    </script>

    <script>
        $(document).ready(function(){

            // DELETE CLASS
            $('.class-delete-btn').on('click', function (e) {
                e.preventDefault();

                let btn = $(this);
                let itemUrl = btn.data('url');
                let row = btn.closest('tr');

                Swal.fire({
                    title: "Are you sure?",
                    text: "This class will be deleted!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#e3342f",
                    cancelButtonColor: "#6c757d",
                    confirmButtonText: "Yes, delete it",
                    cancelButtonText: "Cancel",
                }).then((result) => {
                    if (result.isConfirmed) {

                        $.ajax({
                            type: "DELETE",
                            url: itemUrl,
                            data: {
                                _token: "{{ csrf_token() }}"
                            },
                            success: function (res) {
                                if (res.success) {
                                    row.remove();
                                    Swal.fire("Deleted!", "Class deleted successfully.", "success");
                                }
                            },
                            error: function (xhr) {
                                toastr.error(xhr.responseJSON.message);
                            }
                        });

                    }
                });
            });


            // DELETE SECTION
            $('.section-delete-btn').on('click', function(e){
                e.preventDefault();

                let badge = $(this);
                let itemUrl = badge.data('url');

                Swal.fire({
                    title: "Are you sure?",
                    text: "This section will be deleted!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#e3342f",
                    cancelButtonColor: "#6c757d",
                    confirmButtonText: "Yes, delete it",
                    cancelButtonText: "Cancel",
                }).then((result) => {
                    if (result.isConfirmed) {

                        $.ajax({
                            type: "DELETE",
                            url: itemUrl,
                            data: {
                                _token: "{{ csrf_token() }}"
                            },
                            success: function(res){
                                if(res.success){
                                    badge.remove();
                                    Swal.fire("Deleted!", "Section removed successfully.", "success");
                                }
                            },
                            error: function (xhr) {
                                toastr.error(xhr.responseJSON.message);
                            }
                        });

                    }
                });

            });

        });
    </script>

    <script>
        $(document).ready(function () {

            $('#sectionForm').on('submit', function (e) {
                e.preventDefault();

                let btn = $('#sectionSubmitBtn'); // button id

                // Disable button + show loading
                btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Saving...');

                $.ajax({
                    url: "{{ route('section.add') }}",
                    type: "POST",
                    data: $(this).serialize(),
                    success: function (res) {
                        Swal.fire("Success!", res.message, "success");
                        $('#sectionModal').modal('hide');
                        $('#sectionForm')[0].reset();
                        location.reload();
                    },
                    error: function (xhr) {
                        if (xhr.status === 422) {
                            let errors = xhr.responseJSON.errors;
                            let msg = "";

                            $.each(errors, function (key, value) {
                                msg += value + "<br>";
                            });

                            Swal.fire({
                                title: "Validation Error!",
                                html: msg,
                                icon: "error"
                            });
                        } else {
                            Swal.fire("Error!", "Something went wrong.", "error");
                        }
                    },
                    complete: function () {
                        // Re-enable button after AJAX
                        btn.prop('disabled', false).html('Save');
                    }
                });
            });

        });
    </script>
    <script>
        $(document).ready(function() {

            // OPEN MODAL AND LOAD DATA
            $('.class-edit-btn').on('click', function () {

                let id = $(this).data('id');
                let name = $(this).data('name');
                let url = $(this).data('url');

                // fill modal
                $('#edit_class_id').val(id);
                $('#edit_class_name').val(name);
                $('#editClassForm').attr('action',url);

                // open modal
                $('#editClassModal').modal('show');
            });



            // UPDATE FORM SUBMIT
            $('#editClassForm').on('submit', function (e) {
                e.preventDefault();

                let id = $('#edit_class_id').val();
                let url = $('#editClassForm').attr('action');

                let btn = $('#updateClassBtn');
                btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Updating...');

                $.ajax({
                    url: url,
                    type: "POST",
                    data: $(this).serialize(),
                    success: function (res) {
                        Swal.fire("Updated!", 'Class updated successfully', "success");
                        $('#editClassModal').modal('hide');
                        location.reload();
                    },
                    error: function (xhr) {
                        if (xhr.status === 422) {
                            let errors = xhr.responseJSON.errors;
                            let msg = "";

                            $.each(errors, function (k, v) {
                                msg += v + "<br>";
                            });

                            Swal.fire({
                                title: "Validation Error!",
                                html: msg,
                                icon: "error"
                            });
                        } else {
                            Swal.fire("Error!", "Something went wrong.", "error");
                        }
                    },
                    complete: function () {
                        btn.prop('disabled', false).html('Update');
                    }
                });
            });
        });
    </script>

@endsection
