<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>@yield('title', 'School Management')</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/switchery/0.8.2/switchery.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <link rel="stylesheet" href="{{ asset('css/styles.css') }}">

</head>

<body>
    <div class="d-flex" id="app">
        <!-- Sidebar -->
        <nav class="sidebar bg-dark text-white">
            @include('partials.sidebar')
        </nav>

        <div class="main-content flex-grow-1">
            @include('partials.navbar')

            <div class="breadcrumb-container bg-light border-bottom px-4 py-2">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        @yield('breadcrumb')
                    </ol>
                </nav>
            </div>

            <div class="content-area p-4">
                @if (session('success'))
                    <div id="alert" class="alert alert-success">{{ session('success') }}</div>
                @endif

                @if (session('error'))
                    <div id="alert" class="alert alert-danger">{{ session('error') }}</div>
                @endif

                @yield('content')

                @include('partials.footer')
            </div>
        </div>
    </div>
    @yield('modal')
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/switchery/0.8.2/switchery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <!-- Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <!-- <script src="{{ asset('js/script.js') }}"></script> -->

    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const alert = document.getElementById('alert');
            if (alert) {
                setTimeout(() => {
                    alert.classList.add('fade');
                    alert.classList.remove('show');
                    alert.style.display = 'none';
                }, 3000); // 2 seconds
            }
        });
        
    </script>
    <script>
        $(document).ready(function () {

            $('.select2').select2({
                allowClear: true,
                width: '100%'
            });

            // $('.select2').select2({
            //     dropdownParent: $('#editClassFeeModal'), // or your modal id
            //     width: '100%'
            // });


        });
    </script>
    <script>
            (function () {
                'use strict';

                const WORD_LIMIT = 25;
                const MAX_LENGTH = 100;
                const MAX_WORD_LENGTH = 250;
                const WARNING_TIME = 2000;

                /* -------------------- small toast -------------------- */
                function showWarning(el, msg) {
                    try {
                        if (!el) el = document.body;
                        if (el.dataset && el.dataset.warned) return;
                        if (el.dataset) el.dataset.warned = '1';

                        const warn = document.createElement('div');
                        warn.textContent = msg;
                        Object.assign(warn.style, {
                            position: 'fixed',
                            bottom: '20px',
                            right: '20px',
                            background: '#ff4d4d',
                            color: '#fff',
                            padding: '8px 12px',
                            borderRadius: '6px',
                            zIndex: 2147483647, // max to ensure visible
                            fontSize: '14px',
                            boxShadow: '0 2px 6px rgba(0,0,0,0.15)'
                        });
                        document.body.appendChild(warn);
                        setTimeout(() => {
                            warn.remove();
                            if (el.dataset) delete el.dataset.warned;
                        }, WARNING_TIME);
                    } catch (err) {
                        console.warn('showWarning err', err);
                    }
                }

                /* -------------------- input / paste limits -------------------- */
                function isInsideTinyDialog(el) {
                    return !!(el && (el.closest && (el.closest('.tox-dialog') || el.closest('.tox-tinymce') || el.closest('.tox-tinymce-aux'))));
                }

                function enforceCharLimit(e) {
                    const el = e.target;
                    if (!el) return;
                    if (isInsideTinyDialog(el)) return;
                    if (el.classList && el.classList.contains('tox-textarea')) return;

                    if (el.tagName !== 'INPUT' && el.tagName !== 'TEXTAREA') return;
                    //if (el.tagName === 'INPUT' && el.type !== 'text') return;
                    if (el.tagName === 'INPUT' && (el.type !== 'search') && el.type !== 'text') return;
                    //alert(el.value);
                    let val = el.value || '';

                    if (el.tagName === 'TEXTAREA') {
                        //const words = [...val.matchAll(/\S+/g)];
                        //if (words.length > MAX_WORD_LENGTH) {
                            // const last = words[MAX_WORD_LENGTH - 1];
                            // const endPos = last.index + last[0].length;
                            // el.value = val.substring(0, endPos);
                            // showWarning(el, `Max ${MAX_WORD_LENGTH} words allowed.`);

                            if (val.length > MAX_WORD_LENGTH) {
                                el.value = val.substring(0, MAX_WORD_LENGTH);
                                showWarning(el, `Max ${MAX_WORD_LENGTH} characters allowed.`);
                            }
                        //}
                    } else {
                        
                        if (val.length > MAX_LENGTH) {
                            el.value = val.substring(0, MAX_LENGTH);
                            showWarning(el, `Max ${MAX_LENGTH} characters allowed.`);
                        }
                    }
                }

                document.addEventListener('input', enforceCharLimit, true);
                document.addEventListener('paste', function (e) {
                    const el = e.target;
                    if (!el) return;
                    if (isInsideTinyDialog(el)) return;
                    setTimeout(() => enforceCharLimit({ target: el }), 10);
                }, true);

            })();
        </script>


    @yield('script')
</body>

</html>
