<div class="card mb-5">
    <div class="card-header bg-light">
        <h5 class="mb-0">Bulk Upload Students</h5>
    </div>

    <div class="card-body">
        <div class="alert alert-info">
            <strong>Note:</strong> Upload Excel file with student data.
        </div>

        <div class="mb-3">
            <!-- <a href="{{ route('students.bulk.template.csv') }}" class="btn btn-outline-secondary">
                Download CSV Template
            </a> -->
            <a href="{{ route('students.bulk.template.excel') }}" class="btn btn-outline-secondary">
                Download Excel Template
            </a>
        </div>

        {{-- ✅ FORM START --}}
        <form method="POST"
              action="{{ route('students.bulk.upload') }}"
              enctype="multipart/form-data">

            @csrf
            <div class="row">
                <div class="col-md-3">
                    <label class="form-label">Academic Year *</label>
                    <select name="financial_year_id" class="form-select" required>
                        @foreach($academic_years as $year)
                            <option value="{{ $year->id }}"
                                {{ old('financial_year','2025-2026') ==
                                ($year->label) ? 'selected' : '' }}>
                                {{ $year->label }}
                            </option>
                        @endforeach
                    </select>
                    @error('financial_year_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-3 mb-2">
                    <label class="form-label">Select Class *</label>
                    <select name="class_id" id="blk_class_id" class="form-select form-select-sm" required>
                        <option value="">Select Class</option>
                        @foreach($classes as $class)
                            <option value="{{ $class->id }}"
                                {{ request('class_id') == $class->id ? 'selected' : '' }}>
                                {{ $class->class_name }}
                            </option>
                        @endforeach
                    </select>
                    @error('class_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-3 mb-2">
                    <label class="form-label">Select Section *</label>
                    <select name="section_id" id="blk_section_id" class="form-select form-select-sm"
                            {{ request('class_id') ? '' : 'disabled' }} required>
                        <option value="">All Sections</option>

                        {{-- When page reloads --}}
                        @if(request('class_id'))
                            @foreach($sections as $section)
                                <option value="{{ $section->id }}"
                                    {{ request('section_id') == $section->id ? 'selected' : '' }}>
                                    {{ $section->section_name }}
                                </option>
                            @endforeach
                        @endif
                    </select>
                    @error('section_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-3 mb-2">
                    <label class="form-label">Select File *</label>
                    <input type="file"
                            name="file"
                            class="form-control"
                            accept=".csv,.xlsx,.xls"
                            required>
                    @error('section_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="col-md-4">
                <button type="submit" class="btn btn-primary btn-lg">
                    Upload & Start Processing
                </button>
            </div>
        </form>
        {{-- ✅ FORM END --}}
    </div>
</div>

<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Student Bulk Upload History</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Total Rows</th>
                        <th>Processed</th>
                        <th>Status</th>
                        <th>Progress</th>
                        <th>Failed</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody>
                @forelse ($uploads as $upload)
                    <tr>
                        <td>{{ $upload->id }}</td>
                        <td>{{ $upload->total_rows }}</td>
                        <td>{{ $upload->processed_rows }}</td>
                        <td>
                            
                            @if($upload->status === 'completed_with_errors')
                                <span class="badge bg-danger">Completed With Error</span>
                            @elseif($upload->status === 'completed')
                                <span class="badge bg-success">Completed</span>
                            @elseif($upload->status === 'running')
                                <span class="badge bg-warning">Running</span>
                            @else
                                <span class="badge bg-secondary">Pending</span>
                            @endif
                        </td>
                        <td style="width: 200px">
                            <div class="progress">
                                <div class="progress-bar"
                                    role="progressbar"
                                    style="width: {{ $upload->progress }}%">
                                    {{ $upload->progress }}%
                                </div>
                            </div>
                        </td>
                        <td>
                            @if($upload->failed > 0)
                                <span class="text-danger fw-bold">
                                    {{ $upload->failed }}
                                </span>
                            @else
                                0
                            @endif
                        </td>
                        <td>
                            @if($upload->failed > 0)
                                <a href="{{ route('students.failed.export', $upload->id) }}"
                                class="btn btn-danger btn-sm">
                                    Download Failed
                                </a>
                            @else
                                <span class="text-muted">—</span>
                            @endif
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="text-center text-muted">
                            No bulk uploads found.
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>