@extends('layouts.app')

@section('title', 'Students')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('students.index') }}">Students</a></li>
    <li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
    @php
        // Get current active class detail
        $currentClass = $student->classDetails->first();
    @endphp

    <div id="students-page" class="page-content">
        <h1 class="mb-4">Student Management</h1>

        <div class="card">
            <div class="card-header bg-light">
                <h5 class="mb-0">Edit Student</h5>
            </div>

            <div class="card-body">

                {{-- GLOBAL ERRORS --}}
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <strong>Please fix the following errors:</strong>
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form method="POST" action="{{ route('students.update', $student->id) }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    {{-- ================= PERSONAL INFORMATION ================= --}}
                    <h6 class="text-muted mb-3">Personal Information</h6>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label>Full Name *</label>
                            <input type="text" name="name"
                                placeholder="Enter student's full name"
                                value="{{ old('name', $student->name) }}"
                                class="form-control @error('name') is-invalid @enderror" required>
                            @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Date of Birth *</label>
                            <input type="date" id="dob" name="dob"
                                placeholder="Select date of birth"
                                value="{{ old('dob', $student->dob) }}"
                                class="form-control" required>
                        </div>

                        <div class="col-md-6">
                            <label>Gender *</label>
                            <select name="gender" class="form-select" required>
                                <option value="">Select Gender</option>
                                @foreach (['MALE', 'FEMALE'] as $g)
                                    <option value="{{ $g }}"
                                        {{ old('gender', strtoupper($student->gender)) == $g ? 'selected' : '' }}>
                                        {{ $g }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Nationality</label>
                            <input type="text" name="nationality"
                                placeholder="e.g. Indian"
                                value="{{ old('nationality', $student->nationality) }}"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Mother Tongue</label>
                            <input type="text" name="mother_tongue"
                                placeholder="e.g. Bengali, Hindi"
                                value="{{ old('mother_tongue', $student->mother_tongue) }}"
                                class="form-control">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Category *</label>
                            <select name="category" class="form-select" required>
                                <option value="">Select Category</option>
                                @foreach (['GEN', 'OBC', 'SC', 'ST'] as $cat)
                                    <option value="{{ $cat }}"
                                        {{ old('category', $student->category) == $cat ? 'selected' : '' }}>
                                        {{ $cat }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label>Caste</label>
                            <input type="text" name="cast"
                                placeholder="Enter caste (if applicable)"
                                value="{{ old('cast', $student->cast) }}"
                                class="form-control">
                        </div>
                    </div>

                    {{-- ================= ADDRESS ================= --}}
                    <h6 class="text-muted mt-4 mb-3">Address</h6>

                    <div class="mb-3">
                        <label>Permanent Address *</label>
                        <textarea name="address" rows="2"
                                placeholder="Enter permanent residential address"
                                class="form-control" required>{{ old('address', $student->address) }}</textarea>
                    </div>

                    <div class="mb-3">
                        <label>Local Address</label>
                        <textarea name="local_address" rows="2"
                                placeholder="Enter local address (if different)"
                                class="form-control">{{ old('local_address', $student->local_address) }}</textarea>
                    </div>

                    {{-- ================= FLAGS ================= --}}
                    <h6 class="text-muted mt-4 mb-3">Additional Information</h6>

                    <div class="row mb-3">
                        <div class="col-md-4 form-check">
                            <input type="checkbox" name="belongs_to_minority_group" value="1" class="form-check-input"
                                {{ old('belongs_to_minority_group', $student->belongs_to_minority_group) ? 'checked' : '' }}>
                            <label class="form-check-label">Minority</label>
                        </div>

                        <div class="col-md-4 form-check">
                            <input type="checkbox" name="is_disability_ph" value="1" class="form-check-input"
                                {{ old('is_disability_ph', $student->is_disability_ph) ? 'checked' : '' }}>
                            <label class="form-check-label">Physically Handicapped</label>
                        </div>

                        <div class="col-md-4 form-check">
                            <input type="checkbox" name="is_transport_required" value="1" class="form-check-input"
                                {{ old('is_transport_required', $student->is_transport_required) ? 'checked' : '' }}>
                            <label class="form-check-label">Transport Required</label>
                        </div>
                    </div>

                    {{-- ================= CLASS ASSIGNMENT ================= --}}
                    <h6 class="text-muted mt-4 mb-3">Class Assignment</h6>

                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label>Class *</label>
                            <select name="class_id" id="class_id" class="form-select" required>
                                <option value="">Select Class</option>
                                @foreach ($classes as $class)
                                    <option value="{{ $class->id }}"
                                        {{ old('class_id', $currentClass?->class_id) == $class->id ? 'selected' : '' }}>
                                        {{ $class->class_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label>Section *</label>
                            <select name="section_id" id="reg_section_id" class="form-select" required>
                                <option value="">Select Section</option>
                                @foreach ($classes as $class)
                                    @if ($class->id == old('class_id', $currentClass?->class_id))
                                        @foreach ($class->sections as $section)
                                            <option value="{{ $section->id }}"
                                                {{ old('section_id', $currentClass?->section_id) == $section->id ? 'selected' : '' }}>
                                                {{ $section->section_name }}
                                            </option>
                                        @endforeach
                                    @endif
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label>Admission Date *</label>
                            <input type="date" id="admission_date" name="admission_date"
                                placeholder="Select admission date"
                                value="{{ old('admission_date', $currentClass?->admission_date) }}"
                                class="form-control" required>
                        </div>
                    </div>

                    {{-- ================= PARENT / GUARDIAN ================= --}}
                    <h6 class="text-muted mt-4 mb-3">Parent / Guardian Details</h6>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Name *</label>
                            <input type="text" name="father_name"
                                placeholder="Enter father's full name"
                                value="{{ old('father_name', $student->parent->father_name) }}"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Mother Name *</label>
                            <input type="text" name="mother_name"
                                placeholder="Enter mother's full name"
                                value="{{ old('mother_name', $student->parent->mother_name) }}"
                                class="form-control">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Qualification</label>
                            <input type="text" name="father_qualification"
                                placeholder="e.g. Graduate, Diploma"
                                value="{{ old('father_qualification', $student->parent->father_qualification) }}"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Mother Qualification</label>
                            <input type="text" name="mother_qualification"
                                placeholder="e.g. Graduate, Diploma"
                                value="{{ old('mother_qualification', $student->parent->mother_qualification) }}"
                                class="form-control">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Occupation</label>
                            <input type="text" name="father_occupation"
                                placeholder="Enter father's occupation"
                                value="{{ old('father_occupation', $student->parent->father_occupation) }}"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Mother Occupation</label>
                            <input type="text" name="mother_occupation"
                                placeholder="Enter mother's occupation"
                                value="{{ old('mother_occupation', $student->parent->mother_occupation) }}"
                                class="form-control">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Phone *</label>
                            <input type="tel" name="father_phone"
                                placeholder="10 digit mobile number"
                                maxlength="10" pattern="[0-9]{10}"
                                value="{{ old('father_phone', $student->parent->father_phone) }}"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Mother Phone</label>
                            <input type="tel" name="mother_phone"
                                placeholder="10 digit mobile number"
                                maxlength="10" pattern="[0-9]{10}"
                                value="{{ old('mother_phone', $student->parent->mother_phone) }}"
                                class="form-control">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Guardian Name</label>
                            <input type="text" name="guardian_name"
                                placeholder="Enter guardian name"
                                value="{{ old('guardian_name', $student->parent->guardian_name) }}"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Guardian Phone</label>
                            <input type="tel" name="guardian_phone"
                                placeholder="10 digit mobile number"
                                maxlength="10" pattern="[0-9]{10}"
                                value="{{ old('guardian_phone', $student->parent->guardian_phone) }}"
                                class="form-control">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label>Guardian Address</label>
                        <textarea name="guardian_address" rows="2"
                                placeholder="Enter guardian address"
                                class="form-control">{{ old('guardian_address', $student->parent->guardian_address) }}</textarea>
                    </div>

                    {{-- ================= DOCUMENTS ================= --}}
                    <h6 class="text-muted mt-4 mb-3">Documents</h6>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Profile Photo</label>
                            <input type="file" name="profile_image" class="form-control" accept="image/*">
                            <small class="text-muted">Upload recent passport size photo</small>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">DOB Proof</label>
                            <input type="file" name="dob_photo_copy" class="form-control" accept="image/*,application/pdf">
                            <small class="text-muted">Birth certificate / Aadhaar / PDF</small>
                        </div>
                    </div>

                    <div class="d-flex gap-2 justify-content-end mt-3">
                        <button type="submit" class="btn btn-primary btn-sm">Update Student</button>
                        <a href="{{ route('students.index') }}" class="btn btn-secondary btn-sm">Cancel</a>
                    </div>

                </form>
            </div>
        </div>
    </div>

@endsection

@section('script')
    <script>
        const classes = @json($classes);

        $(document).on('change', '#class_id', function () {

            const classId = $(this).val();
            let html = '<option value="">Select Section</option>';

            const selectedClass = classes.find(c => c.id == classId);

            if (selectedClass && selectedClass.sections) {
                selectedClass.sections.forEach(section => {
                    html += `<option value="${section.id}">${section.section_name}</option>`;
                });
            }

            const $section = $('#reg_section_id');

            console.log('Section element found:', $section.length);

            $section
                .prop('disabled', false)
                .html(html);
        });
    </script>

    <script>
        $(document).ready(function () {

            let today = new Date();

            // Max = today (disable future)
            let maxDate = today.toISOString().split('T')[0];

            // Min = today - 1 month
            let minDate = new Date(
                today.getFullYear(),
                today.getMonth() - 3,
                today.getDate()
            ).toISOString().split('T')[0];

            $('#admission_date').attr({
                min: minDate,
                max: maxDate
            });

            

            maxDate = new Date(
                today.getFullYear() - 2,
                today.getMonth(),
                today.getDate()
            ).toISOString().split('T')[0];

            $('#dob').attr('max', maxDate);

        });
    </script>
    <script>
        document.getElementById('dob_photo_copy').addEventListener('change', function (event) {

            let input   = event.target;
            let file    = input.files[0];
            let preview = document.getElementById('dobPreview');

            preview.innerHTML = ""; // clear old preview

            let dt = new DataTransfer(); // rebuild file list

            if (!file) return;

            // ✅ Allowed types
            let allowedTypes = [
                'image/jpeg',
                'image/png',
                'image/jpg',
                'image/webp',
                'image/gif',
                'application/pdf'
            ];

            if (!allowedTypes.includes(file.type)) {
                toastr.error("Only images and PDF files are allowed!", "Error");
                input.value = "";
                return;
            }

            // keep valid file
            dt.items.add(file);
            input.files = dt.files;

            // 🖼️ IMAGE PREVIEW
            if (file.type.startsWith('image/')) {

                let reader = new FileReader();
                reader.onload = function (e) {

                    let col = document.createElement('div');
                    col.classList.add('col-md-3', 'mb-3');

                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" 
                                class="card-img-top img-fluid"
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;

                    preview.appendChild(col);
                };

                reader.readAsDataURL(file);

            }
            // 📄 PDF PREVIEW (ICON + NAME)
            else if (file.type === 'application/pdf') {

                let col = document.createElement('div');
                col.classList.add('col-md-3', 'mb-3');

                col.innerHTML = `
                    <div class="card text-center p-3">
                        <i class="fa fa-file-pdf-o fa-3x text-danger mb-2"></i>
                        <p class="small">${file.name}</p>
                    </div>
                `;

                preview.appendChild(col);
            }

        });
        document.getElementById('profile_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = input.files[0];
            let preview = document.getElementById('profilePreview');
            // Clear old preview

            let dt = new DataTransfer(); // For rebuilding file list

            if (file && file.type.startsWith('image/')) {
                dt.items.add(file); // Keep valid file

                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-3', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = "";
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }

            // Replace with filtered file list (empty if invalid)
            input.files = dt.files;
        });
    </script>
@endsection