<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Register New Student</h5>
    </div>

    <div class="card-body">

        <form method="POST" action="{{ route('students.store') }}" enctype="multipart/form-data">
            @csrf

            {{-- ================= PERSONAL INFORMATION ================= --}}
            <h6 class="text-muted mb-3">Personal Information</h6>

            <div class="row mb-3">
                <div class="col-md-12">
                    <label>Full Name *</label>
                    <input type="text" name="name"
                           placeholder="Enter student's full name"
                           value="{{ old('name') }}" class="form-control" required>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Date of Birth *</label>
                    <input type="date" name="dob" id="dob"
                           placeholder="Select date of birth"
                           value="{{ old('dob') }}" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label>Gender *</label>
                    <select name="gender" class="form-select" required>
                        <option value="">Select gender</option>
                        <option value="Male" {{ old('gender')=='Male'?'selected':'' }}>Male</option>
                        <option value="Female" {{ old('gender')=='Female'?'selected':'' }}>Female</option>
                    </select>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Nationality</label>
                    <input type="text" name="nationality"
                           placeholder="e.g. Indian"
                           value="{{ old('nationality','Indian') }}" class="form-control">
                </div>

                <div class="col-md-6">
                    <label>Mother Tongue</label>
                    <input type="text" name="mother_tongue"
                           placeholder="e.g. Bengali, Hindi"
                           value="{{ old('mother_tongue') }}" class="form-control">
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Category *</label>
                    <select name="category" class="form-select" required>
                        <option value="">Select category</option>
                        <option value="GEN">GEN</option>
                        <option value="OBC">OBC</option>
                        <option value="SC">SC</option>
                        <option value="ST">ST</option>
                    </select>
                </div>

                <div class="col-md-6">
                    <label>Caste</label>
                    <input type="text" name="cast"
                           placeholder="Enter caste (if applicable)"
                           value="{{ old('cast') }}" class="form-control">
                </div>
            </div>

            {{-- ================= ADDRESS ================= --}}
            <h6 class="text-muted mt-4">Address Information</h6>

            <div class="mb-3">
                <label>Address *</label>
                <textarea name="address" class="form-control"
                          placeholder="Enter permanent residential address"
                          required>{{ old('address') }}</textarea>
            </div>

            <div class="mb-3">
                <label>Local Address</label>
                <textarea name="local_address" class="form-control"
                          placeholder="Enter local address if different">{{ old('local_address') }}</textarea>
            </div>

            {{-- ================= CLASS DETAILS ================= --}}
            <h6 class="text-muted mt-4">Class Details</h6>

            <div class="row mb-4">
                <div class="col-md-4">
                    <label>Class *</label>
                    <select name="class_id" id="class_id" class="form-select" required>
                        <option value="">Select class</option>
                        @foreach($classes as $class)
                            <option value="{{ $class->id }}">{{ $class->class_name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-4">
                    <label>Section *</label>
                    <select name="section_id" id="reg_section_id" class="form-select" required>
                        <option value="">Select section</option>
                    </select>
                </div>

                <div class="col-md-4">
                    <label>Admission Date *</label>
                    <input type="date" name="admission_date" id="admission_date"
                           placeholder="Select admission date"
                           value="{{ old('admission_date') }}" class="form-control" required>
                </div>
            </div>

            {{-- ================= PARENTS ================= --}}
            <h6 class="text-muted mt-4">Parent / Guardian</h6>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Father Name *</label>
                    <input type="text" name="father_name"
                           placeholder="Enter father's full name"
                           value="{{ old('father_name') }}" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label>Mother Name *</label>
                    <input type="text" name="mother_name"
                           placeholder="Enter mother's full name"
                           value="{{ old('mother_name') }}" class="form-control" required>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Father Phone *</label>
                    <input type="tel" name="father_phone"
                           placeholder="10-digit mobile number"
                           pattern="[0-9]{10}" maxlength="10"
                           value="{{ old('father_phone') }}" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label>Mother Phone</label>
                    <input type="tel" name="mother_phone"
                           placeholder="10-digit mobile number"
                           pattern="[0-9]{10}" maxlength="10"
                           value="{{ old('mother_phone') }}" class="form-control">
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Father Qualification</label>
                    <input type="text" name="father_qualification"
                        placeholder="e.g. Graduate, Diploma"
                        value="{{ old('father_qualification') }}"
                        class="form-control">
                </div>

                <div class="col-md-6">
                    <label>Mother Qualification</label>
                    <input type="text" name="mother_qualification"
                        placeholder="e.g. Graduate, Diploma"
                        value="{{ old('mother_qualification') }}"
                        class="form-control">
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Father Occupation</label>
                    <input type="text" name="father_occupation"
                        placeholder="Enter father's occupation"
                        value="{{ old('father_occupation') }}"
                        class="form-control">
                </div>

                <div class="col-md-6">
                    <label>Mother Occupation</label>
                    <input type="text" name="mother_occupation"
                        placeholder="Enter mother's occupation"
                        value="{{ old('mother_occupation') }}"
                        class="form-control">
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Guardian Name</label>
                    <input type="text" name="guardian_name"
                           placeholder="Guardian full name (if any)"
                           value="{{ old('guardian_name') }}" class="form-control">
                </div>

                <div class="col-md-6">
                    <label>Guardian Phone</label>
                    <input type="tel" name="guardian_phone"
                           placeholder="10-digit mobile number"
                           pattern="[0-9]{10}" maxlength="10"
                           value="{{ old('guardian_phone') }}" class="form-control">
                </div>
            </div>

            <div class="row mb-3">
                <label>Guardian Address</label>
                <textarea name="guardian_address" class="form-control"
                          placeholder="Enter guardian address">{{ old('guardian_address') }}</textarea>
            </div>

            {{-- ================= DOCUMENTS ================= --}}
            <div class="row mb-4">
                <div class="col-md-6">
                    <label>Profile Image</label>
                    <input type="file" name="profile_image"
                           class="form-control" accept="image/*">
                    <small class="text-muted">JPG / PNG, max 2MB</small>
                </div>

                <div class="col-md-6">
                    <label>DOB Proof</label>
                    <input type="file" name="dob_photo_copy"
                           class="form-control" accept="image/*,application/pdf">
                    <small class="text-muted">Birth certificate / Aadhaar</small>
                </div>
            </div>

            <div class="d-flex gap-2 justify-content-end">
                <button class="btn btn-primary btn-sm">Register Student</button>
                <a href="{{ route('students.index') }}" class="btn btn-secondary btn-sm">Cancel</a>
            </div>

        </form>
    </div>
</div>
