<div class="card">
    <div class="card-header bg-light">
        <div class="row align-items-center">
            <div class="col-md-4">
                <h5 class="mb-0">All Staff Members</h5>
            </div>
            <div class="col-md-8">
                <form method="GET" action="<?php echo e(route('staff.index')); ?>" class="row g-2">

                    
                    <div class="col-md-6">
                        <select name="category"
                                id="category_id"
                                class="form-select form-select-sm">
                            <option value="">All Category</option>
                            <option value="Teacher" <?php echo e(request('category') == 'Teacher' ? 'selected' : ''); ?>>Teacher</option>
                            <option value="Non-Teacher" <?php echo e(request('category') == 'Non-Teacher' ? 'selected' : ''); ?>>Non-Teacher
                            </option>
                        </select>
                    </div>

                    
                    <div class="col-md-6">
                        <input type="search"
                            name="name"
                            value="<?php echo e(request('name')); ?>"
                            class="form-control form-control-sm"
                            placeholder="Search by name">
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Category</th>
                        <th>Designation</th>
                        <th>Qualification</th>
                        <th>Phone</th>
                        <th>Email</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $staffs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $staff): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($staff->name); ?></td>

                            <td>
                                <span class="badge bg-info">
                                    <?php echo e(ucfirst($staff->category)); ?>

                                </span>
                            </td>

                            <td><?php echo e($staff->designation); ?></td>
                            <td><?php echo e($staff->qualification); ?></td>
                            <td><?php echo e($staff->phone); ?></td>
                            <td><?php echo e($staff->email ?? '-'); ?></td>

                            <td>
                                <div class="form-check form-switch">
                                    <input
                                        class="form-check-input staff-status"
                                        type="checkbox"
                                        id="status_<?php echo e($staff->id); ?>"
                                        data-id="<?php echo e($staff->id); ?>"
                                        data-url="<?php echo e(route('staff.update', $staff->id)); ?>"
                                        <?php echo e($staff->status ? 'checked' : ''); ?>

                                    >
                                </div>
                            </td>

                            <td>
                                <a href="<?php echo e(route('staff.edit', $staff->id)); ?>"
                                   class="btn btn-sm btn-outline-primary">
                                    Edit
                                </a>
                                <a href="<?php echo e(route('staff.show', $staff->id)); ?>" class="btn btn-sm btn-outline-secondary">View</a>

                                <!-- <form action="<?php echo e(route('staff.destroy', $staff->id)); ?>"
                                      method="POST"
                                      class="d-inline"
                                      onsubmit="return confirm('Remove staff from current academic year?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button class="btn btn-sm btn-outline-danger">
                                        Remove
                                    </button>
                                </form> -->
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center text-muted">
                                No staff found for the current academic year
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        
        <div class="mt-3">
            <?php echo e($staffs->links()); ?>

        </div>
    </div>
</div>
<?php /**PATH /var/www/html/school-ramkrishna/resources/views/staff/list.blade.php ENDPATH**/ ?>