<?php $__env->startSection('title','Fees'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item active">Fee Collection</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div id="fees-page" class="page-content">
    <h1 class="mb-4">Student Fee Collection</h1>
    <ul class="nav nav-tabs mb-4" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="fee-list-tab" data-bs-toggle="tab" data-bs-target="#fee-list" type="button" role="tab">Fee List</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="collect-fee-tab" data-bs-toggle="tab" data-bs-target="#collect-fee" type="button" role="tab">Collect Fee</button>
        </li>
    </ul>

    <div class="tab-content">
        <!-- Fee List Tab -->
        <div class="tab-pane fade show active" id="fee-list" role="tabpanel">
            <?php echo $__env->make('student_fees.list', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>

        <!-- Collect Fee Tab -->
        <div class="tab-pane fade" id="collect-fee" role="tabpanel">
            <?php echo $__env->make('student_fees.collect', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>

    <div class="modal fade" id="editFeeHeadModal" tabindex="-1">
        <div class="modal-dialog">
            <form id="editFeeHeadForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <input type="hidden" id="edit_id">

                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Fee Head</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body">

                        <div class="mb-3">
                            <label class="form-label">Fee Head Name *</label>
                            <input type="text" class="form-control" id="edit_name" name="name">
                            <small class="text-danger d-none" id="error_name"></small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" id="edit_description" name="description"></textarea>
                            <small class="text-danger d-none" id="error_description"></small>
                        </div>

                    </div>


                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary" id="saveBtn">
                            <span id="saveText">Update</span>
                            <span id="saveSpinner" class="spinner-border spinner-border-sm d-none"></span>
                        </button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="studentFeeModal" tabindex="-1">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 class="modal-title" id="feeModalTitle"></h5>
                    <button class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body" id="feeModalBody"></div>

            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

<script>
        const classes = <?php echo json_encode($classes, 15, 512) ?>;

        document.getElementById('class_id').addEventListener('change', function () {
            const classId = this.value;
            const sectionSelect = document.getElementById('section_id');
            sectionSelect.innerHTML = '<option value="">Select Section</option>';

            const selectedClass = classes.find(c => c.id == classId);
            if (selectedClass && selectedClass.sections) {
                selectedClass.sections.forEach(section => {
                    sectionSelect.innerHTML +=
                        `<option value="${section.id}">${section.section_name}</option>`;
                });
            }

        });

    </script>

    <script>
        document.getElementById('class_id').addEventListener('change', function () {
            let classId = this.value;
            let sectionSelect = document.getElementById('section_id');

            sectionSelect.innerHTML = '<option value="">Loading...</option>';
            sectionSelect.disabled = true;

            if (!classId) {
                sectionSelect.innerHTML = '<option value="">All Sections</option>';
                return;
            }

            fetch(`classes/${classId}/sections`)
                .then(res => res.json())
                .then(data => {
                    sectionSelect.innerHTML = '<option value="">All Sections</option>';
                    data.forEach(section => {
                        sectionSelect.innerHTML +=
                            `<option value="${section.id}">${section.section_name}</option>`;
                    });
                    sectionSelect.disabled = false;
                });
        });

        // Auto submit on section change
        document.getElementById('section_id').addEventListener('change', function () {
            this.form.submit();
        });
    </script>

    <script>
        /* ===============================
            UTIL: Title Case
        ================================ */
        function titleCase(str) {
            return str.replace(/_/g, ' ')
                    .toLowerCase()
                    .replace(/\b\w/g, l => l.toUpperCase());
        }

        /* ===============================
            CALCULATE GRAND TOTAL
        ================================ */
        function calculateGrandTotal() {
            let total = 0;

            $('.month-check:checked').each(function () {
                const card = $(this).closest('.card');

                card.find('input[name$="[amount]"]:enabled').each(function () {
                    total += parseFloat(this.value) || 0;
                });

                card.find('input[name$="[late_fee]"]:enabled').each(function () {
                    total += parseFloat(this.value) || 0;
                });
            });

            $('#grandTotal').val(total.toFixed(2));

            if(total>0){
                $('#month-fee-collection').show();
            } else {
                $('#month-fee-collection').hide();
            }
        }

        /* ===============================
            ENABLE / DISABLE MONTH FEES
        ================================ */
        $(document).on('change', '.month-check', function () {
            const card = $(this).closest('.card');

            card.find('input[type="hidden"]').prop(
                'disabled',
                !this.checked
            );

            calculateGrandTotal();
        });

        /* ===============================
            STUDENT CHANGE → LOAD FEES
        ================================ */
        $('#student_id').on('change', function () {

            const studentId = $(this).val();
            const yearId    = $('#financial_year_id').val();

            $('#monthWiseFees').html('');
            $('#not_found').html('');
            $('#grandTotal').val(0);

            if (!studentId) return;

            $.get(
                "<?php echo e(route('fee.collection.student', ':id')); ?>".replace(':id', studentId),
                { financial_year_id: yearId },
                function (months) {

                    if (!months.length) {
                        $('#not_found').html(
                            '<div class="alert alert-info">Please configure the class wise fee.</div>'
                        );
                        return;
                    }

                    $('#payment-sec').show();

                    months.forEach(m => {

                        let feeRows   = '';
                        let monthTotal = 0;

                        m.fees.forEach((f, i) => {

                            monthTotal += Number(f.total);

                            feeRows += `
                                <tr class="${f.paid ? 'table-success' : ''}">
                                    <td>${f.name}</td>
                                    <td>${titleCase(f.type)}</td>
                                    <td>₹${f.amount}</td>
                                    <td>₹${f.late_fee}</td>
                                    <td>₹${f.total}</td>

                                    ${(!f.paid && f.total > 0) ? `
                                        <input type="hidden"
                                            name="fees[${m.month}][${i}][fee_head_id]"
                                            value="${f.fee_head_id}">

                                        <input type="hidden"
                                            name="fees[${m.month}][${i}][amount]"
                                            value="${f.amount}">

                                        <input type="hidden"
                                            name="fees[${m.month}][${i}][late_fee]"
                                            value="${f.late_fee}">
                                    ` : ''}
                                </tr>
                            `;
                        });

                        /* ---------------------------------
                        STATUS + CHECKBOX LOGIC
                        ---------------------------------- */
                        let badge = '';
                        let checkbox = '';

                        if (m.status === 'paid') {

                            // ✅ Always show paid badge
                            badge = `<span class="badge bg-success">Paid</span>`;

                        } else if (monthTotal > 0) {

                            // ✅ Unpaid + fee exists
                            badge = `<span class="badge bg-danger">Unpaid</span>`;

                            if (m.selectable) {
                                checkbox = `
                                    <input type="checkbox"
                                        class="form-check-input month-check"
                                        name="months[]"
                                        value="${m.month}"
                                        checked>
                                `;
                            }
                        }

                        $('#monthWiseFees').append(`
                            <div class="card mb-3 border-${m.status === 'paid' ? 'success' : 'secondary'}">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0">${m.label}</h5>

                                    <div class="d-flex align-items-center gap-2">
                                        ${badge}
                                        ${checkbox}
                                    </div>
                                </div>

                                <div class="card-body p-0">
                                    <table class="table mb-0">
                                        <thead>
                                            <tr>
                                                <th>Fee Head</th>
                                                <th>Type</th>
                                                <th>Amount</th>
                                                <th>Late</th>
                                                <th>Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>${feeRows}</tbody>
                                    </table>

                                    <div class="text-end fw-bold p-2">
                                        Month Total: ₹${monthTotal}
                                    </div>
                                </div>
                            </div>
                        `);
                    });

                    calculateGrandTotal();
                }
            );
        });

    </script>

    <script>
        $(function () {
            console.log('jQuery:', typeof jQuery);
            console.log('Select2:', $.fn.select2);

            $('#student_id').select2({
                placeholder: 'Search student...',
                allowClear: true,
                width: '100%',
                minimumInputLength: 2,
                ajax: {
                    url: "<?php echo e(route('students.search')); ?>",
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return { q: params.term };
                    },
                    processResults: function (data) {
                        return {
                            results: data.map(s => ({
                                id: s.id,
                                text: `#${s.admission_no} - ${s.name} (${s.class_name}-${s.section_name})`
                            }))
                        };
                    }
                }
            });

        });
    </script>

    <script>
        function formatMonth(monthStr) {
            // monthStr = "2025-12"
            const [year, month] = monthStr.split('-');
            const date = new Date(year, month - 1);

            return date.toLocaleString('en-IN', {
                month: 'long',
                year: 'numeric'
            });
        }

        $(document).on('click', '.viewFeeBtn', function () {

            let studentId = $(this).data('student-id');
            let month     = $(this).data('month');

            $('#feeModalTitle').text(`Fee Details (${formatMonth(month)})`);
            $('#feeModalBody').html('Loading...');

            $.get("<?php echo e(route('student-fees.month.details', ':id')); ?>"
                .replace(':id', studentId),
                { month },
                function (res) {

                    let rows = '';
                    let totalAmount = 0;

                    res.fees.forEach(f => {

                        let rowTotal = parseFloat(f.amount) + parseFloat(f.late_fee);
                        totalAmount += rowTotal;

                        rows += `
                            <tr>
                                <td>${f.fee_head.name}</td>
                                <td>₹${parseFloat(f.amount).toFixed(2)}</td>
                                <td>₹${parseFloat(f.late_fee).toFixed(2)}</td>
                                <td>₹${rowTotal.toFixed(2)}</td>
                            </tr>
                        `;
                    });

                    // Take common values from first record
                    let paymentMethod = res.fees[0]?.payment_method ?? '-';
                    let transactionId = res.fees[0]?.transaction_id ?? '-';
                    let paidDate      = res.fees[0]?.paid_date ?? '-';

                    $('#feeModalBody').html(`
                        <div class="mb-2">
                            <strong>${res.student.name}</strong><br>
                            Class: ${res.student.class} (${res.student.section})<br>
                            Admission No: ${res.student.admission_no}<br>
                            Fees Month: <strong>${formatMonth(res.month)}</strong>

                        </div>

                        <table class="table table-bordered">
                            <thead class="table-light">
                                <tr>
                                    <th>Fee Head</th>
                                    <th>Amount</th>
                                    <th>Late Fee</th>
                                    <th>Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                ${rows}
                            </tbody>
                        </table>

                        <div class="row mt-3">
                            <div class="col-md-6">
                                <p><strong>Payment Method:</strong> ${paymentMethod}</p>
                                <p><strong>Transaction ID:</strong> <span class="wrap-text">${transactionId}</span></p>
                                <p><strong>Paid Date:</strong> ${paidDate}</p>
                            </div>
                            <div class="col-md-6 text-end">
                                <h5 class="fw-bold">
                                    Total Paid: ₹ ${totalAmount.toFixed(2)}
                                </h5>
                            </div>
                        </div>
                    `);

                    $('#studentFeeModal').modal('show');
                }
            );
        });
    </script>


    <script>
        $(document).on('click', '.collectFeeBtn', function () {

            let studentId = $(this).data('student-id');
            let month = $(this).data('month');

            $('#feeModalTitle').text(`Collect Fee (${month})`);
            $('#feeModalBody').html('Loading...');

            $.get("<?php echo e(route('student-fees.month.pending', ':id')); ?>"
                .replace(':id', studentId),
                {
                    month,
                    financial_year_id: <?php echo e($active_academic_year->id); ?>

                },
                function (res) {

                    let rows = '';
                    let grandTotal = 0;

                    res.fees.forEach((f,i) => {

                        let rowTotal = parseFloat(f.total);
                        grandTotal += rowTotal;

                        rows += `
                            <tr>
                                <td>${f.name}</td>
                                <td>₹${f.amount}</td>
                                <td>₹${f.late_fee}</td>
                                <td>₹${rowTotal}</td>

                                <!-- 🔥 REQUIRED FOR BACKEND -->
                                <input type="hidden" name="fees[${i}][fee_head_id]" value="${f.fee_head_id}">
                                <input type="hidden" name="fees[${i}][amount]" value="${f.amount}">
                                <input type="hidden" name="fees[${i}][late_fee]" value="${f.late_fee}">
                            </tr>`;
                    });

                    $('#feeModalBody').html(`
                        <form id="collectSingleMonthFee"  method="post" action="<?php echo e(route('student-fees.month.pay')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="student_id" value="${studentId}">
                            <input type="hidden" name="financial_year_id" value="<?php echo e($active_academic_year->id); ?>">
                            <input type="hidden" name="fee_for_month" value="${month}">
                            <input type="hidden" name="total_amount" value="${grandTotal}">

                            <table class="table mb-3">
                                <thead>
                                    <tr>
                                        <th>Fee Head</th>
                                        <th>Amount</th>
                                        <th>Late</th>
                                        <th>Total</th>
                                    </tr>
                                </thead>
                                <tbody>${rows}</tbody>
                            </table>

                            <!-- ✅ TOTAL PAYABLE -->
                            <div class="d-flex justify-content-start mb-3">
                                <h5 class="fw-bold">
                                    Total Payable: ₹ <span id="payableTotal">${grandTotal.toFixed(2)}</span>
                                </h5>
                            </div>

                            <div class="row mb-2">
                                <div class="col-md-6">
                                    <select name="payment_method" class="form-select" required>
                                        <option value="">Payment Method</option>
                                        <option>Cash</option>
                                        <option>Online</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <input
                                        name="transaction_id"
                                        class="form-control"
                                        placeholder="Transaction ID / Bill No."
                                        required>
                                </div>
                            </div>

                            <div class="text-end">
                                <button class="btn btn-primary">
                                    Pay ₹ ${grandTotal.toFixed(2)}
                                </button>
                            </div>
                        </form>
                    `);

                    $('#studentFeeModal').modal('show');
                }
            );
        });

    </script>

    <script>
        // $(document).on('submit', '#collectSingleMonthFee', function (e) {
        //     e.preventDefault();

        //     let form = $(this);
        //     let btn  = form.find('button[type=submit]');

        //     btn.prop('disabled', true).text('Processing...');

        //     $.ajax({
        //         url: "<?php echo e(route('student-fees.month.pay')); ?>",
        //         method: "POST",
        //         data: form.serialize(),
        //         headers: {
        //             'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        //         },
        //         success: function (res) {

        //             if (res.success) {
        //                 alert(res.message);

        //                 $('#studentFeeModal').modal('hide');

        //                 // 🔄 reload page OR reload table row
        //                 location.reload();
        //             } else {
        //                 alert('Something went wrong');
        //             }
        //         },
        //         error: function (xhr) {
        //             alert(xhr.responseJSON?.message || 'Payment failed');
        //         },
        //         complete: function () {
        //             btn.prop('disabled', false).text('Pay');
        //         }
        //     });
        // });
    </script>






<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/school-ramkrishna/resources/views/student_fees/index.blade.php ENDPATH**/ ?>