

<?php $__env->startSection('title', 'Staff'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('staff.index')); ?>">Staff</a></li>
    <li class="breadcrumb-item active">Details</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    <div class="d-flex justify-content-between mb-3">
        <h4 class="mb-0">Staff Details</h4>
        <a href="<?php echo e(route('staff.index')); ?>" class="btn btn-secondary btn-sm">
            Back
        </a>
    </div>

    
    <div class="card mb-3">
        <div class="card-header bg-light">
            <strong>Personal Information</strong>
        </div>
        <div class="card-body">
            <div class="row mb-2">
                <div class="col-md-4"><strong>Name:</strong> <?php echo e($staff->name); ?></div>
                <div class="col-md-4"><strong>Email:</strong> <?php echo e($staff->email ?? '-'); ?></div>
                <div class="col-md-4"><strong>Phone:</strong> <?php echo e($staff->phone); ?></div>
            </div>

            <div class="row mb-2">
                <div class="col-md-6"><strong>Address:</strong> <?php echo e($staff->address ?? '-'); ?></div>
                <!-- <div class="col-md-3">
                    <strong>Status:</strong>
                    <?php if($staff->status): ?>
                        <span class="badge bg-success">Active</span>
                    <?php else: ?>
                        <span class="badge bg-secondary">Inactive</span>
                    <?php endif; ?>
                </div> -->
            </div>
        </div>
    </div>

    
    <div class="card mb-3">
        <div class="card-header bg-light">
            <strong>Employment Details</strong>
        </div>
        <div class="card-body">
            <div class="row mb-2">
                <div class="col-md-4"><strong>Category:</strong> <?php echo e($staff->category); ?></div>
                <div class="col-md-4"><strong>Designation:</strong> <?php echo e($staff->designation); ?></div>
                <div class="col-md-4"><strong>Qualification:</strong> <?php echo e($staff->qualification); ?></div>
            </div>

            <div class="row">
                <div class="col-md-4">
                    <strong>Joining Date:</strong>
                    <?php echo e(\Carbon\Carbon::parse($staff->joining_date)->format('d M Y')); ?>

                </div>
            </div>
        </div>
    </div>

    
    <div class="card mb-3">
        <div class="card-header bg-light">
            <strong>Salary Details</strong>
        </div>
        <div class="card-body">

            <?php if($staff->salary): ?>

                <h6 class="text-muted">Earnings</h6>
                <div class="row mb-2">
                    <div class="col-md-3">Basic: ₹<?php echo e($staff->salary->basic); ?></div>
                    <div class="col-md-3">HRA: ₹<?php echo e($staff->salary->hra); ?></div>
                    <div class="col-md-3">DA: ₹<?php echo e($staff->salary->da); ?></div>
                    <div class="col-md-3">TA: ₹<?php echo e($staff->salary->ta); ?></div>
                </div>

                <div class="row mb-2">
                    <div class="col-md-3">Medical: ₹<?php echo e($staff->salary->medical_allowance); ?></div>
                    <div class="col-md-3">Conveyance: ₹<?php echo e($staff->salary->conveyance); ?></div>
                    <div class="col-md-3">Washing: ₹<?php echo e($staff->salary->washing_allowance); ?></div>
                    <div class="col-md-3">Special: ₹<?php echo e($staff->salary->special_allowance); ?></div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-4">
                        <strong>Total Earnings:</strong>
                        ₹<?php echo e($staff->salary->total_earnings); ?>

                    </div>
                </div>

                <hr>

                <h6 class="text-muted">Deductions</h6>
                <div class="row mb-2">
                    <div class="col-md-3">PF: ₹<?php echo e($staff->salary->pf); ?></div>
                    <div class="col-md-3">ESI: ₹<?php echo e($staff->salary->esi); ?></div>
                    <div class="col-md-3">P-Tax: ₹<?php echo e($staff->salary->p_tax); ?></div>
                    <div class="col-md-3">TDS: ₹<?php echo e($staff->salary->tds); ?></div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-4">
                        <strong>Total Deductions:</strong>
                        ₹<?php echo e($staff->salary->total_deductions); ?>

                    </div>
                </div>

                <hr>

                <div class="row mb-2">
                    <div class="col-md-4">
                        <strong>Net Salary:</strong>
                        ₹<?php echo e($staff->salary->net_salary); ?>

                    </div>
                    <div class="col-md-4">
                        <strong>Employer PF:</strong>
                        ₹<?php echo e($staff->salary->employer_pf); ?>

                    </div>
                    <div class="col-md-4">
                        <strong>Financial Year:</strong>
                        <?php echo e($staff->salary->financialYear->label); ?>

                    </div>
                   
                </div>

                <div class="row">
                    <div class="col-md-4">
                        <strong>CTC:</strong>
                        ₹<?php echo e($staff->salary->ctc); ?>

                    </div>
                     <div class="col-md-4">
                        <strong>Employer ESI:</strong>
                        ₹<?php echo e($staff->salary->employer_esi); ?>

                    </div>
                </div>

            <?php else: ?>
                <p class="text-muted mb-0">Salary details not available.</p>
            <?php endif; ?>
        </div>
    </div>

    
    <div class="card mb-3">
        <div class="card-header bg-light">
            <strong>Bank Details</strong>
        </div>
        <div class="card-body">
            <?php if($staff->bankDetails): ?>
                <div class="row mb-2">
                    <div class="col-md-4"><strong>Bank:</strong> <?php echo e($staff->bankDetails->bank_name); ?></div>
                    <div class="col-md-4"><strong>Branch:</strong> <?php echo e($staff->bankDetails->branch_name); ?></div>
                    <div class="col-md-4"><strong>IFSC:</strong> <?php echo e($staff->bankDetails->ifsc_code); ?></div>
                </div>

                <div class="row">
                    <div class="col-md-6"><strong>Account No:</strong> <?php echo e($staff->bankDetails->acc_no); ?></div>
                </div>

                <div class="row">
                    <div class="col-md-6"><strong>Account Holder:</strong> <?php echo e($staff->bankDetails->acc_holder_name); ?></div>
                </div>
            <?php else: ?>
                <p class="text-muted mb-0">Bank details not available.</p>
            <?php endif; ?>
        </div>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/school-ramkrishna/resources/views/staff/show.blade.php ENDPATH**/ ?>