<div class="card mb-5">
    <div class="card-header bg-light">
        <h5 class="mb-0">Bulk Upload Students</h5>
    </div>

    <div class="card-body">
        <div class="alert alert-info">
            <strong>Note:</strong> Upload Excel file with student data.
        </div>

        <div class="mb-3">
            <!-- <a href="<?php echo e(route('students.bulk.template.csv')); ?>" class="btn btn-outline-secondary">
                Download CSV Template
            </a> -->
            <a href="<?php echo e(route('students.bulk.template.excel')); ?>" class="btn btn-outline-secondary">
                Download Excel Template
            </a>
        </div>

        
        <form method="POST"
              action="<?php echo e(route('students.bulk.upload')); ?>"
              enctype="multipart/form-data">

            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-md-3">
                    <label class="form-label">Academic Year *</label>
                    <select name="financial_year_id" class="form-select" required>
                        <?php $__currentLoopData = $academic_years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($year->id); ?>"
                                <?php echo e(old('financial_year','2025-2026') ==
                                ($year->label) ? 'selected' : ''); ?>>
                                <?php echo e($year->label); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['financial_year_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="col-md-3 mb-2">
                    <label class="form-label">Select Class *</label>
                    <select name="class_id" id="blk_class_id" class="form-select form-select-sm" required>
                        <option value="">Select Class</option>
                        <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($class->id); ?>"
                                <?php echo e(request('class_id') == $class->id ? 'selected' : ''); ?>>
                                <?php echo e($class->class_name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['class_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="col-md-3 mb-2">
                    <label class="form-label">Select Section *</label>
                    <select name="section_id" id="blk_section_id" class="form-select form-select-sm"
                            <?php echo e(request('class_id') ? '' : 'disabled'); ?> required>
                        <option value="">All Sections</option>

                        
                        <?php if(request('class_id')): ?>
                            <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($section->id); ?>"
                                    <?php echo e(request('section_id') == $section->id ? 'selected' : ''); ?>>
                                    <?php echo e($section->section_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                    <?php $__errorArgs = ['section_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="col-md-3 mb-2">
                    <label class="form-label">Select File *</label>
                    <input type="file"
                            name="file"
                            class="form-control"
                            accept=".csv,.xlsx,.xls"
                            required>
                    <?php $__errorArgs = ['section_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="col-md-4">
                <button type="submit" class="btn btn-primary btn-lg">
                    Upload & Start Processing
                </button>
            </div>
        </form>
        
    </div>
</div>

<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Student Bulk Upload History</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Total Rows</th>
                        <th>Processed</th>
                        <th>Status</th>
                        <th>Progress</th>
                        <th>Failed</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $uploads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $upload): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($upload->id); ?></td>
                        <td><?php echo e($upload->total_rows); ?></td>
                        <td><?php echo e($upload->processed_rows); ?></td>
                        <td>
                            
                            <?php if($upload->status === 'completed_with_errors'): ?>
                                <span class="badge bg-danger">Completed With Error</span>
                            <?php elseif($upload->status === 'completed'): ?>
                                <span class="badge bg-success">Completed</span>
                            <?php elseif($upload->status === 'running'): ?>
                                <span class="badge bg-warning">Running</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Pending</span>
                            <?php endif; ?>
                        </td>
                        <td style="width: 200px">
                            <div class="progress">
                                <div class="progress-bar"
                                    role="progressbar"
                                    style="width: <?php echo e($upload->progress); ?>%">
                                    <?php echo e($upload->progress); ?>%
                                </div>
                            </div>
                        </td>
                        <td>
                            <?php if($upload->failed > 0): ?>
                                <span class="text-danger fw-bold">
                                    <?php echo e($upload->failed); ?>

                                </span>
                            <?php else: ?>
                                0
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($upload->failed > 0): ?>
                                <a href="<?php echo e(route('students.failed.export', $upload->id)); ?>"
                                class="btn btn-danger btn-sm">
                                    Download Failed
                                </a>
                            <?php else: ?>
                                <span class="text-muted">—</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center text-muted">
                            No bulk uploads found.
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div><?php /**PATH /var/www/html/school-ramkrishna/resources/views/students/bluk.blade.php ENDPATH**/ ?>