<div class="card mb-4">
    <div class="card-header bg-light">
        <h5 class="mb-0">Search</h5>
    </div>
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('fees.index')); ?>">
            <div class="row mb-3">
                <div class="col-md-4">
                    <label class="form-label">Select Class *</label>
                    <select name="class_id" class="form-select" required>
                        <option value="">Select Class</option>
                        <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($class->id); ?>" <?php echo e((request('class_id')==$class->id)?'selected':''); ?>>
                                <?php echo e($class->class_name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Academic Year *</label>
                    <select name="financial_year_id" class="form-select" required>
                        <?php $__currentLoopData = $academic_years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($year->id); ?>" <?php echo e(request('financial_year_id', $active_academic_year->id) == $year->id ? 'selected' : ''); ?>>
                                <?php echo e($year->label); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <!-- <div class="col-md-4">
                    <label class="form-label">Due Date</label>
                    <input type="date" name="due_date" class="form-control" value="<?php echo e(request('due_date')); ?>">
                </div> -->
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">Load Configuration</button>
                <a href="<?php echo e(url()->current()); ?>"
                    class="btn btn-outline-secondary">
                        Clear Filter
                    </a>
                </div>
        </form>
    </div>
</div>

<div class="card mb-4">
    <div class="card-header bg-light">
        <h5 class="mb-0">Calss Fee Heads List</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-sm">
                <thead>
                    <tr>
                        <th>Fee Head Name</th>
                        <th>Amount</th>
                        <th>Fee Type</th>
                        <th>Due Day/Date</th>
                        <th>Late Fee</th>
                        <th>Class</th>
                        <th>Academic Year</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $classFees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr
                        data-id="<?php echo e($fee->id); ?>"
                        data-class-id="<?php echo e($fee->class_id); ?>"
                        data-fee-head-id="<?php echo e($fee->fee_head_id); ?>"
                        data-financial-year-id="<?php echo e($fee->financial_year_id); ?>"
                        data-amount="<?php echo e($fee->amount); ?>"
                        data-late_fee_amount="<?php echo e($fee->late_fee_amount); ?>"
                        data-fee-type="<?php echo e($fee->fee_type); ?>"
                        data-due-day="<?php echo e($fee->fee_type === 'recurring' ? $fee->due_day_of_month : ''); ?>"
                        data-due-date="<?php echo e($fee->fee_type === 'one_time' ? $fee->due_date : ''); ?>"
                    >
                        <!-- Fee Head -->
                        <td><?php echo e($fee->feeHead->name); ?></td>

                        <!-- Amount -->
                        <td>₹<?php echo e(number_format($fee->amount, 2)); ?></td>

                        <!-- Type -->
                        <td>
                            <span class="badge <?php echo e($fee->fee_type === 'recurring' ? 'bg-info' : 'bg-secondary'); ?>">
                                <?php echo e(ucfirst(str_replace('_', ' ', $fee->fee_type))); ?>

                            </span>
                        </td>

                        <!-- Due -->
                        <td>
                            <?php if($fee->fee_type === 'recurring'): ?>
                                Day <?php echo e($fee->due_day_of_month); ?>

                            <?php else: ?>
                                <?php echo e(\Carbon\Carbon::parse($fee->due_date)->format('d M Y')); ?>

                            <?php endif; ?>
                        </td>

                        <!-- late Fee -->
                        <td><?php echo e($fee->late_fee_amount); ?></td>

                        <!-- Class -->
                        <td><?php echo e($fee->class->class_name); ?></td>

                        <!-- Academic Year -->
                        <td><?php echo e($fee->financialYear->label); ?></td>

                        <!-- Status -->
                        <td>
                            <div class="form-check form-switch">
                                <input
                                    class="form-check-input fee-status"
                                    type="checkbox"
                                    data-id="<?php echo e($fee->id); ?>"
                                    data-url="<?php echo e(route('fees.updateClassFee', $fee->id)); ?>"
                                    <?php echo e($fee->status ? 'checked' : ''); ?>

                                >
                            </div>
                        </td>

                        <!-- Actions -->
                        <td>
                            <!-- Edit -->
                            <button
                                type="button"
                                class="btn btn-sm btn-outline-primary editClassFeeBtn"
                                data-url="<?php echo e(route('fees.updateClassFee', $fee->id)); ?>"
                            >
                                Edit
                            </button>

                            <!-- Delete -->
                            <button
                                type="button"
                                class="btn btn-sm btn-outline-danger deleteClassFeeBtn"
                                data-url="<?php echo e(route('fees.deleteClassFee', $fee->id)); ?>"
                            >
                                Delete
                            </button>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center text-muted">
                                No fee head found for the current academic year and class
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="d-flex justify-content-end mt-3">
            <?php echo e($classFees->appends(['tab' => $tab])->links()); ?>

        </div>
    </div>
</div>

<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Config Class Fee Head</h5>
    </div>
    <div class="card-body">
        <form method="POST" action="<?php echo e(route('fees.storeClassFee')); ?>">
            <?php echo csrf_field(); ?>

            <div class="row mb-2">

                <!-- Fee Head -->
                <div class="col-md-2">
                    <select name="fee_head_id" class="form-select" required>
                        <option value="">Select Fee Head</option>
                        <?php $__currentLoopData = $feeHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $heads): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($heads->status): ?>
                                <option value="<?php echo e($heads->id); ?>"><?php echo e($heads->name); ?></option>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Amount -->
                <div class="col-md-2">
                    <input type="number" name="amount" class="form-control" placeholder="Amount (₹)" required>
                </div>

                <!-- Fee Type -->
                <div class="col-md-2">
                    <select name="fee_type" class="form-select" id="fee_type" required>
                        <option value="recurring">Recurring</option>
                        <option value="one_time">One Time</option>
                    </select>
                </div>


                <!-- Financial Year -->
                <div class="col-md-2">
                    <select name="financial_year_id" class="form-select" required>
                        <?php $__currentLoopData = $academic_years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($year->id); ?>"
                                <?php echo e(request('financial_year_id', $active_academic_year->id) == $year->id ? 'selected' : ''); ?>>
                                <?php echo e($year->label); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Class -->
                <div class="col-md-2">
                    <select name="class_id" class="form-select" required>
                        <option value="all">All Classes</option>
                        <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($class->id); ?>"><?php echo e($class->class_name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Due Date -->
                <div class="col-md-2 d-none" id="due_date_wrapper">
                    <input type="date" id="due_date" name="due_date" class="form-control">
                </div>

                <div class="col-md-2" id="due_day_wrapper">
                    <select name="due_day_of_month" class="form-select">
                        <option value="">Due Day</option>
                        <?php for($i = 1; $i <= 15; $i++): ?>
                            <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                        <?php endfor; ?>
                    </select>
                </div>

            </div>
            <div class="row mb-2">
                <!-- Amount -->
                <div class="col-md-2">
                    <input type="number" name="late_fee_amount" class="form-control" placeholder="Late Fee (₹)">
                </div>
            </div>

            <button class="btn btn-primary">Add</button>
        </form>

    </div>
</div>
<?php /**PATH /var/www/html/school-ramkrishna/resources/views/fees/config.blade.php ENDPATH**/ ?>