<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StudentClassDetail extends Model
{
    protected $table = 'student_class_details';
    protected $fillable = ['student_id','roll_no','class_id','section_id','session_id','financial_year_id','status','start_date','end_date'];

    public function student()
    {
        return $this->belongsTo(Student::class, 'student_id');
    }

    public function class()
    {
        return $this->belongsTo(SchoolClass::class, 'class_id');
    }

    public function section()
    {
        return $this->belongsTo(SchoolSection::class, 'section_id');
    }

    public function session()
    {
        return $this->belongsTo(SchoolSession::class, 'session_id');
    }

    public function financialYear()
    {
        return $this->belongsTo(AcademicYear::class, 'financial_year_id');
    }
}
