@extends('layouts.app')

@section('title', 'Staff')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('staff.index') }}">Staff</a></li>
    <li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')

<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Edit Staff Member</h5>
    </div>

    <div class="card-body">

        {{-- GLOBAL ERRORS --}}
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form method="POST"
              action="{{ route('staff.update', $staff->id) }}"
              enctype="multipart/form-data">
            @csrf
            @method('PUT')

            {{-- ================= PERSONAL INFO ================= --}}
            <h6 class="mb-3 text-muted">Personal Information</h6>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Full Name *</label>
                    <input type="text" name="name"
                        class="form-control @error('name') is-invalid @enderror"
                        value="{{ old('name', $staff->name) }}" required>
                    @error('name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-6">
                    <label>Email *</label>
                    <input type="email" name="email"
                        class="form-control @error('email') is-invalid @enderror"
                        value="{{ old('email', $staff->email) }}" required>
                    @error('email')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Photo</label>
                    <input type="file" name="photo"
                        class="form-control @error('photo') is-invalid @enderror"
                        accept="image/*">
                    <small class="text-muted">Leave blank to keep existing photo</small>
                    @error('photo')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6">
                    <label>Phone *</label>
                    <input type="tel" name="phone" maxlength="10"
                        class="form-control @error('phone') is-invalid @enderror"
                        value="{{ old('phone', $staff->phone) }}" required>
                    @error('phone')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6">
                    @if($staff->photo)
                        <div class="mb-2">
                            <img
                                src="{{ asset('storage/'.$staff->photo) }}"
                                alt="Profile Photo"
                                class="img-thumbnail"
                                style="max-height:150px;">
                        </div>
                    @else
                        <p class="text-muted">No profile photo uploaded</p>
                    @endif
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-12">
                    <label>Address *</label>
                    <textarea name="address"
                        class="form-control @error('address') is-invalid @enderror"
                        required>{{ old('address', $staff->address) }}</textarea>
                    @error('address')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <hr>

            {{-- ================= EMPLOYMENT ================= --}}
            <h6 class="mb-3 text-muted">Employment Details</h6>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Category *</label>
                    <select name="category"
                        class="form-select @error('category') is-invalid @enderror" required>
                        <option value="">Select</option>
                        <option value="Teacher" {{ old('category',$staff->category)=='Teacher'?'selected':'' }}>Teacher</option>
                        <option value="Non-Teacher" {{ old('category',$staff->category)=='Non-Teacher'?'selected':'' }}>Non-Teacher</option>
                    </select>
                    @error('category')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-6">
                    <label>Designation *</label>
                    <input type="text" name="designation"
                        class="form-control @error('designation') is-invalid @enderror"
                        value="{{ old('designation', $staff->designation) }}" required>
                    @error('designation')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Qualification *</label>
                    <input type="text" name="qualification"
                        class="form-control @error('qualification') is-invalid @enderror"
                        value="{{ old('qualification', $staff->qualification) }}" required>
                    @error('qualification')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-6">
                    <label>Joining Date *</label>
                    <input type="date" name="join_date"
                        class="form-control @error('join_date') is-invalid @enderror"
                        value="{{ old('join_date', $staff->join_date) }}" required>
                    @error('join_date')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <hr>

            {{-- ================= SALARY ================= --}}
            @php $salary = $staff->salary; @endphp

            <h6 class="mb-3 text-muted">Salary – Earnings</h6>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label>Basic *</label>
                    <input type="number" name="basic" step="0.01" min="0"
                        class="form-control @error('basic') is-invalid @enderror"
                        value="{{ old('basic', $salary->basic ?? 0) }}" required>
                    @error('basic')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>DA</label>
                    <input type="number" name="da" step="0.01" min="0"
                        class="form-control @error('da') is-invalid @enderror"
                        value="{{ old('da', $salary->da ?? 0) }}">
                    @error('da')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>TA</label>
                    <input type="number" name="ta" step="0.01" min="0"
                        class="form-control @error('ta') is-invalid @enderror"
                        value="{{ old('ta', $salary->ta ?? 0) }}">
                    @error('ta')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label>HRA</label>
                    <input type="number" name="hra" step="0.01" min="0"
                        class="form-control @error('hra') is-invalid @enderror"
                        value="{{ old('hra', $salary->hra ?? 0) }}">
                    @error('hra')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>Medical Allowance</label>
                    <input type="number" name="medical_allowance" step="0.01" min="0"
                        class="form-control @error('medical_allowance') is-invalid @enderror"
                        value="{{ old('medical_allowance', $salary->medical_allowance ?? 0) }}">
                    @error('medical_allowance')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>Washing Allowance</label>
                    <input type="number" name="washing_allowance" step="0.01" min="0"
                        class="form-control @error('washing_allowance') is-invalid @enderror"
                        value="{{ old('washing_allowance', $salary->washing_allowance ?? 0) }}">
                    @error('washing_allowance')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label>Conveyance</label>
                    <input type="number" name="conveyance" step="0.01" min="0"
                        class="form-control @error('conveyance') is-invalid @enderror"
                        value="{{ old('conveyance', $salary->conveyance ?? 0) }}">
                    @error('conveyance')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>Special Allowance</label>
                    <input type="number" name="special_allowance" step="0.01" min="0"
                        class="form-control @error('special_allowance') is-invalid @enderror"
                        value="{{ old('special_allowance', $salary->special_allowance ?? 0) }}">
                    @error('special_allowance')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <h6 class="mb-3 text-muted mt-4">Salary – Deductions</h6>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label>PF</label>
                    <input type="number" name="pf" step="0.01" min="0"
                        class="form-control @error('pf') is-invalid @enderror"
                        value="{{ old('pf', $salary->pf ?? 0) }}">
                    @error('pf')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>ESI</label>
                    <input type="number" name="esi" step="0.01" min="0"
                        class="form-control @error('esi') is-invalid @enderror"
                        value="{{ old('esi', $salary->esi ?? 0) }}">
                    @error('esi')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>Professional Tax</label>
                    <input type="number" name="p_tax" step="0.01" min="0"
                        class="form-control @error('p_tax') is-invalid @enderror"
                        value="{{ old('p_tax', $salary->p_tax ?? 0) }}">
                    @error('p_tax')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label>TDS</label>
                    <input type="number" name="tds" step="0.01" min="0"
                        class="form-control @error('tds') is-invalid @enderror"
                        value="{{ old('tds', $salary->tds ?? 0) }}">
                    @error('tds')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>Other Deduction</label>
                    <input type="number" name="others_deduction" step="0.01" min="0"
                        class="form-control @error('others_deduction') is-invalid @enderror"
                        value="{{ old('others_deduction', $salary->others_deduction ?? 0) }}">
                    @error('others_deduction')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <h6 class="mb-3 text-muted mt-4">Employer Contribution</h6>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label>Employer PF</label>
                    <input type="number" name="employer_pf" step="0.01" min="0"
                        class="form-control @error('employer_pf') is-invalid @enderror"
                        value="{{ old('employer_pf', $salary->employer_pf ?? 0) }}">
                    @error('employer_pf')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>Employer ESI</label>
                    <input type="number" name="employer_esi" step="0.01" min="0"
                        class="form-control @error('employer_esi') is-invalid @enderror"
                        value="{{ old('employer_esi', $salary->employer_esi ?? 0) }}">
                    @error('employer_esi')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>Financial Year *</label>
                    <select name="financial_year_id"
                        class="form-select @error('financial_year_id') is-invalid @enderror" required>
                        <option value="">Select</option>
                        @foreach($academic_years as $year)
                            <option value="{{ $year->id }}"
                                {{ old('financial_year_id', $salary->financial_year_id ?? '') == $year->id ? 'selected' : '' }}>
                                {{ $year->label }}
                            </option>
                        @endforeach
                    </select>
                    @error('financial_year_id')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <hr>

            {{-- ================= BANK ================= --}}
            @php $bank = $staff->bankDetails; @endphp

            <h6 class="mb-3 text-muted">Bank Details</h6>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Bank Name *</label>
                    <input type="text" name="bank_name"
                        class="form-control @error('bank_name') is-invalid @enderror"
                        value="{{ old('bank_name', $bank->bank_name ?? '') }}" required>
                    @error('bank_name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-6">
                    <label>Branch Name *</label>
                    <input type="text" name="branch_name"
                        class="form-control @error('branch_name') is-invalid @enderror"
                        value="{{ old('branch_name', $bank->branch_name ?? '') }}" required>
                    @error('branch_name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Account Number *</label>
                    <input type="text" name="account_no"
                        class="form-control @error('account_no') is-invalid @enderror"
                        value="{{ old('account_no', $bank->acc_no ?? '') }}" required>
                    @error('account_no')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-6">
                    <label>Account Holder *</label>
                    <input type="text" name="account_holder"
                        class="form-control @error('account_holder') is-invalid @enderror"
                        value="{{ old('account_holder', $bank->acc_holder_name ?? '') }}" required>
                    @error('account_holder')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>IFSC Code *</label>
                    <input type="text" name="ifsc"
                        class="form-control @error('ifsc') is-invalid @enderror"
                        value="{{ old('ifsc', $bank->ifsc_code ?? '') }}" required>
                    @error('ifsc')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="d-flex justify-content-end gap-2">
                <button class="btn btn-primary btn-sm">Update Staff</button>
                <a href="{{ route('staff.index') }}" class="btn btn-secondary btn-sm">Cancel</a>
            </div>

        </form>
    </div>
</div>

@endsection
