

<?php $__env->startSection('title', 'Students'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('students.index')); ?>">Students</a></li>
    <li class="breadcrumb-item active">Edit</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php
        // Get current active class detail
        $currentClass = $student->classDetails->first();
    ?>

    <div id="students-page" class="page-content">
        <h1 class="mb-4">Student Management</h1>
        <div class="card">
            <div class="card-header bg-light">
                <h5 class="mb-0">Edit Student</h5>
            </div>

            <div class="card-body">

                
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <strong>Please fix the following errors:</strong>
                        <ul class="mb-0">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form method="POST" action="<?php echo e(route('students.update', $student->id)); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    
                    <h6 class="text-muted mb-3">Personal Information</h6>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label>Full Name *</label>
                            <input type="text" name="name" value="<?php echo e(old('name', $student->name)); ?>"
                                class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Date of Birth</label>
                            <input type="date" name="dob" value="<?php echo e(old('dob', $student->dob)); ?>"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Gender</label>
                            <select name="gender" class="form-select">
                                <option value="">Select</option>
                                <?php $__currentLoopData = ['Male', 'Female', 'Other']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($g); ?>"
                                        <?php echo e(old('gender', $student->gender) == $g ? 'selected' : ''); ?>>
                                        <?php echo e($g); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Nationality</label>
                            <input type="text" name="nationality" value="<?php echo e(old('nationality', $student->nationality)); ?>"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Mother Tongue</label>
                            <input type="text" name="mother_tongue"
                                value="<?php echo e(old('mother_tongue', $student->mother_tongue)); ?>" class="form-control">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Category *</label>
                            <select name="category" class="form-select">
                                <?php $__currentLoopData = ['GEN', 'OBC', 'SC', 'ST']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($cat); ?>"
                                        <?php echo e(old('category', $student->category) == $cat ? 'selected' : ''); ?>>
                                        <?php echo e($cat); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label>Caste *</label>
                            <input type="text" name="cast" value="<?php echo e(old('cast', $student->cast)); ?>"
                                class="form-control">
                        </div>
                    </div>

                    
                    <h6 class="text-muted mt-4 mb-3">Address</h6>

                    <div class="mb-3">
                        <label>Permanent Address *</label>
                        <textarea name="address" rows="2" class="form-control"><?php echo e(old('address', $student->address)); ?></textarea>
                    </div>

                    <div class="mb-3">
                        <label>Local Address *</label>
                        <textarea name="local_address" rows="2" class="form-control"><?php echo e(old('local_address', $student->local_address)); ?></textarea>
                    </div>

                    
                    <h6 class="text-muted mt-4 mb-3">Additional Information</h6>

                    <div class="row mb-3">
                        <div class="col-md-4 form-check">
                            <input type="checkbox" name="belongs_to_minority_group" value="1" class="form-check-input"
                                <?php echo e(old('belongs_to_minority_group', $student->belongs_to_minority_group) ? 'checked' : ''); ?>>
                            <label class="form-check-label">Minority</label>
                        </div>

                        <div class="col-md-4 form-check">
                            <input type="checkbox" name="is_disability_ph" value="1" class="form-check-input"
                                <?php echo e(old('is_disability_ph', $student->is_disability_ph) ? 'checked' : ''); ?>>
                            <label class="form-check-label">PH</label>
                        </div>

                        <div class="col-md-4 form-check">
                            <input type="checkbox" name="is_transport_required" value="1" class="form-check-input"
                                <?php echo e(old('is_transport_required', $student->is_transport_required) ? 'checked' : ''); ?>>
                            <label class="form-check-label">Transport</label>
                        </div>
                    </div>

                    
                    <h6 class="text-muted mt-4 mb-3">Class Assignment</h6>

                    <div class="row mb-3">
                        <div class="col-md-3">
                            <label>Class *</label>
                            <select name="class_id" class="form-select">
                                <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($class->id); ?>"
                                        <?php echo e(old('class_id', $currentClass?->class_id) == $class->id ? 'selected' : ''); ?>>
                                        <?php echo e($class->class_name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['class_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-3">
                            <label>Section *</label>
                            <select name="section_id" class="form-select">
                                <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($class->id == old('class_id', $currentClass?->class_id)): ?>
                                        <?php $__currentLoopData = $class->sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($section->id); ?>"
                                                <?php echo e(old('section_id', $currentClass?->section_id) == $section->id ? 'selected' : ''); ?>>
                                                <?php echo e($section->section_name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['section_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-3">
                            <label>Session *</label>
                            <select name="session_id" class="form-select <?php $__errorArgs = ['session_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <option value="">Select Session</option>
                                <?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($sec->id); ?>" <?php echo e(old('session_id',$currentClass?->session_id) == ($sec->id) ? 'selected' : ''); ?>><?php echo e($sec->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['session_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-3">
                            <label>Academic Year *</label>
                            <select name="financial_year_id" class="form-select">
                                <?php $__currentLoopData = $academicYears; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($year->id); ?>"
                                        <?php echo e(old('financial_year_id', $currentClass?->finalcial_year_id) == $year->id ? 'selected' : ''); ?>>
                                        <?php echo e($year->label); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    
                    <h6 class="text-muted mt-4 mb-3">Parent / Guardian Details</h6>

                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Name *</label>
                            <input type="text" name="father_name"
                                value="<?php echo e(old('father_name', $student->parent->father_name)); ?>"
                                class="form-control <?php $__errorArgs = ['father_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <?php $__errorArgs = ['father_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label>Mother Name *</label>
                            <input type="text" name="mother_name"
                                value="<?php echo e(old('mother_name', $student->parent->mother_name)); ?>"
                                class="form-control <?php $__errorArgs = ['mother_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <?php $__errorArgs = ['mother_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Qualification</label>
                            <input type="text" name="father_qualification"
                                value="<?php echo e(old('father_qualification', $student->parent->father_qualification)); ?>"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Mother Qualification</label>
                            <input type="text" name="mother_qualification"
                                value="<?php echo e(old('mother_qualification', $student->parent->mother_qualification)); ?>"
                                class="form-control">
                        </div>
                    </div>

                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Occupation *</label>
                            <input type="text" name="father_occupation"
                                value="<?php echo e(old('father_occupation', $student->parent->father_occupation)); ?>"
                                class="form-control <?php $__errorArgs = ['father_occupation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <?php $__errorArgs = ['father_occupation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label>Mother Occupation *</label>
                            <input type="text" name="mother_occupation"
                                value="<?php echo e(old('mother_occupation', $student->parent->mother_occupation)); ?>"
                                class="form-control <?php $__errorArgs = ['mother_occupation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <?php $__errorArgs = ['mother_occupation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Phone *</label>
                            <input type="tel" name="father_phone" maxlength="10" pattern="[0-9]{10}"
                                value="<?php echo e(old('father_phone', $student->parent->father_phone)); ?>"
                                class="form-control <?php $__errorArgs = ['father_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <?php $__errorArgs = ['father_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label>Mother Phone *</label>
                            <input type="tel" name="mother_phone" maxlength="10" pattern="[0-9]{10}"
                                value="<?php echo e(old('mother_phone', $student->parent->mother_phone)); ?>"
                                class="form-control <?php $__errorArgs = ['mother_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <?php $__errorArgs = ['mother_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    
                    <!-- <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Voter ID</label>
                            <input type="text" name="father_voter_id"
                                value="<?php echo e(old('father_voter_id', $student->parent->father_voter_id)); ?>"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Mother Voter ID</label>
                            <input type="text" name="mother_voter_id"
                                value="<?php echo e(old('mother_voter_id', $student->parent->mother_voter_id)); ?>"
                                class="form-control">
                        </div>
                    </div> -->

                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Guardian Name</label>
                            <input type="text" name="guardian_name"
                                value="<?php echo e(old('guardian_name', $student->parent->guardian_name)); ?>" class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Guardian Phone</label>
                            <input type="tel" name="guardian_phone" maxlength="10" pattern="[0-9]{10}"
                                value="<?php echo e(old('guardian_phone', $student->parent->guardian_phone)); ?>"
                                class="form-control <?php $__errorArgs = ['guardian_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <?php $__errorArgs = ['guardian_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label>Guardian Address</label>
                        <textarea name="guardian_address" rows="2" class="form-control"><?php echo e(old('guardian_address', $student->parent->guardian_address)); ?></textarea>
                    </div>

                    
                    <h6 class="text-muted mt-4 mb-3">Documents</h6>

                    <div class="row mb-3">

                        
                        <div class="col-md-6">
                            <label class="form-label">Profile Photo</label>

                            <?php if($student->profile_image): ?>
                                <div class="mb-2">
                                    <img
                                        src="<?php echo e(asset('storage/'.$student->profile_image)); ?>"
                                        alt="Profile Photo"
                                        class="img-thumbnail"
                                        style="max-height:150px;">
                                </div>
                            <?php else: ?>
                                <p class="text-muted">No profile photo uploaded</p>
                            <?php endif; ?>

                            <input type="file" name="profile_image" class="form-control">
                            <small class="text-muted">Leave empty to keep existing photo</small>
                        </div>

                        
                        <div class="col-md-6">
                            <label class="form-label">DOB Proof</label>

                            <?php if($student->dob_photo_copy): ?>
                                <div class="mb-2">
                                    <?php
                                        $ext = pathinfo($student->dob_photo_copy, PATHINFO_EXTENSION);
                                    ?>

                                    <?php if(in_array(strtolower($ext), ['jpg','jpeg','png','webp'])): ?>
                                        <img
                                            src="<?php echo e(asset('storage/'.$student->dob_photo_copy)); ?>"
                                            alt="DOB Proof"
                                            class="img-thumbnail"
                                            style="max-height:150px;">
                                    <?php else: ?>
                                        <a href="<?php echo e(asset('storage/'.$student->dob_photo_copy)); ?>"
                                        target="_blank"
                                        class="btn btn-sm btn-outline-primary">
                                            View / Download DOB Proof
                                        </a>
                                    <?php endif; ?>
                                </div>
                            <?php else: ?>
                                <p class="text-muted">No DOB proof uploaded</p>
                            <?php endif; ?>

                            <input type="file" name="dob_photo_copy" class="form-control">
                            <small class="text-muted">Leave empty to keep existing document</small>
                        </div>

                    </div>

                    <div class="d-flex gap-2 justify-content-end mt-3">
                        <button type="submit" class="btn btn-primary btn-sm">
                            Update Student
                        </button>

                        <a href="<?php echo e(route('students.index')); ?>" class="btn btn-secondary btn-sm">
                            Cancel
                        </a>
                    </div>

                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\school\resources\views/students/edit.blade.php ENDPATH**/ ?>