<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Student extends Model
{
    protected $fillable = [
        'name','admission_no','dob','gender','address','local_address',
        'nationality','mother_tongue','parent_id','profile_image',
        'dob_photo_copy','category','cast',
        'belongs_to_minority_group','is_disability_ph',
        'is_transport_required','status'
    ];


    public function parent()
    {
        return $this->belongsTo(ParentModel::class, 'parent_id');
    }

    public function classDetails()
    {
        return $this->hasMany(StudentClassDetail::class, 'student_id');
    }

    public function monthlyFees()
    {
        return $this->hasMany(StudentMonthlyFee::class, 'student_id');
    }

    public function activeClass()
    {
        return $this->hasOne(StudentClassDetail::class, 'student_id')->where('status', 1);
    }

    public function class()
    {
        return $this->hasOne(StudentClassDetail::class, 'student_id')->where('status', 1);
    }

    public function section()
    {
        return $this->belongsTo(StudentClassDetail::class, 'section_id');
    }

}
