@extends('layouts.app')

@section('title', 'Staff')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('staff.index') }}">Staff</a></li>
    <li class="breadcrumb-item active">Details</li>
@endsection

@section('content')
<div class="container-fluid">

    <div class="d-flex justify-content-between mb-3">
        <h4 class="mb-0">Staff Details</h4>
        <a href="{{ route('staff.index') }}" class="btn btn-secondary btn-sm">
            Back
        </a>
    </div>

    {{-- ================= PERSONAL INFO ================= --}}
    <div class="card mb-3">
        <div class="card-header bg-light">
            <strong>Personal Information</strong>
        </div>
        <div class="card-body">
            <div class="row mb-2">
                <div class="col-md-4"><strong>Name:</strong> {{ $staff->name }}</div>
                <div class="col-md-4"><strong>Email:</strong> {{ $staff->email ?? '-' }}</div>
                <div class="col-md-4"><strong>Phone:</strong> {{ $staff->phone }}</div>
            </div>

            <div class="row mb-2">
                <div class="col-md-6"><strong>Address:</strong> {{ $staff->address ?? '-' }}</div>
                <!-- <div class="col-md-3">
                    <strong>Status:</strong>
                    @if($staff->status)
                        <span class="badge bg-success">Active</span>
                    @else
                        <span class="badge bg-secondary">Inactive</span>
                    @endif
                </div> -->
            </div>
        </div>
    </div>

    {{-- ================= EMPLOYMENT ================= --}}
    <div class="card mb-3">
        <div class="card-header bg-light">
            <strong>Employment Details</strong>
        </div>
        <div class="card-body">
            <div class="row mb-2">
                <div class="col-md-4"><strong>Category:</strong> {{ $staff->category }}</div>
                <div class="col-md-4"><strong>Designation:</strong> {{ $staff->designation }}</div>
                <div class="col-md-4"><strong>Qualification:</strong> {{ $staff->qualification }}</div>
            </div>

            <div class="row">
                <div class="col-md-4">
                    <strong>Joining Date:</strong>
                    {{ \Carbon\Carbon::parse($staff->joining_date)->format('d M Y') }}
                </div>
            </div>
        </div>
    </div>

    {{-- ================= SALARY ================= --}}
    <div class="card mb-3">
        <div class="card-header bg-light">
            <strong>Salary Details</strong>
        </div>
        <div class="card-body">

            @if($staff->salary)

                <h6 class="text-muted">Earnings</h6>
                <div class="row mb-2">
                    <div class="col-md-3">Basic: ₹{{ $staff->salary->basic }}</div>
                    <div class="col-md-3">HRA: ₹{{ $staff->salary->hra }}</div>
                    <div class="col-md-3">DA: ₹{{ $staff->salary->da }}</div>
                    <div class="col-md-3">TA: ₹{{ $staff->salary->ta }}</div>
                </div>

                <div class="row mb-2">
                    <div class="col-md-3">Medical: ₹{{ $staff->salary->medical_allowance }}</div>
                    <div class="col-md-3">Conveyance: ₹{{ $staff->salary->conveyance }}</div>
                    <div class="col-md-3">Washing: ₹{{ $staff->salary->washing_allowance }}</div>
                    <div class="col-md-3">Special: ₹{{ $staff->salary->special_allowance }}</div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-4">
                        <strong>Total Earnings:</strong>
                        ₹{{ $staff->salary->total_earnings }}
                    </div>
                </div>

                <hr>

                <h6 class="text-muted">Deductions</h6>
                <div class="row mb-2">
                    <div class="col-md-3">PF: ₹{{ $staff->salary->pf }}</div>
                    <div class="col-md-3">ESI: ₹{{ $staff->salary->esi }}</div>
                    <div class="col-md-3">P-Tax: ₹{{ $staff->salary->p_tax }}</div>
                    <div class="col-md-3">TDS: ₹{{ $staff->salary->tds }}</div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-4">
                        <strong>Total Deductions:</strong>
                        ₹{{ $staff->salary->total_deductions }}
                    </div>
                </div>

                <hr>

                <div class="row mb-2">
                    <div class="col-md-4">
                        <strong>Net Salary:</strong>
                        ₹{{ $staff->salary->net_salary }}
                    </div>
                    <div class="col-md-4">
                        <strong>Employer PF:</strong>
                        ₹{{ $staff->salary->employer_pf }}
                    </div>
                    <div class="col-md-4">
                        <strong>Financial Year:</strong>
                        {{ $staff->salary->financialYear->label }}
                    </div>
                   
                </div>

                <div class="row">
                    <div class="col-md-4">
                        <strong>CTC:</strong>
                        ₹{{ $staff->salary->ctc }}
                    </div>
                     <div class="col-md-4">
                        <strong>Employer ESI:</strong>
                        ₹{{ $staff->salary->employer_esi }}
                    </div>
                </div>

            @else
                <p class="text-muted mb-0">Salary details not available.</p>
            @endif
        </div>
    </div>

    {{-- ================= BANK ================= --}}
    <div class="card mb-3">
        <div class="card-header bg-light">
            <strong>Bank Details</strong>
        </div>
        <div class="card-body">
            @if($staff->bankDetails)
                <div class="row mb-2">
                    <div class="col-md-4"><strong>Bank:</strong> {{ $staff->bankDetails->bank_name }}</div>
                    <div class="col-md-4"><strong>Branch:</strong> {{ $staff->bankDetails->branch_name }}</div>
                    <div class="col-md-4"><strong>IFSC:</strong> {{ $staff->bankDetails->ifsc_code }}</div>
                </div>

                <div class="row">
                    <div class="col-md-6"><strong>Account No:</strong> {{ $staff->bankDetails->acc_no }}</div>
                </div>

                <div class="row">
                    <div class="col-md-6"><strong>Account Holder:</strong> {{ $staff->bankDetails->acc_holder_name }}</div>
                </div>
            @else
                <p class="text-muted mb-0">Bank details not available.</p>
            @endif
        </div>
    </div>

</div>
@endsection
