@extends('layouts.app')

@section('title', 'Students')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('students.index') }}">Students</a></li>
    <li class="breadcrumb-item active">Details</li>
@endsection

@section('content')
    @php
        // Get current active class detail
        $currentClass = $student->classDetails->first();
    @endphp

    <div id="students-page" class="page-content">
        <h1 class="mb-4">Student Management</h1>
        <div class="card">

            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Student Details</h5>

                <div class="d-flex gap-2">
                    <a href="{{ route('students.edit', $student->id) }}" class="btn btn-sm btn-primary">
                        Edit
                    </a>
                    <a href="{{ route('students.index') }}" class="btn btn-sm btn-secondary">
                        Back
                    </a>
                </div>
            </div>

            <div class="card-body">

                {{-- ================= PERSONAL INFO ================= --}}
                <h6 class="text-muted mb-3">Personal Information</h6>

                <div class="row mb-3">
                    <div class="col-md-6"><strong>Admission No:</strong> {{ $student->admission_no }}</div>
                    <div class="col-md-3"><strong>DOA:</strong> {{ $student->created_at }}</div>
                    <div class="col-md-3">
                        <strong>Status:</strong>
                        <span class="badge {{ $student->status ? 'bg-success':'bg-danger' }}">
                            {{ $student->status ? 'Active' : 'Inactive' }}
                        </span>
                    </div>
                </div>
                <div class="row mb-3">
                    
                    <div class="col-md-12"><strong>Name:</strong> {{ $student->name }}</div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-3"><strong>DOB:</strong> {{ $student->dob }}</div>
                    <div class="col-md-3"><strong>Gender:</strong> {{ $student->gender }}</div>
                    <div class="col-md-3"><strong>Nationality:</strong> {{ $student->nationality }}</div>
                    <div class="col-md-3"><strong>Mother Tongue:</strong> {{ $student->mother_tongue }}</div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-3"><strong>Category:</strong> {{ $student->category }}</div>
                    <div class="col-md-3"><strong>Caste:</strong> {{ $student->cast }}</div>
                    <div class="col-md-3"><strong>Minority:</strong> {{ $student->belongs_to_minority_group ? 'Yes':'No' }}</div>
                    <div class="col-md-3"><strong>PH:</strong> {{ $student->is_disability_ph ? 'Yes':'No' }}</div>
                </div>

                {{-- ================= ADDRESS ================= --}}
                <h6 class="text-muted mt-4 mb-3">Address</h6>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Permanent Address:</strong><br>
                        {{ $student->address }}
                    </div>
                    <div class="col-md-6">
                        <strong>Local Address:</strong><br>
                        {{ $student->local_address }}
                    </div>
                </div>

                {{-- ================= CLASS DETAILS ================= --}}
                <h6 class="text-muted mt-4 mb-3">Class Details</h6>

                @if($currentClass)
                <div class="row mb-3">
                    <div class="col-md-3"><strong>Class:</strong> {{ $currentClass->class->class_name }}</div>
                    <div class="col-md-3"><strong>Section:</strong> {{ $currentClass->section->section_name }}</div>
                    <div class="col-md-3"><strong>Roll No:</strong> {{ $currentClass->roll_no }}</div>
                    <div class="col-md-3">
                        <strong>Academic Year:</strong>
                        {{ $currentClass->financialYear->label }}
                    </div>
                </div>
                @endif

                {{-- ================= PARENT DETAILS ================= --}}
                <h6 class="text-muted mt-4 mb-3">Parent / Guardian Details</h6>

                <div class="row mb-3">
                    <div class="col-md-6"><strong>Father Name:</strong> {{ $student->parent->father_name }}</div>
                    <div class="col-md-6"><strong>Mother Name:</strong> {{ $student->parent->mother_name }}</div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6"><strong>Father Occupation:</strong> {{ $student->parent->father_occupation }}</div>
                    <div class="col-md-6"><strong>Mother Occupation:</strong> {{ $student->parent->mother_occupation }}</div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6"><strong>Father Phone:</strong> {{ $student->parent->father_phone }}</div>
                    <div class="col-md-6"><strong>Mother Phone:</strong> {{ $student->parent->mother_phone }}</div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6"><strong>Guardian Name:</strong> {{ $student->parent->guardian_name }}</div>
                    <div class="col-md-6"><strong>Guardian Phone:</strong> {{ $student->parent->guardian_phone }}</div>
                </div>

                <div class="mb-3">
                    <strong>Guardian Address:</strong><br>
                    {{ $student->parent->guardian_address }}
                </div>

                {{-- ================= DOCUMENTS ================= --}}
                <h6 class="text-muted mt-4 mb-3">Documents</h6>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <label><strong>Profile Photo</strong></label><br>
                        @if($student->profile_image)
                            <img src="{{ asset('storage/'.$student->profile_image) }}"
                                class="img-thumbnail"
                                style="max-height:150px;">
                        @else
                            <span class="text-muted">Not Uploaded</span>
                        @endif
                    </div>

                    <div class="col-md-6">
                        <label><strong>DOB Proof</strong></label><br>
                        @if($student->dob_photo_copy)
                            <a href="{{ asset('storage/'.$student->dob_photo_copy) }}"
                            class="btn btn-sm btn-outline-primary"
                            download>
                                Download DOB Proof
                            </a>
                        @else
                            <span class="text-muted">Not Uploaded</span>
                        @endif
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
