<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ClassSetupController;
use App\Http\Controllers\SchoolSetupController;
use App\Http\Controllers\StudentController;
use App\Http\Controllers\StaffController;
use App\Http\Controllers\FeeController;
use App\Http\Controllers\StudentFeeController;


Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.post');
Route::get('/register', [AuthController::class, 'showRegister'])->name('register');
Route::post('/register', [AuthController::class, 'doRegister'])->name('register.post');

Route::middleware(['auth'])->group(function(){
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');

    Route::get('/school-setup', [SchoolSetupController::class, 'index'])->name('school-setup');
    Route::post('/school-setup/save', [SchoolSetupController::class, 'saveSchoolDetails'])->name('school.save');
    Route::post('/school-setup/academic-year/add', [SchoolSetupController::class, 'addYear'])->name('year.add');
    Route::post('/school-setup/academic-year/update/{id}', [SchoolSetupController::class, 'updateYear'])->name('year.update');
    Route::delete('/school-setup/academic-year/{id}', [SchoolSetupController::class, 'deleteYear'])->name('year.delete');

    Route::post('/school-setup/session/add', [SchoolSetupController::class, 'addSession'])->name('session.add');
    Route::post('/school-setup/session/update/{id}', [SchoolSetupController::class, 'updateSession'])->name('session.update');
    Route::delete('/school-setup/session/{id}', [SchoolSetupController::class, 'deleteSession'])->name('session.delete');

    Route::get('/class-setup', [ClassSetupController::class, 'index'])->name('class-setup');
    Route::post('/class-setup/class/add', [ClassSetupController::class, 'addClass'])->name('class.add');
    Route::post('/class-setup/class/update/{id}', [ClassSetupController::class, 'updateClass'])->name('class.update');
    Route::delete('/class-setup/class/{id}', [ClassSetupController::class, 'deleteClass'])->name('class.delete');
    Route::post('/class-setup/section/add', [ClassSetupController::class, 'addSection'])->name('section.add');
    Route::delete('/class-setup/section/{id}', [ClassSetupController::class, 'deleteSection'])->name('section.delete');

    Route::get('classes/{class}/sections', function ($classId) {
        return \App\Models\SchoolSection::where('class_id', $classId)
            ->get();
    });

    Route::get('/students/search', [StudentController::class, 'search'])
        ->name('students.search');

    Route::resource('students', StudentController::class)->only(['index','create','store','show','edit','update','destroy']);
    Route::resource('staff', StaffController::class)->only(['index','create','store','show','edit','update','destroy']);

    Route::post('/staff/salary/pay', [StaffController::class, 'paySalary'])->name('staff.salary.pay');

    Route::get('/staff/salary/slip/{staff}/{month}',[StaffController::class, 'salarySlip'])->name('staff.salary.slip');

    Route::post('/staff/salary/pay-all-pending', [StaffController::class, 'payAllPendingSalaries'])->name('staff.pay-all-pending');

    Route::prefix('fees')->group(function () {
        Route::get('/', [FeeController::class,'index'])->name('fees.index');
        Route::post('/fee-head', [FeeController::class,'storeFeeHead'])->name('fees.storeFeeHead');
        Route::get('/fee-head/{feeHead}/edit', [FeeController::class,'editFeeHead'])->name('fees.editFeeHead');
        Route::put('/fee-head/{feeHead}', [FeeController::class,'updateFeeHead'])->name('fees.updateFeeHead');
        Route::delete('/fee-head/{feeHead}', [FeeController::class,'deleteFeeHead'])->name('fees.deleteFeeHead');

        Route::post('/class-fee', [FeeController::class,'storeClassFee'])->name('fees.storeClassFee');
        Route::get('/class-fee/{classFee}/edit', [FeeController::class,'editClassFee'])->name('fees.editClassFee');
        Route::put('/class-fee/{classFee}', [FeeController::class,'updateClassFee'])->name('fees.updateClassFee');
        Route::delete('/class-fee/{classFee}', [FeeController::class,'deleteClassFee'])->name('fees.deleteClassFee');
    });

    /* STUDENT FEES */
    Route::get('/student-fees', [StudentFeeController::class, 'index'])
        ->name('student-fees.index');

    /* AJAX – Fetch pending fees */
    Route::get('/student-fees/{student}/fees', [StudentFeeController::class, 'getStudentFees'])
        ->name('fee.collection.student');

    /* AJAX – Store payment */
    Route::post('/student-fees/collect', [StudentFeeController::class, 'storePayment'])
        ->name('fee.collection.store');

    Route::get('/student-fees/{student}/month-details',[StudentFeeController::class, 'monthDetails']
    )->name('student-fees.month.details');

    Route::get(
        '/student-fees/{student}/month-pending',
        [StudentFeeController::class, 'monthPendingFees']
    )->name('student-fees.month.pending');

    Route::post(
        '/student-fees/month/pay',
        [StudentFeeController::class, 'paySingleMonth']
    )->name('student-fees.month.pay');







    Route::get('reports', function () { return view('reports.index'); })->name('reports.index');
    Route::get('transport', function () { return view('transport.index'); })->name('transport.index');

    Route::get('fees-config', function () { return view('fees_config.index'); })->name('fees_config.index');
});

